/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.workmode;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nemgr.necommon.fault.TEAlarmAdapterCache;
import com.huawei.nglct.nemgr.necommon.workmode.TEWorkModeMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class TENEQueryWorkmodeBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    private int boardtype = -1;
    private int boardMode = -1;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        try {
            int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
            this.boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            ArrayList operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            boolean isSupportBoardMode = this.getSupportBoardMode(inputData);
            this.filterBoardModeCmd(operationList, isSupportBoardMode);
            return operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    private void filterBoardModeCmd(ArrayList operationList, boolean isSupportBoardMode) {
        Iterator it = operationList.iterator();
        while (it.hasNext()) {
            Operation oper = (Operation)it.next();
            if (isSupportBoardMode || !oper.getName().equals("NSCMD_CFG_GET_SUBBDTYPE")) continue;
            it.remove();
            break;
        }
    }

    private boolean getSupportBoardMode(Datainterface inputData) {
        String data = inputData.getBussinessParams().getRowParams(0).getParam("supportBoardMode").getValue();
        return data.equals("true");
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation oper = null;
        String mode = null;
        boolean flag = false;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            oper = (Operation)operationList.get(i);
            if ("NSCMD_CFG_GET_SUBBDTYPE".equals(oper.getName()) && String.valueOf(0).equals(oper.getOutput()[0].getFault(0).getCode())) {
                this.boardMode = Integer.valueOf(oper.getOutput()[0].getPart(oper.getOutput()[0].getPartCount() - 1).getValue());
                mode = QueryWDMMode.queryBoardMode((int)this.boardMode);
                TEAlarmAdapterCache.getInstatce().setBoardMode(neid, Integer.valueOf(oper.getInput().getPart(0).getValue()).intValue(), mode);
            }
            if (!"NSCMD_CFG_GET_PORTMODE".equals(oper.getName()) || !String.valueOf(0).equals(oper.getOutput()[0].getFault(0).getCode())) continue;
            flag = true;
        }
        super.handleMessage(neid, operationList, subfunc);
        if (flag) {
            this.handlePortMode();
        }
    }

    private void handlePortMode() {
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        TEWorkModeMgr workModeMgr = TEWorkModeMgr.getInstance();
        int len = bussinessParams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            int portID = Integer.parseInt(bussinessParams.getRowParams(i).getParam("port").getValue());
            Param param = bussinessParams.getRowParams(i).getParam("portworkmodel");
            ArrayList portModeList = workModeMgr.getPortModeList(this.neid, this.boardtype, this.boardMode, portID);
            int size = portModeList.size();
            for (int j = 0; j < size; ++j) {
                Integer portMode = (Integer)portModeList.get(j);
                param.addOption(new Option(String.valueOf(portMode)));
            }
        }
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append("res").append(File.separator).append("workmodel").append(File.separator).append("workmodel_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer strBuf = new StringBuffer();
        int slotid = 0;
        int boardtype = 0;
        if (rowparams.getParam("slotid") != null && rowparams.getParam("slotid").getValue() != null && !rowparams.getParam("slotid").getValue().equals("")) {
            strBuf.append(this.res.getString("boardname"));
            slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
            boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
            if (!"".equals(subrackname)) {
                strBuf.append(subrackname + "-");
            }
            strBuf.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)).append("-").append(TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype)).append(";");
        }
        if (rowparams.getParam("port") != null && rowparams.getParam("port").getValue() != null && !rowparams.getParam("port").getValue().equals("") && !rowparams.getParam("port").getValue().equals("0")) {
            strBuf.append(this.res.getString("portname"));
            strBuf.append(TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, Integer.parseInt(rowparams.getParam("port").getValue()))).append(";");
        }
        if (strBuf.length() == 0) {
            strBuf.append(this.subfunc.getSubFuncDes(this.neid));
        }
        return strBuf.toString();
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38737);
        return errorCodeList;
    }
}

