/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.TEWDMInfStaticData;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.TEWDMInfUtil;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.planningdata.TEPlanninDataHander;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.planningdata.TEPlanningDataJniMethod;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public abstract class TEWDMInfScriptHandler
implements TEScriptHandler {
    protected static final int INVALID_VALUE = -1;
    protected static final Logger logger = TELogFactory.getNormalLogger();
    protected static final String PARAM_BOARD = "board";
    protected static final String PARAM_PORT = "port";
    protected static final String PARAM_PATH = "path";
    protected static final String PARAM_PATH_STR = "pathstr";
    protected static final String PARAM_VALUE = "value";

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        StringBuffer tipBuffer = new StringBuffer();
        tipBuffer.append("Import script for wdm interface begin. neID->").append(neID).append("item->").append(item);
        logger.info(tipBuffer.toString());
        int retCode = 0;
        if (null == contents || contents.isEmpty()) {
            return retCode;
        }
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            logger.info("Not managed ne. neID->" + neID);
            return 0;
        }
        int attrID = this.getAttrID();
        String attrName = this.getAttrName();
        retCode = this.importGnlAttrbute(neID, attrID, attrName, contents);
        logger.info("Import script for wdm interface end.");
        return retCode;
    }

    protected abstract int getAttrID();

    protected abstract String getAttrName();

    protected abstract String getObjTypeStr();

    protected abstract int getObjTypeID();

    private int importGnlAttrbute(int neID, int attrID, String attrName, List<TEScriptCmd> contents) {
        int returnCode = 0;
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = null;
        for (TEScriptCmd cmd : contents) {
            element = this.parseElementFromCmd(neID, attrID, attrName, cmd);
            elementList.add(element);
        }
        TEDaoOperationResult result = TEWDMInfUtil.saveAttrInfoToDB(elementList, false);
        returnCode = result.getResult();
        return returnCode;
    }

    protected TEGnlValueElement parseElementFromCmd(int neID, int attrID, String attrName, TEScriptCmd cmd) {
        TEGnlValueElement element = new TEGnlValueElement();
        TEGeneralKeyValue key = this.constructElementKey(neID, attrID, cmd);
        TEGeneralValue value = this.constructElementValue(attrID, cmd);
        element.setGnlKeyValue(key);
        element.setGnlValue(value);
        return element;
    }

    private TEGeneralKeyValue constructElementKey(int neID, int attrID, TEScriptCmd cmd) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(attrID);
        key.setTEOBJECTID(this.parseObjTypeID(neID, cmd));
        return key;
    }

    private TEGeneralValue constructElementValue(int attrID, TEScriptCmd cmd) {
        TEGeneralValue value = new TEGeneralValue();
        int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(attrID);
        ArrayList paraValueList = new ArrayList();
        cmd.getPara(PARAM_VALUE, paraValueList, false);
        String valueStr = (String)paraValueList.get(0);
        if (0 == valueType) {
            value.setiValue(Integer.parseInt(valueStr));
        } else {
            value.setsValue(valueStr);
        }
        return value;
    }

    protected int[] parseObjTypeID(int neID, TEScriptCmd cmd) {
        int slotID = -1;
        int portID = -1;
        int pathID = -1;
        ArrayList paraValueList = new ArrayList();
        paraValueList.clear();
        boolean isParamExist = cmd.getPara(PARAM_BOARD, paraValueList, false);
        if (isParamExist) {
            String board = (String)paraValueList.get(0);
            slotID = Integer.parseInt(board.split("-")[0]);
        }
        paraValueList.clear();
        isParamExist = cmd.getPara(PARAM_PORT, paraValueList, false);
        if (isParamExist) {
            portID = Integer.parseInt((String)paraValueList.get(0));
        }
        paraValueList.clear();
        if (TEPlanninDataHander.isNewOtnModeBoard(neID, slotID)) {
            isParamExist = cmd.getPara(PARAM_PATH_STR, paraValueList, false);
            if (isParamExist) {
                String showPath = (String)paraValueList.get(0);
                int nmpath = TEOTNModelShowPathMgr.getInstance().getPathFromOTNModelShowPath(showPath);
                pathID = TEPlanninDataHander.getNePath(neID, slotID, nmpath);
            }
        } else {
            isParamExist = cmd.getPara(PARAM_PATH, paraValueList, false);
            if (isParamExist) {
                pathID = Integer.parseInt((String)paraValueList.get(0));
            }
        }
        TIntArrayList objIDList = new TIntArrayList();
        objIDList.add(this.getObjTypeID());
        objIDList.add(neID);
        if (-1 != slotID) {
            objIDList.add(slotID);
        }
        if (-1 != portID) {
            portID = TEQueryPortForDataMgr.getAbstractPortID((int)neID, (int)portID);
            objIDList.add(portID);
        }
        if (-1 != pathID) {
            objIDList.add(pathID);
        }
        int[] tEOBJECTID = objIDList.toNativeArray();
        return tEOBJECTID;
    }

    public int doExport(int neID, int item) {
        logger.info("Marine export cable to script begin.");
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return 0;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return 1090596385;
        }
        int slotID = -1;
        int boardType = -1;
        TEGenAttrObjectValue attrValue = null;
        TIntObjectHashMap portAttrMap = null;
        Vector boardList = TEPlanningDataJniMethod.getBoardList(neID);
        TEGenCfgFunCmd funCmd = TEPlanninDataHander.getFunCmd(ne);
        List<TEGenCfgPortAttribute> attributeList = null;
        ArrayList<TEGenAttrObjectValue> attrValueList = new ArrayList<TEGenAttrObjectValue>();
        for (TEBoard board : boardList) {
            slotID = board.getSlotID();
            boardType = board.getBoardType();
            String attrName = this.getAttrName();
            portAttrMap = TEGenCfgDataMgr.getPortAttrMap((int)neID, (String)attrName, (int)boardType);
            attributeList = TEPlanninDataHander.constructAttributeList((TIntObjectHashMap<List<TEGenCfgPortAttribute>>)portAttrMap);
            for (TEGenCfgPortAttribute attribute : attributeList) {
                attrValue = TEWDMInfScriptHandler.constructAttrValue(neID, slotID, funCmd, attrName, attribute);
                attrValueList.add(attrValue);
            }
        }
        int result = this.writeExportDataToScript(attrValueList, neID, item);
        logger.info("Set planning data to ne end.");
        return result;
    }

    private int writeExportDataToScript(List<TEGenAttrObjectValue> attrValueList, int neID, int item) {
        int result = 0;
        TEScriptCmd cmd = null;
        for (TEGenAttrObjectValue attrObjectValue : attrValueList) {
            cmd = new TEScriptCmd();
            cmd.setCmdCode(item);
            this.constractScriptCmd(cmd, attrObjectValue);
            result = TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
            if (0 == result) continue;
            break;
        }
        return result;
    }

    protected abstract void constractScriptCmd(TEScriptCmd var1, TEGenAttrObjectValue var2);

    public static TEGenAttrObjectValue constructAttrValue(int neID, int slotID, TEGenCfgFunCmd funCmd, String attrName, TEGenCfgPortAttribute attribute) {
        int portID = attribute.getPort();
        int pathID = attribute.getPath();
        pathID = TEPlanninDataHander.getNmPath(neID, slotID, portID, pathID, funCmd, attrName);
        String objTypeStr = TEWDMInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEPartSource partSource = TEPlanninDataHander.constructPartSource(slotID, portID, pathID);
        int intObjectID = TEWDMInfStaticData.getObjTypeNameIDMap().get(objTypeStr);
        TEGenObjectID objectID = new TEGenObjectID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSource));
        TEGenAttrObjectValue attrValue = new TEGenAttrObjectValue();
        attrValue.setObjectID(objectID);
        int attrID = TEWDMInfUtil.getAttrID(attrName);
        partSource = TEPlanninDataHander.constructPartSource(slotID, portID, attribute.getPath());
        String value = TEWDMInfScriptHandler.getAttrValueFromDB(neID, attrName, objTypeStr, partSource, attrID);
        TEGenValue genValue = new TEGenValue();
        genValue.setAttrID(attrID);
        genValue.setAttrName(attrName);
        genValue.setValue(value);
        ArrayList<TEGenValue> attrIDList = new ArrayList<TEGenValue>();
        attrIDList.add(genValue);
        attrValue.setAttrIDList(attrIDList);
        attrValue.setMitLockType((byte)0);
        return attrValue;
    }

    private static String getAttrValueFromDB(int neID, String attrName, String objTypeStr, TEPartSource partSource, int attrID) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(attrID);
        int intObjectID = TEObjTypeIDCreator.getInstance().getObjTypeID(neID, attrName, objTypeStr, partSource);
        key.setTEOBJECTID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSource));
        String value = TEWDMInfUtil.getAttrValueFromDB_NoLock(key);
        return value;
    }
}

