/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.frame.attrvaluernge.MatchData;
import com.huawei.nglct.gencfg.frame.attrvaluernge.TEGnlAttrRangeMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.SlotObject;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.TEServiceTypeKey;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.TEWDMInfUtil;
import com.huawei.nglct.nemgr.marine.wdminterface_u2kv1r7c00.WdmInterfaceRowDataProcessorIF;
import com.huawei.nglct.nemgr.necommon.workmode.TEWorkModeMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServiceTypeRowDataProcessor
implements WdmInterfaceRowDataProcessorIF {
    private static TETimeBuffer<SlotObject, Integer> slotModeBuffer = new TETimeBuffer();
    private static TETimeBuffer<SlotObject, Map<Integer, Integer>> portModeBuffer = new TETimeBuffer();

    @Override
    public void specialProcessRowData(Datainterface outputData, int neid, int rowPosition) {
        RowParams rowParams = outputData.getBussinessParams().getRowParams(rowPosition);
        if (null != rowParams.getParam("W32PORT_ATTR_ST_SERVICETYPE") && null != rowParams.getParam("W32PORT_ATTR_ST_SERVICETYPE").getValue() && !"".equals(rowParams.getParam("W32PORT_ATTR_ST_SERVICETYPE").getValue()) && !"/".equals(rowParams.getParam("W32PORT_ATTR_ST_SERVICETYPE").getValue()) || null != rowParams.getParam("W32PORT_ATTR_ST_SERVICETYPE_2")) {
            String portStr = rowParams.getParam("port").getValue();
            String slotidStr = rowParams.getParam("slotid").getValue();
            String pathStr = rowParams.getParam("path").getValue();
            int slotID = Integer.parseInt(slotidStr);
            int portID = Integer.parseInt(portStr);
            int pathID = Integer.parseInt(pathStr);
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
            TEServiceTypeKey key = new TEServiceTypeKey();
            key.setBoardType(boardType);
            key.setNeVersion((int)ServiceTypeRowDataProcessor.getNeVersion(neid));
            key.setPathid(pathID);
            key.setPortid(portID);
            key.setSlotid(slotID);
            key.setNeid(neid);
            List<Integer> serviceType = ServiceTypeRowDataProcessor.getServiceType(key);
            String temp = serviceType.toString();
            rowParams.addParam("serviceType", temp.substring(1, temp.length() - 1).replaceAll(" ", ""));
        }
    }

    public static int getBoardMode(int neid, int slotID) {
        int boardMode = -1;
        if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)slotID, (String)"W32BD_ATTR_SUBBDTYPE")) {
            try {
                boardMode = (Integer)slotModeBuffer.get((Object)new SlotObject(neid, slotID));
            }
            catch (TEUnknowmKeyTypeException e) {
                TELogFactory.getNormalLogger().error("get cp mode failed!", (Throwable)e);
            }
            catch (UnkownRefresherException e) {
                TELogFactory.getNormalLogger().error("get cp mode failed!", (Throwable)e);
            }
        }
        return boardMode;
    }

    protected static long getNeVersion(int neID) {
        TENE neObj = TENEListMgr.getInstance().getNE(neID);
        String neVersion = neObj.getHostVersion();
        long version = Long.parseLong(neVersion.replace(".", ""));
        return version;
    }

    public static List<Integer> getServiceType(TEServiceTypeKey key) {
        ArrayList serviceType;
        int neid = key.getNeid();
        int slotid = key.getSlotid();
        int portid = key.getPortid();
        int pathid = key.getPathid();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        int tempboardMode = -1;
        int tempPortMode = -1;
        try {
            Map portModeMap;
            if (TEWorkModeMgr.getInstance().isSupportPortMode(boardType, -1)) {
                portModeMap = (Map)portModeBuffer.get((Object)new SlotObject(neid, slotid));
                tempboardMode = (Integer)portModeMap.get(portid);
            }
            if (boardType == 1620 && (tempboardMode = ((Integer)slotModeBuffer.get((Object)new SlotObject(neid, slotid))).intValue()) == 20) {
                portModeMap = (Map)portModeBuffer.get((Object)new SlotObject(neid, slotid));
                tempboardMode = (Integer)portModeMap.get(ServiceTypeRowDataProcessor.getELOMPortID(portid));
            }
            if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)slotid, (String)"W32BD_ATTR_SUBBDTYPE") || TEWorkModeMgr.getInstance().isSupportBoardMode(boardType)) {
                Map portModeMap2;
                int dependPort;
                tempboardMode = (Integer)slotModeBuffer.get((Object)new SlotObject(neid, slotid));
                if (TEWorkModeMgr.getInstance().isSupportBoardMode(boardType) && -1 != (dependPort = TEWorkModeMgr.getInstance().getDependPortID(neid, boardType, tempboardMode, portid)) && (portModeMap2 = (Map)portModeBuffer.get((Object)new SlotObject(neid, slotid))) != null) {
                    tempPortMode = (Integer)portModeMap2.get(dependPort);
                }
            }
        }
        catch (TEUnknowmKeyTypeException e) {
            TELogFactory.getNormalLogger().error("get cp mode failed!", (Throwable)e);
        }
        catch (UnkownRefresherException e) {
            TELogFactory.getNormalLogger().error("get cp mode failed!", (Throwable)e);
        }
        catch (NullPointerException e) {
            TELogFactory.getNormalLogger().error("get port Mode failed!", (Throwable)e);
        }
        boolean isContain = TEGnlAttrRangeMgr.getInstance().isContainAttrID("W32PORT_ATTR_ST_SERVICETYPE");
        if (isContain) {
            List serviceType2;
            MatchData data = new MatchData();
            int logicPortType = ServiceTypeRowDataProcessor.getLogiPortType(neid, slotid, portid);
            data.setBoardType(boardType);
            data.setNeVersion((long)((int)ServiceTypeRowDataProcessor.getNeVersion(neid)));
            data.setPortid(portid);
            data.setPathid(pathid);
            data.addMacthParam("boardmode", (Object)String.valueOf(tempboardMode));
            data.addMacthParam("portype", (Object)String.valueOf(logicPortType));
            if (-1 != tempPortMode) {
                data.addMacthParam("portmode", (Object)String.valueOf(tempPortMode));
            }
            if ((serviceType2 = TEGnlAttrRangeMgr.getInstance().getAttrValueRageByList("W32PORT_ATTR_ST_SERVICETYPE", data)) != null) {
                return serviceType2;
            }
        }
        if (boardType == 1573) {
            serviceType = TEConfigurationDataMgr.getInstance().getSupportXCLevelList(neid, boardType, portid, tempboardMode, slotid, pathid);
            if (serviceType.size() == 0) {
                serviceType.add(0);
            }
        } else {
            TENE ne = TENEListMgr.getInstance().getNE(neid);
            serviceType = TEConfigurationDataMgr.getInstance().getSupportServiceType(neid, boardType, portid, ne.getNEVersion());
        }
        return serviceType;
    }

    private static int getELOMPortID(int portid) {
        if (portid >= 3 && portid <= 10) {
            return portid - 2 + 200;
        }
        return portid;
    }

    protected static int getLogiPortType(int neID, int slotID, int portID) {
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            try {
                Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_PORT");
                ArrayList<Operation> operationList = new ArrayList<Operation>();
                Operation tmpOper = null;
                Input input = null;
                tmpOper = (Operation)oper.clone();
                input = tmpOper.getInput();
                input.getPart("slotID").setValue(String.valueOf(slotID));
                input.getPart("portID").setValue(String.valueOf(portID));
                operationList.add(tmpOper);
                int resualt = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)60).retCode;
                if (resualt == 0) {
                    int iLen = operationList.size();
                    for (int i = 0; i < iLen; ++i) {
                        tmpOper = (Operation)operationList.get(i);
                        if (!tmpOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                        return Integer.parseInt(tmpOper.getOutput(0).getPartValue("portType"));
                    }
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().info(e.getMessage());
            }
            return 255;
        }
        TEPort port = TEConfigurationDataMgr.getInstance().getPort(neID, slotID, portID);
        if (port != null) {
            return port.getPortAddibleType();
        }
        return 255;
    }

    static {
        slotModeBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof SlotObject) {
                    SlotObject obj = (SlotObject)key;
                    String serviceBoardMode = QueryWDMMode.queryBoardMode((int)obj.neid, (int)obj.slotid);
                    return QueryWDMMode.convertBoardMode((String)serviceBoardMode);
                }
                throw new TEUnknowmKeyTypeException(key.toString() + " is unkown key type!");
            }
        });
        portModeBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof SlotObject) {
                    SlotObject obj = (SlotObject)key;
                    return TEWDMInfUtil.getPortModeByBoard(obj.neid, obj.slotid);
                }
                throw new TEUnknowmKeyTypeException(key.toString() + " is unkown key type!");
            }
        });
    }
}

