/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.wdminterface;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgSetBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.marine.TEAlarmAdapterCache;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TESetWDMInterface
extends TEGenCfgSetBean {
    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        String operName = "";
        String portName = "";
        int portid = 0;
        int slotid = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation operation = (Operation)operationList.get(i);
            int errorCode = Integer.parseInt(operation.getOutput()[0].getFault(0).getCode());
            if (errorCode != 0) continue;
            operName = operation.getName();
            if ("NSCMD_CFG_SET_PORT_NAME".equalsIgnoreCase(operName)) {
                portName = operation.getInput().getPart("W32PORT_ATTR_NAME").getValue();
                portid = Integer.parseInt(operation.getInput().getPart("port").getValue());
                slotid = Integer.parseInt(operation.getInput().getPart("slotid").getValue());
                TEConfigurationDataMgr.getInstance().fillModifyPortName(neid, slotid, 0, portid, portName);
            }
            if ("NSCMD_CFG_SET_WDMMODE".equalsIgnoreCase(operName)) {
                portid = Integer.parseInt(operation.getInput().getPart("port").getValue());
                slotid = Integer.parseInt(operation.getInput().getPart("slotid").getValue());
                int wdmMode = Integer.parseInt(operation.getInput().getPart("W32PORT_ATTR_ST_SERVICEMODE").getValue());
                TEAlarmAdapterCache.getInstatce().wdmSetServeMode(neid, slotid, portid, wdmMode);
            }
            if (!"NSCMD_CFG_SET_PAYLOADTYPE".equalsIgnoreCase(operName)) continue;
            portid = Integer.parseInt(operation.getInput().getPart("port").getValue());
            slotid = Integer.parseInt(operation.getInput().getPart("slotid").getValue());
            int payLoad = Integer.parseInt(operation.getInput().getPart("W32PORT_ATTR_ST_SERVICETYPE").getValue());
            TEAlarmAdapterCache.getInstatce().wdmSetServeType(neid, slotid, portid, payLoad);
        }
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
    }

    public String specialHandle(String attrId, String attrValue, Datainterface inputData, String actvalue, TEResourceUtil res) {
        String value = "";
        String waveNo = "";
        String waveType = "";
        if (attrId.equals("W32PORT_ATTR_STDGAIN") || attrId.equals("W32PORT_ATTR_MAINBACKINIT") || attrId.equals("W32PORT_ATTR_MAINBACKTH") || attrId.equals("W32PORT_ATTR_MUTLOSSIN") || attrId.equals("W32PORT_ATTR_ATTENUATION") || attrId.equals("W32PORT_ATTR_RATEDPOWER") || attrId.equals("W32PORT_ATTR_GOALPOWER")) {
            if (1 == attrValue.length()) {
                return "0." + attrValue;
            }
            value = attrValue.substring(0, attrValue.length() - 1) + "." + attrValue.charAt(attrValue.length() - 1);
            return value;
        }
        if (attrId.equals("W32PORT_ATTR_CFGWAVELENTYPE")) {
            waveNo = inputData.getBussinessParams().getRowParams(0).getParam("W32PORT_ATTR_CFGWAVELENTYPE").getValue();
            waveType = inputData.getBussinessParams().getRowParams(0).getParam("W32BRD_ATTR_CFGWDMTYPE").getValue();
            value = TEWaveLengthInfoStaticData.getInstance().getNumberWaveLengthFrequency(Integer.parseInt(waveType), Integer.parseInt(waveNo));
            return value;
        }
        if (attrId.equals("W32BRD_ATTR_CFGUPDOWNWAVE")) {
            waveNo = inputData.getBussinessParams().getRowParams(0).getParam("W32BRD_ATTR_CFGUPDOWNWAVE").getValue();
            waveType = inputData.getBussinessParams().getRowParams(0).getParam("W32BRD_ATTR_CFGUPDOWNWDMTYPE").getValue();
            value = TEWaveLengthInfoStaticData.getInstance().getNumberWaveLengthFrequency(Integer.parseInt(waveType), Integer.parseInt(waveNo));
            return value;
        }
        if (attrId.equals("W32BRD_ATTR_MDBANDLOG")) {
            String hexValue = Integer.toHexString(Integer.parseInt(attrValue));
            if (hexValue.length() == 7) {
                return Integer.parseInt(hexValue.substring(0, 1), 16) + "," + Integer.parseInt(hexValue.substring(1, 3), 16);
            }
            return Integer.parseInt(hexValue.substring(0, 2), 16) + "," + Integer.parseInt(hexValue.substring(2, 4), 16);
        }
        if (attrId.equals("W32BRD_ATTR_CAPACITY")) {
            return "" + (float)Integer.parseInt(attrValue) / 10.0f;
        }
        if (attrId.equals("W32PORT_ATTR_SDCONDITION")) {
            return this.convertSDCondition(attrId, attrValue, res);
        }
        return attrValue;
    }

    private String convertSDCondition(String attrId, String attrValue, TEResourceUtil res) {
        int sdCon = -1;
        try {
            String condition = "";
            sdCon = Integer.parseInt(attrValue);
            if ((sdCon & 1) != 0) {
                condition = condition + "B1_SD,";
            }
            if ((sdCon & 2) != 0) {
                condition = condition + "SM_BIP8_SD,";
            }
            if ((sdCon & 4) != 0) {
                condition = condition + "PM_BIP8_SD,";
            }
            if ((sdCon & 8) != 0) {
                condition = condition + "OTUk_DEG,";
            }
            if ((sdCon & 0x10) != 0) {
                condition = condition + "ODUk_PM_DEG,";
            }
            if ((sdCon & 0x20) != 0) {
                condition = condition + "ODUk_TCM1_DEG,";
            }
            if ((sdCon & 0x40) != 0) {
                condition = condition + "ODUk_TCM2_DEG,";
            }
            if ((sdCon & 0x80) != 0) {
                condition = condition + "ODUk_TCM3_DEG,";
            }
            if ((sdCon & 0x100) != 0) {
                condition = condition + "ODUk_TCM4_DEG,";
            }
            if ((sdCon & 0x200) != 0) {
                condition = condition + "ODUk_TCM5_DEG,";
            }
            if ((sdCon & 0x400) != 0) {
                condition = condition + "ODUk_TCM6_DEG,";
            }
            return condition.substring(0, condition.length() - 1);
        }
        catch (NumberFormatException e) {
            return attrValue;
        }
    }

    public boolean isNeedHandle(String attrId, String attrValue) {
        return attrId.equals("W32PORT_ATTR_STDGAIN") || attrId.equals("W32PORT_ATTR_MAINBACKINIT") || attrId.equals("W32PORT_ATTR_MAINBACKTH") || attrId.equals("W32PORT_ATTR_MUTLOSSIN") || attrId.equals("W32PORT_ATTR_ATTENUATION") || attrId.equals("W32PORT_ATTR_CFGWAVELENTYPE") || attrId.equals("W32BRD_ATTR_CFGUPDOWNWAVE") || attrId.equals("W32BRD_ATTR_MDBANDLOG") || attrId.equals("W32PORT_ATTR_RATEDPOWER") || attrId.equals("W32PORT_ATTR_GOALPOWER") || attrId.equals("W32PORT_ATTR_SDCONDITION") || attrId.equals("W32BRD_ATTR_CAPACITY");
    }

    public boolean isThisAttrNeedLog(String attrId) {
        return !"W32PORT_ATTR_DIFATTENUATION".equals(attrId);
    }
}

