/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.staticdata;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class TEStaticDataMgr {
    private static TEStaticDataMgr instance;
    private Properties serviceTypeProperties = new Properties();

    private TEStaticDataMgr() {
    }

    public static synchronized TEStaticDataMgr getInstance() {
        if (instance == null) {
            instance = new TEStaticDataMgr();
        }
        return instance;
    }

    public Map<Integer, String> getServiceTypeByID(List<Integer> serviceID) {
        HashMap<Integer, String> serviceTypeMap = new HashMap<Integer, String>();
        if (this.serviceTypeProperties.isEmpty()) {
            this.loadServiceTypeProperties();
        }
        for (int i = 0; i < serviceID.size(); ++i) {
            String key = "serviceType[" + serviceID.get(i).toString() + "]";
            String value = this.serviceTypeProperties.getProperty(key);
            serviceTypeMap.put(serviceID.get(i), value);
        }
        return serviceTypeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadServiceTypeProperties() {
        String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
        String cosParamFilePath = "nemgr" + File.separator + "marine" + File.separator + "conf" + File.separator + "wdminterface_u2kv1r7c00" + File.separator + "servicetype_" + LANGUAGE + ".properties";
        Reader reader = null;
        try {
            reader = new InputStreamReader(TEResourceManager.getInputStream((String)cosParamFilePath), Charset.forName("UTF-8"));
            this.serviceTypeProperties.load(reader);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("Load serviceTypeProperties failed!", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    TELogFactory.getNormalLogger().error("Close serviceTypeProperties file failed!", (Throwable)e);
                }
            }
        }
    }
}

