/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErrList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStructList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryLineStr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryLineStrList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryMarineLineReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryMarineLineRsp;
import com.huawei.nglct.nemgr.marine.bumanagement.TEBUQueryResourceLineBean;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineBUAndTypePair;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.QueryMarineNewLineBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineStruct;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEQueryLineData;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineDevicePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineSpanPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import gnu.trove.TIntArrayList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class TEQueryMarineLineHandler
extends TEBUQueryResourceLineBean {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private TETaskInfo info = null;

    public int handleRequest(AsnQueryMarineLineReq req, AsnQueryMarineLineRsp rsp, TaskMgr tm, TETaskInfo info) {
        this.info = info;
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnQueryMarineLineReq cReq = req;
        AsnQueryMarineLineRsp cRsp = rsp;
        this.userID = String.valueOf(cReq.userID);
        this.queryAllMarineLine(cReq);
        AsnQueryLineStrList asnLineStrList = cRsp.queryLineStrList;
        Iterator itMap = this.marineLineStrMap.entrySet().iterator();
        TEQueryLineData lineStr = null;
        AsnQueryLineStr lineStrInfo = null;
        if (!this.marineLineStrMap.isEmpty()) {
            int len = this.marineLineStrMap.size();
            for (int i = 0; i < len; ++i) {
                Map.Entry entry = itMap.next();
                lineStr = (TEQueryLineData)entry.getValue();
                lineStrInfo = TEMarineLinePubFun.mgrLine2AsnLine(lineStr, this.errorDetialList);
                asnLineStrList.add((Object)lineStrInfo);
            }
            this.checkEqptNameAndType(asnLineStrList);
        }
        cRsp.result.isSuccess = true;
        cRsp.result.retCode = BigInteger.valueOf(0L);
        AsnDetailErrList asnErrList = cRsp.detailRet;
        AsnDetailErr asnErr1 = null;
        if (null != this.errorDetialList && !this.errorDetialList.isEmpty()) {
            for (TEMarineLineError errObj : this.errorDetialList) {
                asnErr1 = new AsnDetailErr();
                asnErr1.cmdID = BigInteger.valueOf(errObj.getCmdID());
                asnErr1.object = errObj.getErrObject().getBytes();
                asnErr1.result.isSuccess = false;
                asnErr1.result.retCode = BigInteger.valueOf(errObj.getErrValue());
                asnErrList.add((Object)asnErr1);
            }
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(1090650126L);
        }
        return 0;
    }

    private void queryAllMarineLine(AsnQueryMarineLineReq cReq) {
        int neID = cReq.neList.get(0);
        TIntArrayList neList = null;
        if (0 == neID) {
            neList = TEMarineLinePubFun.getNeList();
        } else {
            neList = new TIntArrayList();
            int len = cReq.neList.size();
            for (int i = 0; i < len; ++i) {
                neList.add(cReq.neList.get(i));
            }
        }
        this.queryMarineLine(neList);
    }

    private void queryMarineLine(TIntArrayList neList) {
        if (null == neList) {
            return;
        }
        int errCode = 0;
        int len = neList.size();
        for (int i = 0; i < len; ++i) {
            RowParams[] rows;
            this.oneNELineStrMap.clear();
            int neID1 = neList.get(i);
            Datainterface din = new Datainterface();
            BussinessParams bus = new BussinessParams();
            din.setBussinessParams(bus);
            RowParams rp = new RowParams();
            bus.addRowParams(rp);
            Param p = null;
            p = new Param("neid", String.valueOf(neID1));
            rp.addParam(p);
            p = new Param("lineID", String.valueOf(0));
            rp.addParam(p);
            Datainterface allData = null;
            int sfid = 2179382;
            SubFunc subFunc = null;
            try {
                subFunc = TECreateObjectFactory.getSubFunc((int)neID1, (int)sfid);
            }
            catch (Exception e1) {
                TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e1);
            }
            QueryMarineNewLineBean bean = new QueryMarineNewLineBean();
            allData = bean.performBussinessProcess(neID1, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
            int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err && 0 != (errCode = this.getErrorDetial(neID1, allData, err))) {
                this.setErrorDetail(neID1, errCode);
                continue;
            }
            ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
            TEDaoNameValuePair neIDPair = new TEDaoNameValuePair();
            neIDPair.setName("NeID");
            neIDPair.setValue(String.valueOf(neID1));
            criteria.add(neIDPair);
            TEDaoOperationResult dbresult = null;
            try {
                dbresult = TECommonDaoService.deleteByID((int[])new int[]{neID1}, TESLMLinePO.class, criteria);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            }
            if (null == dbresult) continue;
            err = dbresult.getResult();
            if (0 != err) {
                this.getErrorDetial(neID1, allData, err);
            }
            bus = allData.getBussinessParams();
            for (RowParams row : rows = bus.getRowParams()) {
                this.getRowData(row, neID1);
            }
        }
        this.changeMarineData();
        this.fillMarineLineMO();
    }

    private void fillMarineLineMO() {
        if (null == this.neLineStrMap) {
            return;
        }
        Iterator itMap = this.neLineStrMap.entrySet().iterator();
        List neLineStrList = null;
        Set<TELineSpanPO> spanList = null;
        Set<TELineDevicePO> eqpList = null;
        List<TEMarineLineStruct.SpanStruct> spanStrList = null;
        List<TEMarineLineStruct.EqptStruct> eqptStrList = null;
        TESLMLinePO marineLine = null;
        int len = this.neLineStrMap.size();
        for (int i = 0; i < len; ++i) {
            Map.Entry entry = itMap.next();
            int neID = (Integer)entry.getKey();
            neLineStrList = (List)entry.getValue();
            for (TEMarineLineStruct lineObj : neLineStrList) {
                if (0 == neID) continue;
                marineLine = new TESLMLinePO();
                marineLine.setNeID((long)neID);
                marineLine.setLineID(lineObj.getLineID());
                marineLine.setLMUSlot(lineObj.getLmuSlot());
                marineLine.setLMUPort(1L);
                marineLine.setLASSlot(lineObj.getLasSlot());
                marineLine.setLASPort(lineObj.getLasPort());
                marineLine.setLMISlot(lineObj.getLmiSlot());
                marineLine.setLMIPort(2L);
                marineLine.setOppositeNEID(lineObj.getOpNeID());
                marineLine.setOppositeLMISlot(lineObj.getOpLmiSlot());
                marineLine.setOppositeLMIPort(2L);
                marineLine.setProbeWaveBand(lineObj.getProbeWaveBand());
                marineLine.setProbeWaveLenth(lineObj.getProbeWaveIndex());
                marineLine.setCompensatoryWaveBand(lineObj.getLoadingWaveBand());
                marineLine.setCompensatoryWaveLenth(lineObj.getLoadingWaveIndex());
                marineLine.setDirection(lineObj.getDirection());
                marineLine.setRemark(null == lineObj.getRemark() ? "" : lineObj.getRemark());
                marineLine.setSpanNum(lineObj.getSpanNum());
                marineLine.setEqptNum(lineObj.getEqptNum());
                spanStrList = lineObj.getSpanStrList();
                if (null != spanStrList) {
                    spanList = this.getSpanList(spanStrList);
                    marineLine.setSpanList(spanList);
                }
                if (null != (eqptStrList = lineObj.getEqptStrList())) {
                    eqpList = this.getEqptList(eqptStrList);
                    marineLine.setDeviceList(eqpList);
                }
                TEDaoOperationResult dbresult = null;
                try {
                    dbresult = TECommonDaoService.create((int[])new int[]{neID}, (Object)marineLine);
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
                }
                if (null == dbresult) {
                    return;
                }
                if (0 == dbresult.getResult()) continue;
                TELogFactory.getNormalLogger().error("save data fail!");
            }
        }
    }

    private Set<TELineSpanPO> getSpanList(List<TEMarineLineStruct.SpanStruct> spanStrList) {
        HashSet<TELineSpanPO> spanSet = new HashSet<TELineSpanPO>();
        TELineSpanPO spanPO1 = null;
        for (TEMarineLineStruct.SpanStruct spanObj : spanStrList) {
            spanPO1 = new TELineSpanPO();
            spanPO1.setSpanID(spanObj.getSpanID());
            spanPO1.setFiberType(spanObj.getFiberType());
            spanPO1.setRefractiveIndex(spanObj.getRefractiveIndex());
            spanPO1.setFiberLenth(spanObj.getFiberLenth());
            spanPO1.setAtteCoefficient(spanObj.getAtteCoefficient());
            spanSet.add(spanPO1);
        }
        return spanSet;
    }

    private Set<TELineDevicePO> getEqptList(List<TEMarineLineStruct.EqptStruct> eqptStrList) {
        HashSet<TELineDevicePO> eqptSet = new HashSet<TELineDevicePO>();
        TELineDevicePO eqptPO1 = null;
        for (TEMarineLineStruct.EqptStruct eqptObj : eqptStrList) {
            eqptPO1 = new TELineDevicePO();
            eqptPO1.setDeviceID(eqptObj.getEqptID());
            eqptPO1.setSpanID(eqptObj.getEqptSpan());
            eqptPO1.setDeviceType(eqptObj.getEqptType());
            eqptPO1.setRemark(eqptObj.getEqptName());
            eqptPO1.setDistance(eqptObj.getEqptPos());
            eqptSet.add(eqptPO1);
        }
        return eqptSet;
    }

    private void getRowData(RowParams rowParams1, int neid) {
        Param param = null;
        param = rowParams1.getParam("cmdCode");
        if (null == param) {
            return;
        }
        int cmdCode = Integer.parseInt(rowParams1.getParam("cmdCode").getValue());
        switch (cmdCode) {
            case 30440: {
                this.setMarineLineInfo(rowParams1, neid);
                break;
            }
            case 30449: {
                this.setLineWaveLen(rowParams1, neid);
                break;
            }
            case 30405: {
                this.setLineMemo(rowParams1, neid);
                break;
            }
            case 30409: {
                this.setLineSpanNum(rowParams1, neid);
                break;
            }
            case 30443: {
                this.setLineEqptNum(rowParams1, neid);
                break;
            }
            case 30411: {
                this.setLineFiberPara(rowParams1, neid);
                break;
            }
            case 30445: {
                this.setLineEqptPos(rowParams1, neid);
                break;
            }
        }
    }

    private void setLineWaveLen(RowParams row, int neid) {
        TEMarineLineStruct lineStr = this.getMarineLineStruct(row, neid);
        if (null != lineStr) {
            lineStr.setProbeWaveBand(Integer.parseInt(row.getParam("probeWaveBand").getValue()));
            lineStr.setProbeWaveIndex(Integer.parseInt(row.getParam("probeWaveIndex").getValue()));
            lineStr.setLoadingWaveBand(Integer.parseInt(row.getParam("loadingWaveBand").getValue()));
            lineStr.setLoadingWaveIndex(Integer.parseInt(row.getParam("loadingWaveIndex").getValue()));
        }
    }

    private void checkEqptNameAndType(AsnQueryLineStrList asnLineStrList) {
        if (null == asnLineStrList || asnLineStrList.isEmpty()) {
            return;
        }
        Set<TEMarineBUAndTypePair> buAndTypeSet = TEMarineBUUtil.getBUAndTypeList();
        TEMarineBUAndTypePair buTypePair = new TEMarineBUAndTypePair();
        int len = asnLineStrList.size();
        for (int i = 0; i < len; ++i) {
            AsnQueryLineStr asnLine = (AsnQueryLineStr)asnLineStrList.get(i);
            AsnEqptStructList asnEqptList = asnLine.eqptStrLst;
            if (asnEqptList.isEmpty()) continue;
            int eqptNum = asnEqptList.size();
            for (int j = 0; j < eqptNum; ++j) {
                AsnEqptStruct asnEqpt = (AsnEqptStruct)asnEqptList.get(j);
                buTypePair.setBuName(new String(asnEqpt.eqptName));
                buTypePair.setBuType(asnEqpt.eqptType.intValue());
                if (buTypePair.getBuType() == 3) continue;
                this.checkBUNameAndType(buTypePair, buAndTypeSet, asnLine);
            }
        }
    }

    private void checkBUNameAndType(TEMarineBUAndTypePair buTypePair, Set<TEMarineBUAndTypePair> buAndTypeSet, AsnQueryLineStr asnLine) {
        int errorCode = 0;
        if (buAndTypeSet.contains(buTypePair)) {
            for (TEMarineBUAndTypePair tmpBu : buAndTypeSet) {
                if (!tmpBu.getBuName().equals(buTypePair.getBuName()) || tmpBu.getBuType() == buTypePair.getBuType()) continue;
                errorCode = 1090615173;
            }
        } else {
            errorCode = 1090615228;
        }
        if (0 != errorCode) {
            TEMarineLineError errorObj = new TEMarineLineError();
            errorObj.setCmdID(30445);
            errorObj.setErrValue(errorCode);
            String errorObjStr = -1 == asnLine.srcLineStr.neID.intValue() ? "0-" : asnLine.srcLineStr.neID.toString() + "-";
            errorObjStr = errorObjStr + (-1 == asnLine.snkLineStr.neID.intValue() ? "0-" : asnLine.snkLineStr.neID.toString() + "-");
            int lineID = 0 == asnLine.srcLineStr.lineID.intValue() ? asnLine.snkLineStr.lineID.intValue() : asnLine.srcLineStr.lineID.intValue();
            errorObjStr = errorObjStr + lineID + "-" + buTypePair.getBuName();
            errorObj.setErrObject(errorObjStr);
            this.errorDetialList.add(errorObj);
        }
    }
}

