/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifySpanReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifySpanRsp;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStructList;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.ModifySpanBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEModifySpanHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private TETaskInfo info = null;
    private String userID;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        this.info = info;
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnModifySpanReq cReq = (AsnModifySpanReq)req;
        AsnModifySpanRsp cRsp = (AsnModifySpanRsp)rsp;
        this.userID = String.valueOf(cReq.userID);
        int srcErrCode = 0;
        int snkErrCode = 0;
        int srcNeID = cReq.neLine.srcNeID.intValue();
        int snkNeID = cReq.neLine.snkNeID.intValue();
        int lineID = cReq.neLine.lineID.intValue();
        int idleStatus = TEMarineLinePubFun.checkLineIsIdle(srcNeID, snkNeID, lineID);
        if (0 == idleStatus) {
            srcErrCode = this.modifySpanInfo(cReq, 1);
            if (-1 != cReq.neLine.snkNeID.intValue() && 0 != cReq.neLine.snkNeID.intValue()) {
                snkErrCode = this.modifySpanInfo(cReq, 0);
            }
            cRsp.detailRet = TEMarineLineError.getDetailErrInfo(this.errorDetialList);
            if (0 == srcErrCode && 0 == snkErrCode && this.errorDetialList.isEmpty()) {
                cRsp.result.isSuccess = true;
                cRsp.result.retCode = BigInteger.valueOf(0L);
            } else if (0 != srcErrCode && 0 != snkErrCode) {
                cRsp.result.isSuccess = false;
                cRsp.result.retCode = BigInteger.valueOf(2L);
            } else {
                cRsp.result.isSuccess = false;
                cRsp.result.retCode = BigInteger.valueOf(1L);
            }
        } else if (-1 == idleStatus) {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(1090615104L);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(idleStatus);
        }
        return 0;
    }

    private int modifySpanInfo(AsnModifySpanReq cReq, int direction) {
        this.errorDetialList.clear();
        int errCode = 0;
        int neID = 1 == direction ? cReq.neLine.srcNeID.intValue() : cReq.neLine.snkNeID.intValue();
        if (0 == neID || -1 == neID) {
            return 0;
        }
        int lineID = cReq.neLine.lineID.intValue();
        int spanNum = cReq.spanNum.intValue();
        AsnSpanStructList asnSpanList = cReq.spanStrLst;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        Param p = null;
        AsnSpanStruct asnSpan = null;
        RowParams rpSpan = null;
        int len = asnSpanList.size();
        for (int i = 0; i < len; ++i) {
            asnSpan = (AsnSpanStruct)asnSpanList.get(i);
            rpSpan = new RowParams();
            bus.addRowParams(rpSpan);
            p = new Param("neid", String.valueOf(neID));
            rpSpan.addParam(p);
            p = new Param("lineID", String.valueOf(lineID));
            rpSpan.addParam(p);
            int spanID = this.getModifyID(asnSpan.spanID.intValue(), spanNum, direction);
            p = new Param("spanNo", String.valueOf(spanID));
            rpSpan.addParam(p);
            p = new Param("fiberType", new String(asnSpan.fiberType));
            rpSpan.addParam(p);
            p = new Param("refractiveRate", asnSpan.refractiveIndex.toString());
            rpSpan.addParam(p);
            p = new Param("fiberLength", asnSpan.fiberLenth.toString());
            rpSpan.addParam(p);
            p = new Param("attenuation", asnSpan.atteCoefficient.toString());
            rpSpan.addParam(p);
        }
        Datainterface allData = null;
        int sfid = 2179385;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            normalLogger.error(e1.toString());
        }
        if (null == subFunc) {
            return 2;
        }
        ModifySpanBean neMgrBean = new ModifySpanBean();
        allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            TEMarineLinePubFun.setErrorDetial(String.valueOf(neID) + lineID + asnSpan.spanID.intValue(), err);
            return err;
        }
        TEModifySpanHandler.updateSpanStruct(cReq, direction, this.errorDetialList);
        return errCode;
    }

    public static void updateSpanStruct(AsnModifySpanReq cReq, int direction, List<TEMarineLineError> errorDetialList) {
        int neID = 1 == direction ? cReq.neLine.srcNeID.intValue() : cReq.neLine.snkNeID.intValue();
        int lineID = cReq.neLine.lineID.intValue();
        int spanNum = cReq.spanNum.intValue();
        AsnSpanStructList asnSpanList = cReq.spanStrLst;
        TEDaoOperationResult dbResult = null;
        TESLMLinePO tmpPO = null;
        try {
            List<Object> data = TESLMLineUtil.getSLMLinePOData(lineID);
            for (Object obj : data) {
                tmpPO = (TESLMLinePO)obj;
                if (lineID != tmpPO.LineID) continue;
                TEMarineLinePubFun.updateSpanList(spanNum, asnSpanList, tmpPO.getSpanList(), direction, errorDetialList);
                dbResult = TECommonDaoService.update((int[])new int[]{neID}, (Object)tmpPO);
                if (0 != dbResult.getResult()) {
                    normalLogger.error("Updata spanPO failed!");
                }
                return;
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
    }

    private int getModifyID(int asnID, int num, int direction) {
        if (1 == direction) {
            return asnID;
        }
        return num - asnID + 1;
    }
}

