/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifyRemarkReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifyRemarkRsp;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnNeLineStr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnNeLineStrList;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEModifyRemarkHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private List<TEMarineLineError> allErrorDetialList = new ArrayList<TEMarineLineError>();
    private TETaskInfo info = null;
    private String userID;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        this.info = info;
        AsnModifyRemarkReq cReq = (AsnModifyRemarkReq)req;
        AsnModifyRemarkRsp cRsp = (AsnModifyRemarkRsp)rsp;
        this.userID = String.valueOf(cReq.userID);
        String remark = new String(cReq.remark);
        AsnNeLineStrList neLineList = cReq.neLineList;
        AsnNeLineStr neLineStr = null;
        int len = neLineList.size();
        for (int i = 0; i < len; ++i) {
            TEMarineLineError errInfo;
            int lineID;
            int snkNeID;
            neLineStr = (AsnNeLineStr)neLineList.get(i);
            int srcNeID = neLineStr.srcNeID.intValue();
            int idleStatus = TEMarineLinePubFun.checkLineIsIdle(srcNeID, snkNeID = neLineStr.snkNeID.intValue(), lineID = neLineStr.lineID.intValue());
            if (0 == idleStatus) {
                this.modifyRemarkInfo(srcNeID, lineID, remark);
                if (-1 == snkNeID || 0 == snkNeID) continue;
                this.modifyRemarkInfo(snkNeID, lineID, remark);
                continue;
            }
            if (-1 == idleStatus) {
                errInfo = TEMarineLinePubFun.setErrorDetial(String.valueOf(srcNeID) + lineID, 1090615104);
                this.allErrorDetialList.add(errInfo);
                continue;
            }
            errInfo = TEMarineLinePubFun.setErrorDetial(String.valueOf(srcNeID) + lineID, idleStatus);
            this.allErrorDetialList.add(errInfo);
        }
        cRsp.detailRet = TEMarineLineError.getDetailErrInfo(this.allErrorDetialList);
        normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
        if (this.allErrorDetialList.isEmpty()) {
            cRsp.result.isSuccess = true;
            cRsp.result.retCode = BigInteger.valueOf(0L);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(1L);
        }
        return 0;
    }

    private void modifyRemarkInfo(int neid, int lineID, String remark) {
        this.allErrorDetialList.addAll(this.errorDetialList);
        this.errorDetialList.clear();
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        Param p = null;
        RowParams rp = null;
        rp = new RowParams();
        bus.addRowParams(rp);
        p = new Param("neid", String.valueOf(neid));
        rp.addParam(p);
        p = new Param("lineID", String.valueOf(lineID));
        rp.addParam(p);
        p = new Param("lineRemark", remark);
        rp.addParam(p);
        Datainterface allData = null;
        int sfid = 2179484;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
        }
        catch (Exception e1) {
            normalLogger.error(e1.toString());
        }
        if (null == subFunc) {
            return;
        }
        String classMapping = subFunc.getClassMapping();
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = null == classMapping ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        if (null == neMgrBean) {
            return;
        }
        allData = neMgrBean.performBussinessProcess(neid, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            TEMarineLineError errInfo = TEMarineLinePubFun.setErrorDetial(neid + "-" + lineID, err);
            this.errorDetialList.add(errInfo);
        } else {
            this.updateRemarkStruct(neid, lineID, remark);
        }
    }

    private void updateRemarkStruct(int neID, int lineID, String remark) {
        TEDaoOperationResult dbResult = null;
        TESLMLinePO tmpPO = null;
        try {
            List<Object> data = TESLMLineUtil.getSLMLinePOData(lineID);
            for (Object obj : data) {
                tmpPO = (TESLMLinePO)obj;
                if (lineID != tmpPO.LineID) continue;
                tmpPO.setRemark(remark);
                dbResult = TECommonDaoService.update((int[])new int[]{neID}, (Object)tmpPO);
                if (0 != dbResult.getResult()) {
                    normalLogger.error("Updata eqptPO failed!");
                }
                return;
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
    }
}

