/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStructList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnMarineLineStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifyMarineLineReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifyMarineLineRsp;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStructList;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.ModifyEqptBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.ModifyLineBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.ModifyRemarkBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.ModifySpanBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.ModifyWaveLenBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEModifyMarineLineHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private TESLMLinePO srcMarineLinePO = null;
    private TESLMLinePO snkMarineLinePO = null;
    private List<TESLMLinePO> srcLinePOList = new ArrayList<TESLMLinePO>();
    private List<TESLMLinePO> snkLinePOList = new ArrayList<TESLMLinePO>();
    private TETaskInfo info = null;
    private String userID;
    private int newLmuSlotID;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        this.info = info;
        normalLogger.info(TEAsn1Util.getAsn1String((Object)req));
        AsnModifyMarineLineReq cReq = (AsnModifyMarineLineReq)req;
        AsnModifyMarineLineRsp cRsp = (AsnModifyMarineLineRsp)rsp;
        this.userID = String.valueOf(cReq.userID);
        AsnMarineLineStruct asnSrcLine = cReq.srcLineStr;
        AsnMarineLineStruct asnSnkLine = cReq.snkLineStr;
        int srcNeID = asnSrcLine.neID.intValue();
        int snkNeID = asnSnkLine.neID.intValue();
        int lineID = asnSrcLine.lineID.intValue();
        String remark = new String(cReq.remark);
        String newRemark = new String(cReq.newRemark);
        int idleStatus = TEMarineLinePubFun.checkLineIsIdle(srcNeID, snkNeID, lineID);
        if (0 == idleStatus) {
            this.getMarineLinePO(srcNeID, snkNeID, lineID);
            if (-1 != cReq.srcLineStr.lmuSlotID.intValue()) {
                this.newLmuSlotID = cReq.srcLineStr.lmuSlotID.intValue();
                this.modifyMarineLine(asnSrcLine, 1);
            }
            if (-1 != cReq.snkLineStr.lmuSlotID.intValue()) {
                this.newLmuSlotID = cReq.snkLineStr.lmuSlotID.intValue();
                this.modifyMarineLine(asnSnkLine, 0);
            }
            this.modifyWaveLen(cReq.srcLineStr, 1);
            this.modifyWaveLen(cReq.snkLineStr, 0);
            this.modifySpanInfo(cReq);
            this.modifyEqptInfo(cReq);
            this.modifyRemark(srcNeID, lineID, remark, newRemark, 1);
            this.modifyRemark(snkNeID, lineID, remark, newRemark, 0);
            this.saveMarineLinePO(srcNeID, snkNeID);
            normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            cRsp.result.isSuccess = true;
            if (this.errorDetialList.isEmpty()) {
                cRsp.result.retCode = BigInteger.valueOf(0L);
            } else {
                cRsp.detailRet = TEMarineLineError.getDetailErrInfo(this.errorDetialList);
                cRsp.result.retCode = BigInteger.valueOf(1L);
            }
        } else if (-1 == idleStatus) {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(1090615104L);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(idleStatus);
        }
        return 0;
    }

    private void getMarineLinePO(int srcNeID, int snkNeID, int lineID) {
        TEDaoOperationResult dbResult = null;
        TESLMLinePO tmpPO = null;
        try {
            dbResult = TECommonDaoService.findAll((int[])new int[]{srcNeID}, TESLMLinePO.class);
            List data = dbResult.getData();
            for (Object obj : data) {
                tmpPO = (TESLMLinePO)obj;
                this.srcLinePOList.add(tmpPO);
                if (lineID != tmpPO.LineID) continue;
                this.srcMarineLinePO = tmpPO;
            }
            if (0 != snkNeID) {
                dbResult = TECommonDaoService.findAll((int[])new int[]{snkNeID}, TESLMLinePO.class);
                data = dbResult.getData();
                for (Object obj : data) {
                    tmpPO = (TESLMLinePO)obj;
                    this.snkLinePOList.add(tmpPO);
                    if (lineID != tmpPO.LineID) continue;
                    this.snkMarineLinePO = tmpPO;
                }
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
    }

    private void saveMarineLinePO(int srcNeID, int snkNeID) {
        TEDaoOperationResult dbResult = null;
        try {
            if (null != this.srcMarineLinePO && 0 != (dbResult = TECommonDaoService.update((int[])new int[]{srcNeID}, (Object)this.srcMarineLinePO)).getResult()) {
                normalLogger.error("Save LinePO failed!");
            }
            if (null != this.snkMarineLinePO && 0 != (dbResult = TECommonDaoService.update((int[])new int[]{snkNeID}, (Object)this.snkMarineLinePO)).getResult()) {
                normalLogger.error("Save LinePO failed!");
            }
            return;
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            return;
        }
    }

    private void filtLinePOList(int lmuSlotID, int direction) {
        TESLMLinePO linePO = null;
        List<TESLMLinePO> linePOList = 1 == direction ? this.srcLinePOList : this.snkLinePOList;
        for (int i = linePOList.size() - 1; i >= 0; --i) {
            linePO = linePOList.get(i);
            if (linePO.getLMUSlot() == (long)lmuSlotID) continue;
            linePOList.remove(linePO);
        }
    }

    private int modifyMarineLine(AsnMarineLineStruct asnLineStr, int direction) {
        if (null == asnLineStr) {
            return 0;
        }
        int neID = asnLineStr.neID.intValue();
        int lineID = asnLineStr.lineID.intValue();
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        Param p = null;
        RowParams rp = new RowParams();
        bus.addRowParams(rp);
        p = new Param("neid", String.valueOf(neID));
        rp.addParam(p);
        p = new Param("lineID", String.valueOf(lineID));
        rp.addParam(p);
        p = new Param("lmuSlot", String.valueOf(asnLineStr.lmuSlotID));
        rp.addParam(p);
        p = new Param("lasSlot", String.valueOf(asnLineStr.lasSlotID));
        rp.addParam(p);
        p = new Param("lasPort", String.valueOf(asnLineStr.lasPortID));
        rp.addParam(p);
        Datainterface allData = null;
        int sfid = 2179383;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            normalLogger.error(e1.toString());
        }
        if (null == subFunc) {
            return 0;
        }
        ModifyLineBean bean = new ModifyLineBean();
        allData = bean.performBussinessProcess(neID, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            TEMarineLineError errInfo = TEMarineLinePubFun.setErrorDetial(neID + "-" + lineID, err);
            this.errorDetialList.add(errInfo);
            return err;
        }
        this.updateMarineLine(asnLineStr, direction);
        return 0;
    }

    private void updateMarineLine(AsnMarineLineStruct asnLineStr, int direction) {
        if (1 == direction && null != this.srcMarineLinePO) {
            this.srcMarineLinePO.setLMUSlot((long)asnLineStr.lmuSlotID.intValue());
            this.srcMarineLinePO.setLASSlot((long)asnLineStr.lasSlotID.intValue());
            this.srcMarineLinePO.setLASPort((long)asnLineStr.lasPortID.intValue());
        } else if (null != this.snkMarineLinePO) {
            this.snkMarineLinePO.setLMUSlot((long)asnLineStr.lmuSlotID.intValue());
            this.snkMarineLinePO.setLASSlot((long)asnLineStr.lasSlotID.intValue());
            this.snkMarineLinePO.setLASPort((long)asnLineStr.lasPortID.intValue());
        }
    }

    private void modifyWaveLen(AsnMarineLineStruct lineStr, int direction) {
        if (-1 == lineStr.probeWaveBand.intValue()) {
            return;
        }
        int neID = lineStr.neID.intValue();
        int lineID = lineStr.lineID.intValue();
        Datainterface datainterface = new Datainterface();
        BussinessParams bus = new BussinessParams();
        datainterface.setBussinessParams(bus);
        Param p = null;
        RowParams rp = null;
        rp = new RowParams();
        bus.addRowParams(rp);
        p = new Param("neid", String.valueOf(neID));
        rp.addParam(p);
        p = new Param("lineID", String.valueOf(lineID));
        rp.addParam(p);
        p = new Param("probeWaveBand", String.valueOf(lineStr.probeWaveBand));
        rp.addParam(p);
        p = new Param("probeWaveIndex", String.valueOf(lineStr.probeWaveIndex));
        rp.addParam(p);
        p = new Param("loadingWaveBand", String.valueOf(lineStr.loadingWaveBand));
        rp.addParam(p);
        p = new Param("loadingWaveIndex", String.valueOf(lineStr.loadingWaveIndex));
        rp.addParam(p);
        Datainterface allData = null;
        int sfid = 2179383;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            normalLogger.error(e1.toString());
        }
        if (null == subFunc) {
            return;
        }
        ModifyWaveLenBean bean = new ModifyWaveLenBean();
        allData = bean.performBussinessProcess(neID, subFunc, datainterface, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            TEMarineLinePubFun.setErrorDetial(neID + "-" + lineID, err);
            return;
        }
        this.updateWaveLen(lineStr, direction);
    }

    private void updateWaveLen(AsnMarineLineStruct lineStr, int direction) {
        if (1 == direction && null != this.srcMarineLinePO) {
            this.srcMarineLinePO.setProbeWaveBand(lineStr.probeWaveBand.intValue());
            this.srcMarineLinePO.setProbeWaveLenth(lineStr.probeWaveIndex.intValue());
            this.srcMarineLinePO.setCompensatoryWaveBand(lineStr.loadingWaveBand.intValue());
            this.srcMarineLinePO.setCompensatoryWaveLenth(lineStr.loadingWaveIndex.intValue());
        } else if (null != this.snkMarineLinePO) {
            this.snkMarineLinePO.setProbeWaveBand(lineStr.probeWaveBand.intValue());
            this.snkMarineLinePO.setProbeWaveLenth(lineStr.probeWaveIndex.intValue());
            this.snkMarineLinePO.setCompensatoryWaveBand(lineStr.loadingWaveBand.intValue());
            this.snkMarineLinePO.setCompensatoryWaveLenth(lineStr.loadingWaveIndex.intValue());
        }
    }

    private void modifySpanInfo(AsnModifyMarineLineReq cReq) {
        int newSpanNum;
        AsnMarineLineStruct srcLine = cReq.srcLineStr;
        AsnMarineLineStruct snkLine = cReq.snkLineStr;
        if (null == srcLine) {
            return;
        }
        AsnSpanStructList asnSpanList = cReq.spanStrLst;
        int srcNeID = srcLine.neID.intValue();
        int snkNeID = snkLine.neID.intValue();
        int lineID = srcLine.lineID.intValue();
        int spanNum = cReq.spanNum.intValue();
        if (spanNum != (newSpanNum = cReq.newSpanNum.intValue())) {
            if (spanNum < newSpanNum) {
                this.addNewSpanList(newSpanNum - spanNum, asnSpanList);
            }
            this.modifySrcSpanStr(srcNeID, lineID, newSpanNum, asnSpanList);
            if (0 != snkNeID) {
                this.modifySnkSpanStr(snkNeID, lineID, newSpanNum, asnSpanList);
            }
        }
    }

    private void addNewSpanList(int num, AsnSpanStructList asnSpanList) {
        AsnSpanStruct spanStr = null;
        int asnSpanListSize = asnSpanList.size();
        for (int i = 0; i < num; ++i) {
            spanStr = new AsnSpanStruct();
            spanStr.spanID = BigInteger.valueOf(asnSpanListSize + i + 1);
            spanStr.fiberType = "TYPE NOT SET".getBytes();
            spanStr.atteCoefficient = BigInteger.valueOf(20L);
            spanStr.fiberLenth = BigInteger.valueOf(800L);
            spanStr.refractiveIndex = BigInteger.valueOf(1460L);
            spanStr.isConsistent = BigInteger.valueOf(0L);
            asnSpanList.add((Object)spanStr);
        }
    }

    private void modifySrcSpanStr(int neid, int lineID, int newSpanNum, AsnSpanStructList asnSpanList) {
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        Param param = null;
        RowParams rowParams = null;
        rowParams = new RowParams();
        bus.addRowParams(rowParams);
        param = new Param("neid", String.valueOf(neid));
        rowParams.addParam(param);
        param = new Param("lineID", String.valueOf(lineID));
        rowParams.addParam(param);
        param = new Param("spanNum", String.valueOf(newSpanNum));
        rowParams.addParam(param);
        Datainterface allData = null;
        int sfid = 2179383;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
        }
        catch (Exception ex) {
            normalLogger.error(ex.toString());
        }
        if (null == subFunc) {
            return;
        }
        ModifySpanBean bean = new ModifySpanBean();
        allData = bean.performBussinessProcess(neid, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            TEMarineLinePubFun.setErrorDetial(neid + "-" + lineID, err);
            return;
        }
        this.updataSpanPO(newSpanNum, asnSpanList, 1);
    }

    private void modifySnkSpanStr(int neid, int lineID, int newSpanNum, AsnSpanStructList asnSpanList) {
        if (0 == neid) {
            return;
        }
        int errCode = 0;
        Datainterface din = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        din.setBussinessParams(bParams);
        Param p = null;
        RowParams rp = null;
        rp = new RowParams();
        bParams.addRowParams(rp);
        p = new Param("neid", String.valueOf(neid));
        rp.addParam(p);
        p = new Param("lineID", String.valueOf(lineID));
        rp.addParam(p);
        p = new Param("spanNum", String.valueOf(newSpanNum));
        rp.addParam(p);
        AsnSpanStruct asnSpan = null;
        int len = asnSpanList.size();
        for (int i = 0; i < len; ++i) {
            asnSpan = (AsnSpanStruct)asnSpanList.get(i);
            int spanID = TEMarineLinePubFun.getNERelID(i + 1, newSpanNum, 0);
            rp = new RowParams();
            bParams.addRowParams(rp);
            p = new Param("neid", String.valueOf(neid));
            rp.addParam(p);
            p = new Param("lineID", String.valueOf(lineID));
            rp.addParam(p);
            p = new Param("spanNo", String.valueOf(spanID));
            rp.addParam(p);
            p = new Param("fiberType", new String(asnSpan.fiberType));
            rp.addParam(p);
            p = new Param("refraction", String.valueOf(asnSpan.refractiveIndex));
            rp.addParam(p);
            p = new Param("fiberLenth", String.valueOf(asnSpan.fiberLenth));
            rp.addParam(p);
            p = new Param("attenuation", String.valueOf(asnSpan.atteCoefficient));
            rp.addParam(p);
        }
        Datainterface allData = null;
        int sfid = 2179383;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
        }
        catch (Exception e2) {
            normalLogger.error(e2.toString());
        }
        if (null == subFunc) {
            return;
        }
        ModifySpanBean bean = new ModifySpanBean();
        allData = bean.performBussinessProcess(neid, subFunc, din, null, "", "");
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            errCode = this.getErrorDetial(neid, allData, err);
        }
        if (0 == errCode) {
            this.updataSpanPO(newSpanNum, asnSpanList, 0);
        }
    }

    private void updataSpanPO(int newSpanNum, AsnSpanStructList asnSpanList, int direction) {
        Set spanPOSet = null;
        if (1 == direction && null != this.srcMarineLinePO) {
            spanPOSet = this.srcMarineLinePO.getSpanList();
        } else if (null != this.snkMarineLinePO) {
            spanPOSet = this.snkMarineLinePO.getSpanList();
        }
        if (null != asnSpanList && null != spanPOSet) {
            TEMarineLinePubFun.updateSpanList(newSpanNum, asnSpanList, spanPOSet, direction, this.errorDetialList);
        }
    }

    private void modifyEqptInfo(AsnModifyMarineLineReq cReq) {
        AsnMarineLineStruct srcLine = cReq.srcLineStr;
        AsnMarineLineStruct snkLine = cReq.snkLineStr;
        if (null == srcLine) {
            return;
        }
        AsnEqptStructList asnEqptList = cReq.eqptStrLst;
        int srcNeID = srcLine.neID.intValue();
        int snkNeID = snkLine.neID.intValue();
        int lineID = srcLine.lineID.intValue();
        int eqptNum = cReq.eqptNum.intValue();
        int newEqptNum = cReq.newEqptNum.intValue();
        int spanNum = cReq.newSpanNum.intValue();
        if (asnEqptList.isEmpty() && eqptNum == newEqptNum) {
            return;
        }
        this.modifyEqptStr(srcNeID, lineID, newEqptNum, spanNum, asnEqptList, 1);
        if (0 != snkNeID) {
            this.modifyEqptStr(snkNeID, lineID, newEqptNum, spanNum, asnEqptList, 0);
        }
    }

    private void modifyEqptStr(int neid, int lineID, int newEqptNum, int spanNum, AsnEqptStructList asnEqptList, int direction) {
        int i;
        if (0 == neid) {
            return;
        }
        int errCode = 0;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        Param prm = null;
        RowParams rp = null;
        rp = new RowParams();
        bus.addRowParams(rp);
        prm = new Param("neid", String.valueOf(neid));
        rp.addParam(prm);
        prm = new Param("lineID", String.valueOf(lineID));
        rp.addParam(prm);
        prm = new Param("eqptNum", String.valueOf(newEqptNum));
        rp.addParam(prm);
        AsnEqptStruct asnEqpt = null;
        boolean isForward = 1 == direction;
        int len = asnEqptList.size();
        int n = i = isForward ? 0 : len - 1;
        while (isForward ? i < len : i >= 0) {
            asnEqpt = (AsnEqptStruct)asnEqptList.get(i);
            int eqptID = TEMarineLinePubFun.getNERelID(asnEqpt.eqptID.intValue(), newEqptNum, direction);
            int spanID = TEMarineLinePubFun.getNERelID(asnEqpt.eqptSpan.intValue(), spanNum, direction);
            int eqptPos = TEMarineLinePubFun.getEqptRelPos(asnEqpt.eqptPos.intValue(), asnEqpt.fiberLenth.intValue(), direction);
            rp = new RowParams();
            bus.addRowParams(rp);
            prm = new Param("neid", String.valueOf(neid));
            rp.addParam(prm);
            prm = new Param("lineID", String.valueOf(lineID));
            rp.addParam(prm);
            prm = new Param("eqptId", String.valueOf(eqptID));
            rp.addParam(prm);
            prm = new Param("spanId", String.valueOf(spanID));
            rp.addParam(prm);
            prm = new Param("eqptType", String.valueOf(asnEqpt.eqptType));
            rp.addParam(prm);
            prm = new Param("eqptDistance", String.valueOf(eqptPos));
            rp.addParam(prm);
            prm = new Param("eqptName", new String(asnEqpt.eqptName));
            rp.addParam(prm);
            if (isForward) {
                ++i;
                continue;
            }
            --i;
        }
        Datainterface allData = null;
        int sfid = 2179383;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
        }
        catch (Exception e3) {
            normalLogger.error(e3.toString());
        }
        if (null == subFunc) {
            return;
        }
        ModifyEqptBean bean = new ModifyEqptBean();
        allData = bean.performBussinessProcess(neid, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            errCode = this.getErrorDetial(neid, allData, err);
        }
        if (0 == errCode) {
            this.updataEqptPO(newEqptNum, asnEqptList, direction);
        }
    }

    private void updataEqptPO(int newEqptNum, AsnEqptStructList asnEqptList, int direction) {
        Set eqptPOSet = null;
        if (1 == direction && null != this.srcMarineLinePO) {
            eqptPOSet = this.srcMarineLinePO.getDeviceList();
        } else if (null != this.snkMarineLinePO) {
            eqptPOSet = this.snkMarineLinePO.getDeviceList();
        }
        List<TEMarineBUPO> buBondList = TEMarineLinePubFun.modifyBUBondLinePO(this.srcMarineLinePO, this.snkMarineLinePO);
        if (!buBondList.isEmpty()) {
            for (TEMarineBUPO buPO : buBondList) {
                TEDaoOperationResult dbResult = null;
                try {
                    dbResult = TECommonDaoService.update((Object)buPO);
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("Marine----Update BU in DataBase fail!", (Throwable)e);
                }
            }
        }
        if (null != asnEqptList && null != eqptPOSet) {
            TEMarineLinePubFun.updateEqptList(newEqptNum, asnEqptList, eqptPOSet, direction, this.errorDetialList);
        }
    }

    private void modifyRemark(int neID, int lineID, String remark, String newRemark, int direction) {
        if (0 == neID) {
            return;
        }
        if (!remark.equals(newRemark)) {
            Datainterface din = new Datainterface();
            BussinessParams bus = new BussinessParams();
            din.setBussinessParams(bus);
            RowParams rowParam1 = new RowParams();
            bus.addRowParams(rowParam1);
            Param p = null;
            p = new Param("neid", String.valueOf(neID));
            rowParam1.addParam(p);
            p = new Param("lineID", String.valueOf(lineID));
            rowParam1.addParam(p);
            p = new Param("lineRemark", String.valueOf(newRemark));
            rowParam1.addParam(p);
            Datainterface allData = null;
            int sfid = 2179383;
            SubFunc subFunc = null;
            try {
                subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
            }
            catch (Exception e4) {
                normalLogger.error(e4.toString());
            }
            if (null == subFunc) {
                return;
            }
            ModifyRemarkBean bean = new ModifyRemarkBean();
            allData = bean.performBussinessProcess(neID, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
            int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err) {
                TEMarineLinePubFun.setErrorDetial(neID + "-" + lineID, err);
                return;
            }
            this.updataLineRemark(newRemark, direction);
        }
    }

    private void updataLineRemark(String newRemark, int direction) {
        if (1 == direction && null != this.srcMarineLinePO) {
            this.srcMarineLinePO.setRemark(newRemark);
        } else if (null != this.snkMarineLinePO) {
            this.snkMarineLinePO.setRemark(newRemark);
        }
    }

    private int getErrorDetial(int neid, Datainterface allData, int err) {
        int errCode = 0;
        errCode = 1 == err ? 0 : 2;
        List<TEMarineLineError> errorDetailList = TEMarineLinePubFun.setOPErrorCode(neid, allData, err, true);
        this.errorDetialList.addAll(errorDetailList);
        return errCode;
    }
}

