/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStructList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifyEqptReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnModifyEqptRsp;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.ModifyEqptBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEModifyEqptHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private TETaskInfo info = null;
    private String userID;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        int lineID;
        int snkNeID;
        this.info = info;
        AsnModifyEqptReq cReq = (AsnModifyEqptReq)req;
        AsnModifyEqptRsp cRsp = (AsnModifyEqptRsp)rsp;
        this.userID = String.valueOf(cReq.userID);
        int srcNeID = cReq.neLine.srcNeID.intValue();
        int idleStatus = TEMarineLinePubFun.checkLineIsIdle(srcNeID, snkNeID = cReq.neLine.snkNeID.intValue(), lineID = cReq.neLine.lineID.intValue());
        if (0 == idleStatus) {
            List<TEMarineBUPO> buBondList = null;
            int srcErrCode = this.modifyEqptInfo(cReq, 1);
            int snkErrCode = 0;
            if (0 != cReq.neLine.snkNeID.intValue() && -1 != cReq.neLine.snkNeID.intValue()) {
                snkErrCode = this.modifyEqptInfo(cReq, 0);
            }
            cRsp.detailRet = TEMarineLineError.getDetailErrInfo(this.errorDetialList);
            normalLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            if (0 == srcErrCode && 0 == snkErrCode) {
                cRsp.result.isSuccess = true;
                cRsp.result.retCode = BigInteger.valueOf(0L);
                int srcRealNEID = 0;
                int sinkRealNEID = 0;
                if (0 != srcNeID) {
                    srcRealNEID = TENEListMgr.getInstance().getNE(srcNeID).getRealNEID();
                }
                if (0 != snkNeID) {
                    sinkRealNEID = TENEListMgr.getInstance().getNE(snkNeID).getRealNEID();
                }
                if (null != (buBondList = TEMarineLinePubFun.modifyBUBondLinePO(lineID, srcRealNEID, sinkRealNEID)) && !buBondList.isEmpty()) {
                    for (TEMarineBUPO buPO : buBondList) {
                        TEDaoOperationResult dbResult = null;
                        try {
                            dbResult = TECommonDaoService.update((Object)buPO);
                        }
                        catch (Exception e) {
                            TELogFactory.getNormalLogger().error("Marine----Update BU in DataBase fail!", (Throwable)e);
                        }
                    }
                }
            } else if (0 != srcErrCode && 0 != snkErrCode) {
                cRsp.result.isSuccess = false;
                cRsp.result.retCode = BigInteger.valueOf(2L);
            } else {
                cRsp.result.isSuccess = false;
                cRsp.result.retCode = BigInteger.valueOf(1L);
            }
        } else if (-1 == idleStatus) {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(1090615104L);
        } else {
            cRsp.result.isSuccess = false;
            cRsp.result.retCode = BigInteger.valueOf(idleStatus);
        }
        return 0;
    }

    private int modifyEqptInfo(AsnModifyEqptReq cReq, int direction) {
        this.errorDetialList.clear();
        int errCode = 0;
        int neID = 1 == direction ? cReq.neLine.srcNeID.intValue() : cReq.neLine.snkNeID.intValue();
        if (null == TENEListMgr.getInstance().getNE(neID)) {
            return errCode;
        }
        int lineID = cReq.neLine.lineID.intValue();
        int eqptNum = cReq.eqptNum.intValue();
        int spanNum = cReq.spanNum.intValue();
        AsnEqptStructList asnEqptList = cReq.eqptStrLst;
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        Param p = null;
        RowParams rpEqpt = null;
        AsnEqptStruct asnEqpt = null;
        int len = asnEqptList.size();
        for (int i = 0; i < len; ++i) {
            rpEqpt = new RowParams();
            bus.addRowParams(rpEqpt);
            asnEqpt = (AsnEqptStruct)asnEqptList.get(i);
            p = new Param("neid", String.valueOf(neID));
            rpEqpt.addParam(p);
            p = new Param("lineID", String.valueOf(lineID));
            rpEqpt.addParam(p);
            int eqptID = TEMarineLinePubFun.getNERelID(asnEqpt.eqptID.intValue(), eqptNum, direction);
            int spanID = TEMarineLinePubFun.getNERelID(asnEqpt.eqptSpan.intValue(), spanNum, direction);
            int eqptPos = TEMarineLinePubFun.getEqptRelPos(asnEqpt.eqptPos.intValue(), asnEqpt.fiberLenth.intValue(), direction);
            p = new Param("eqptId", String.valueOf(eqptID));
            rpEqpt.addParam(p);
            p = new Param("spanId", String.valueOf(spanID));
            rpEqpt.addParam(p);
            p = new Param("eqptType", String.valueOf(asnEqpt.eqptType));
            rpEqpt.addParam(p);
            p = new Param("eqptDistance", String.valueOf(eqptPos));
            rpEqpt.addParam(p);
            p = new Param("eqptName", new String(asnEqpt.eqptName));
            rpEqpt.addParam(p);
        }
        Datainterface allData = null;
        int sfid = 2179386;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            normalLogger.error(e1.toString());
        }
        if (null == subFunc) {
            return 2;
        }
        ModifyEqptBean neMgrBean = new ModifyEqptBean();
        if (null == neMgrBean) {
            return 2;
        }
        allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            TEMarineLinePubFun.setErrorDetial(String.valueOf(neID) + lineID + asnEqpt.eqptID.intValue(), err);
            return err;
        }
        this.updateEqptStruct(neID, cReq, direction);
        return errCode;
    }

    private void updateEqptStruct(int neID, AsnModifyEqptReq cReq, int direction) {
        AsnEqptStructList asnEqptList = cReq.eqptStrLst;
        int lineID = cReq.neLine.lineID.intValue();
        int eqptNum = cReq.eqptNum.intValue();
        TEDaoOperationResult dbResult = null;
        TESLMLinePO tmpPO = null;
        try {
            List<Object> data = TESLMLineUtil.getSLMLinePOData(lineID);
            for (Object obj : data) {
                tmpPO = (TESLMLinePO)obj;
                if (lineID != tmpPO.LineID) continue;
                TEMarineLinePubFun.updateEqptList(eqptNum, asnEqptList, tmpPO.getDeviceList(), direction, this.errorDetialList);
                dbResult = TECommonDaoService.update((int[])new int[]{neID}, (Object)tmpPO);
                if (0 != dbResult.getResult()) {
                    normalLogger.error("Updata eqptPO failed!");
                }
                return;
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
    }
}

