/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErrList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryLineStr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryLineStrList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryMarineLineReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnQueryMarineLineRsp;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineStruct;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEQueryLineData;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import gnu.trove.TIntArrayList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TEMarineGetMarineLineHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private Map<String, TEQueryLineData> marineLineStrMap = new HashMap<String, TEQueryLineData>();
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();

    public int handleRequest(AsnQueryMarineLineReq req, AsnQueryMarineLineRsp rsp, TaskMgr tm) {
        AsnQueryMarineLineRsp cRsp = rsp;
        int neID = req.neList.get(0);
        TIntArrayList neList = null;
        TIntArrayList opNeList = null;
        if (0 == neID) {
            neList = TEMarineLinePubFun.getNeList();
        } else {
            neList = new TIntArrayList();
            int len = req.neList.size();
            for (int i = 0; i < len; ++i) {
                neList.add(req.neList.get(i));
            }
        }
        this.getMarineLine(neList);
        opNeList = new TIntArrayList();
        this.getOPNeList(opNeList);
        this.getMarineLine(opNeList);
        cRsp.queryLineStrList = this.lineStrToAsnLine();
        cRsp.result.isSuccess = true;
        cRsp.result.retCode = BigInteger.valueOf(0L);
        AsnDetailErrList asnErrList = cRsp.detailRet;
        AsnDetailErr asnErr = null;
        if (null != this.errorDetialList) {
            for (TEMarineLineError errObj : this.errorDetialList) {
                asnErr = new AsnDetailErr();
                asnErr.cmdID = BigInteger.valueOf(errObj.getCmdID());
                asnErr.object = errObj.getErrObject().getBytes();
                asnErr.result.isSuccess = false;
                asnErr.result.retCode = BigInteger.valueOf(errObj.getErrValue());
                asnErrList.add((Object)asnErr);
                cRsp.result.isSuccess = false;
                cRsp.result.retCode = BigInteger.valueOf(1L);
            }
        }
        return 0;
    }

    private void getMarineLine(TIntArrayList neList) {
        for (int i = 0; i < neList.size(); ++i) {
            int neID = neList.get(i);
            int[] metadata = new int[]{neID};
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
            }
            catch (Exception e) {
                normalLogger.error(e.toString());
            }
            if (null == dbResult) {
                normalLogger.error("The dbResult is null!");
                continue;
            }
            int retCode = dbResult.getResult();
            if (0 != retCode) {
                this.setNEErrorInfo(neID, retCode);
                continue;
            }
            TEMarineLinePubFun.getLineDataFromDB(dbResult.getData(), this.marineLineStrMap);
        }
    }

    private void getOPNeList(TIntArrayList neList) {
        Iterator<Map.Entry<String, TEQueryLineData>> itMap = this.marineLineStrMap.entrySet().iterator();
        TEQueryLineData queryData = null;
        TEMarineLineStruct lineStr = null;
        if (!this.marineLineStrMap.isEmpty()) {
            int len = this.marineLineStrMap.size();
            for (int i = 0; i < len; ++i) {
                Map.Entry<String, TEQueryLineData> entry = itMap.next();
                queryData = entry.getValue();
                lineStr = 0 != queryData.getLineStrSrc().getLineID() ? queryData.getLineStrSrc() : queryData.getLineStrSnk();
                int neID = (int)lineStr.getOpNeID();
                neList.add(neID);
            }
        }
    }

    private AsnQueryLineStrList lineStrToAsnLine() {
        AsnQueryLineStrList asnLineList = new AsnQueryLineStrList();
        AsnQueryLineStr asnLine = null;
        Iterator<Map.Entry<String, TEQueryLineData>> itMap = this.marineLineStrMap.entrySet().iterator();
        TEQueryLineData lineStr = null;
        if (!this.marineLineStrMap.isEmpty()) {
            int len = this.marineLineStrMap.size();
            for (int i = 0; i < len; ++i) {
                Map.Entry<String, TEQueryLineData> entry = itMap.next();
                lineStr = entry.getValue();
                asnLine = TEMarineLinePubFun.mgrLine2AsnLine(lineStr, null);
                asnLineList.add((Object)asnLine);
            }
        }
        return asnLineList;
    }

    private void setNEErrorInfo(int neID, int err) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = "";
        if (null == ne) {
            return;
        }
        neName = ne.getNEName();
        TEMarineLineError errInfo = new TEMarineLineError();
        errInfo.setCmdID(0);
        errInfo.setErrObject(neName);
        errInfo.setErrValue(err);
        this.errorDetialList.add(errInfo);
    }
}

