/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnPortIndex;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnPortIndexList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnGetAvaMarineLineResourceReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnGetAvaMarineLineResourceRsp;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnLmuRes;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnLmuResList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnMarineLineRes;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnMarineLineResList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnprobeWaveStruct;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUE2EUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEGetAvaMarineLineResourceHandler {
    private static final int SLM_LMU2_USED_NUM = 8;
    private static final int FORWARD_DIRECTION = 1;
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    private Map<Integer, MarineLineResource> marineLineResMap = new HashMap<Integer, MarineLineResource>();
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private int[] modifyLineInfo = new int[3];

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm) {
        AsnGetAvaMarineLineResourceRsp cRsp = (AsnGetAvaMarineLineResourceRsp)rsp;
        AsnGetAvaMarineLineResourceReq cReq = (AsnGetAvaMarineLineResourceReq)req;
        this.modifyLineInfo[0] = cReq.srcNeID.intValue();
        this.modifyLineInfo[1] = cReq.snkNeID.intValue();
        this.modifyLineInfo[2] = cReq.lineID.intValue();
        int retCode = 1090724445;
        this.getAvaliableBoard();
        this.filtAvaliableRes();
        AsnMarineLineResList asnLineResList = cRsp.lineResource;
        AsnMarineLineRes asnLineRes = null;
        Iterator<Map.Entry<Integer, MarineLineResource>> itMap = this.marineLineResMap.entrySet().iterator();
        MarineLineResource marineLineRes = null;
        boolean isAllFail = true;
        while (itMap.hasNext()) {
            asnLineRes = new AsnMarineLineRes();
            Map.Entry<Integer, MarineLineResource> entry = itMap.next();
            asnLineRes.neID = BigInteger.valueOf(entry.getKey().intValue());
            marineLineRes = entry.getValue();
            asnLineRes.lmuResLst = this.getAsnLmuRes(marineLineRes.getLmuResLst());
            asnLineRes.lasResLst = this.getAsnPortRes(marineLineRes.lasResLst);
            asnLineRes.lmiResLst = this.getAsnPortRes(marineLineRes.lmiResLst);
            if (!this.isGetModifyRes() && (asnLineRes.lmuResLst.isEmpty() || asnLineRes.lasResLst.isEmpty() || asnLineRes.lmiResLst.isEmpty())) continue;
            isAllFail = false;
            asnLineResList.add((Object)asnLineRes);
        }
        cRsp.buAndTypeList = TEMarineBUE2EUtil.getBUE2EUtilInstance().getAsnBUAndTypeList();
        if (this.isGetModifyRes()) {
            this.errorDetialList.clear();
        }
        cRsp.detailErr = TEMarineLineError.getDetailErrInfo(this.errorDetialList);
        if (!isAllFail) {
            cRsp.result.isSuccess = true;
            cRsp.result.retCode = cRsp.detailErr.isEmpty() ? BigInteger.valueOf(0L) : BigInteger.valueOf(1090650126L);
        } else {
            cRsp.result.isSuccess = false;
            if (cRsp.detailErr.isEmpty()) {
                cRsp.result.retCode = BigInteger.valueOf(1090594251L);
            } else {
                cRsp.result.retCode = BigInteger.valueOf(1090650122L);
                cRsp.detailErr.add((Object)this.getNoResErrDetail());
            }
        }
        return retCode;
    }

    private AsnDetailErr getNoResErrDetail() {
        AsnDetailErr asnErr = null;
        asnErr = new AsnDetailErr();
        asnErr.cmdID = BigInteger.valueOf(0L);
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("slmnewlinemgr").append(File.separator).append("slmlinemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        asnErr.object = res.getString("get_line_res").getBytes();
        asnErr.result.retCode = BigInteger.valueOf(1090594251L);
        asnErr.result.isSuccess = false;
        return asnErr;
    }

    private AsnLmuResList getAsnLmuRes(List<LmuResource> lmuResList) {
        AsnLmuResList asnlmuResList = new AsnLmuResList();
        AsnLmuRes asnlmuRes = null;
        AsnprobeWaveStruct asnProbeWaveStr = null;
        for (LmuResource lmuRes : lmuResList) {
            asnlmuRes = new AsnLmuRes();
            asnlmuRes.lmuPortIndex.neID = lmuRes.getLmuPort().getNEID();
            asnlmuRes.lmuPortIndex.slotID = lmuRes.getLmuPort().getSlotID();
            asnlmuRes.lmuPortIndex.portID = lmuRes.getLmuPort().getPortNo();
            asnlmuRes.lasSlotID = BigInteger.valueOf(lmuRes.getLasSlotID());
            asnlmuRes.loadingWaveBand = BigInteger.valueOf(lmuRes.getLoadingWaveType());
            asnlmuRes.loadingWaveIndex = BigInteger.valueOf(lmuRes.getLoadingWaveNo());
            for (probeWaveRes probRes : lmuRes.getProbeWaveLst()) {
                asnProbeWaveStr = new AsnprobeWaveStruct();
                asnProbeWaveStr.probeWaveBand = BigInteger.valueOf(probRes.getProbeWaveType());
                asnProbeWaveStr.probeWaveIndex = BigInteger.valueOf(probRes.getProbeWaveNo());
                asnlmuRes.probeWaveLst.add((Object)asnProbeWaveStr);
            }
            asnlmuResList.add((Object)asnlmuRes);
        }
        return asnlmuResList;
    }

    private AsnPortIndexList getAsnPortRes(List<TEPort> portResList) {
        AsnPortIndexList asnPortList = new AsnPortIndexList();
        AsnPortIndex asnPort = null;
        for (TEPort portObj : portResList) {
            asnPort = new AsnPortIndex();
            asnPort.neID = portObj.getNEID();
            asnPort.slotID = portObj.getSlotID();
            asnPort.portID = portObj.getPortNo();
            asnPortList.add((Object)asnPort);
        }
        return asnPortList;
    }

    private void getAvaliableBoard() {
        TEBoard board = null;
        MarineLineResource marineLineRes = null;
        Vector boardList = null;
        TIntArrayList neList = TEMarineLinePubFun.getNeList();
        int size = neList.size();
        for (int i = 0; i < size; ++i) {
            int neID = neList.get(i);
            marineLineRes = new MarineLineResource();
            TENE neStr = TENEListMgr.getInstance().getNE(neID);
            if (null == neStr) continue;
            boardList = neStr.getClonedBoardList();
            int size_b = boardList.size();
            for (int j = 0; j < size_b; ++j) {
                board = (TEBoard)boardList.get(j);
                int boardType = board.getBoardType();
                int slotId = board.getSlotID();
                if (1629 == boardType || 1630 == boardType) {
                    marineLineRes.addAvailablePort(neID, boardType, slotId);
                }
                if (1628 != boardType) continue;
                marineLineRes.addAvailableLMUInfor(neID, boardType, slotId);
            }
            if (marineLineRes.isEmpty()) continue;
            this.marineLineResMap.put(neID, marineLineRes);
        }
    }

    private void filtAvaliableRes() {
        TIntArrayList neList = TEMarineLinePubFun.getNeList();
        int size = neList.size();
        for (int i = 0; i < size; ++i) {
            int[] metadata = new int[]{neList.get(i)};
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
            }
            catch (Exception e) {
                normalLogger.error(e.toString());
                return;
            }
            if (null == dbResult) {
                normalLogger.error("The dbResult is null!");
                return;
            }
            int retCode = dbResult.getResult();
            if (0 != retCode) continue;
            List data = dbResult.getData();
            for (Object obj : data) {
                TESLMLinePO tmpPO = (TESLMLinePO)obj;
                this.filtLmuResource((int)tmpPO.NeID, (int)tmpPO.LMUSlot, (int)tmpPO.LASSlot);
                this.filtLasResource((int)tmpPO.NeID, (int)tmpPO.LASSlot, (int)tmpPO.LASPort);
                this.filtLmiResource((int)tmpPO.NeID, (int)tmpPO.LMISlot);
            }
        }
        this.fillWaveLen();
    }

    private boolean isGetModifyRes() {
        return 0 != this.modifyLineInfo[2] && -1 != this.modifyLineInfo[2];
    }

    private void filtLmuResource(int neID, int lmuSlot, int lasSlot) {
        MarineLineResource marineLineRes = this.marineLineResMap.get(neID);
        if (null == marineLineRes) {
            return;
        }
        List<LmuResource> lmuResList = marineLineRes.getLmuResLst();
        int size = lmuResList.size();
        for (int i = size - 1; i >= 0; --i) {
            LmuResource lmuRes = lmuResList.get(i);
            TEPort lmuPort = lmuRes.getLmuPort();
            if (lmuPort.getNEID() != neID || lmuPort.getSlotID() != lmuSlot) continue;
            if (0 == lmuRes.getLasSlotID()) {
                lmuRes.setLasSlotID(lasSlot);
            }
            int num = lmuRes.getUsedNum();
            lmuRes.setUsedNum(++num);
            if (8 != num) continue;
            lmuResList.remove(i);
        }
    }

    private void filtLasResource(int neID, int lasSlot, long lasPort) {
        MarineLineResource marineLineRes = this.marineLineResMap.get(neID);
        if (null == marineLineRes) {
            return;
        }
        List<TEPort> lasPortList = marineLineRes.getLasResLst();
        int size = lasPortList.size();
        for (int i = size - 1; i >= 0; --i) {
            TEPort lasPortRes = lasPortList.get(i);
            if (lasPortRes.getNEID() != neID || lasPortRes.getSlotID() != lasSlot || (long)lasPortRes.getPortNo() != lasPort) continue;
            lasPortList.remove(i);
        }
    }

    private void filtLmiResource(int neID, int lmiSlot) {
        MarineLineResource marineLineRes = this.marineLineResMap.get(neID);
        if (null == marineLineRes) {
            return;
        }
        List<TEPort> lmiPortList = marineLineRes.getLmiResLst();
        int size = lmiPortList.size();
        for (int i = size - 1; i >= 0; --i) {
            if (lmiPortList.get(i).getNEID() != neID || lmiPortList.get(i).getSlotID() != lmiSlot) continue;
            lmiPortList.remove(i);
        }
    }

    private void fillWaveLen() {
        MarineLineResource marineLineRes = null;
        Iterator<Map.Entry<Integer, MarineLineResource>> it = this.marineLineResMap.entrySet().iterator();
        List<LmuResource> lmuResList = null;
        while (it.hasNext()) {
            Datainterface din = new Datainterface();
            BussinessParams bus = new BussinessParams();
            din.setBussinessParams(bus);
            RowParams rp = null;
            Map.Entry<Integer, MarineLineResource> entry = it.next();
            int neID = entry.getKey();
            marineLineRes = entry.getValue();
            lmuResList = marineLineRes.getLmuResLst();
            for (LmuResource lmuRes : lmuResList) {
                int lmuSlot = lmuRes.getLmuPort().getSlotID();
                rp = new RowParams();
                bus.addRowParams(rp);
                Param p = null;
                p = new Param("isLogFlag", String.valueOf(0));
                rp.addParam(p);
                p = new Param("neid", String.valueOf(neID));
                rp.addParam(p);
                p = new Param("slotid", String.valueOf(lmuSlot));
                rp.addParam(p);
                p = new Param("port", String.valueOf(1));
                rp.addParam(p);
                p = new Param("path", String.valueOf(0));
                rp.addParam(p);
            }
            Datainterface allData = null;
            int sfid = 2179380;
            SubFunc subFunc = null;
            try {
                subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
            }
            catch (Exception e1) {
                TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e1);
            }
            if (null == subFunc) {
                return;
            }
            String classMapping = subFunc.getClassMapping();
            TENEMgrInterface neMgrBean = null;
            try {
                neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            }
            if (null == neMgrBean) continue;
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, "", "");
            int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err) {
                this.setOPErrorCode(neID, allData, err);
            }
            this.getRowsData(allData, lmuResList);
        }
    }

    private void setOPErrorCode(int neid, Datainterface allData, int err) {
        if (1 == err || 2 == err) {
            int resErr = 0;
            for (RowParams rowParam : allData.getBussinessParams().getRowParams()) {
                int size = rowParam.getRowErrorsCount();
                for (int j = 0; j < size; ++j) {
                    RowErrors rowError = rowParam.getRowErrors(j);
                    resErr = Integer.parseInt(rowError.getErrorMessage().getErrorcode());
                    if (0 == resErr) continue;
                    int lmuSlotID = Integer.valueOf(rowError.getParam("slotid").getValue());
                    this.removeLMURes(neid, lmuSlotID);
                }
            }
        } else {
            TEMarineLineError lineErr = null;
            lineErr = TEGetAvaMarineLineResourceHandler.setErrorCode(neid, err);
            this.errorDetialList.add(lineErr);
            this.removeLMURes(neid, 0);
        }
    }

    private static TEMarineLineError setErrorCode(int neID, int err) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        TEMarineLineError errInfo = new TEMarineLineError();
        errInfo.setCmdID(30440);
        errInfo.setErrObject(neName);
        errInfo.setErrValue(err);
        return errInfo;
    }

    private void getRowsData(Datainterface allData, List<LmuResource> lmuResList) {
        RowParams[] rows;
        LmuResource lmuRes = null;
        probeWaveRes probeWave = null;
        BussinessParams bus = allData.getBussinessParams();
        if (bus == null) {
            return;
        }
        for (RowParams row : rows = bus.getRowParams()) {
            int slotID;
            if (0 != row.getRowErrorsCount() || null == (lmuRes = this.getLmuRes(lmuResList, slotID = Integer.parseInt(row.getParam("slotid").getValue())))) continue;
            int lmuPath = Integer.parseInt(row.getParam("path").getValue());
            int waveType = Integer.parseInt(row.getParam("W32BRD_ATTR_WDMTYPE").getValue());
            int waveNo = Integer.parseInt(row.getParam("W32PORT_ATTR_WAVELENTYPE").getValue());
            if (lmuPath == 1) {
                lmuRes.setLoadingWaveType(waveType);
                lmuRes.setLoadingWaveNo(waveNo);
                continue;
            }
            probeWave = new probeWaveRes();
            probeWave.setProbeWaveType(waveType);
            probeWave.setprobeWaveNo(waveNo);
            lmuRes.setProbeWaveLst(probeWave);
        }
    }

    private LmuResource getLmuRes(List<LmuResource> lmuResList, int slotID) {
        LmuResource lmuRes = null;
        for (LmuResource obj : lmuResList) {
            if (slotID != obj.getLmuPort().getSlotID()) continue;
            lmuRes = obj;
        }
        return lmuRes;
    }

    private void removeLMURes(int neID, int slotID) {
        MarineLineResource marineLineRes = null;
        marineLineRes = this.marineLineResMap.get(neID);
        List<LmuResource> lmuResList = marineLineRes.getLmuResLst();
        if (0 == slotID) {
            lmuResList.clear();
            return;
        }
        for (LmuResource lmuResObj : lmuResList) {
            if (lmuResObj.getLmuPort().getSlotID() != slotID) continue;
            lmuResList.remove(lmuResObj);
            break;
        }
    }

    class MarineLineResource {
        private List<LmuResource> lmuResLst = new ArrayList<LmuResource>();
        private List<TEPort> lasResLst = new ArrayList<TEPort>();
        private List<TEPort> lmiResLst = new ArrayList<TEPort>();

        MarineLineResource() {
        }

        public List<LmuResource> getLmuResLst() {
            return this.lmuResLst;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.lmuResLst == null ? 0 : ((Object)this.lmuResLst).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MarineLineResource other = (MarineLineResource)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.lmuResLst == null ? other.lmuResLst != null : !((Object)this.lmuResLst).equals(other.lmuResLst));
        }

        public String toString() {
            return "MarineLineResource [lasResLst=" + this.lasResLst + ", lmiResLst=" + this.lmiResLst + ", lmuResLst=" + this.lmuResLst + "]";
        }

        public void setLmuResLst(List<LmuResource> lmuResLst) {
            this.lmuResLst = lmuResLst;
        }

        public List<TEPort> getLasResLst() {
            return this.lasResLst;
        }

        public void setLasResLst(List<TEPort> lasResLst) {
            this.lasResLst = lasResLst;
        }

        public List<TEPort> getLmiResLst() {
            return this.lmiResLst;
        }

        public void setLmiResLst(List<TEPort> lmiResLst) {
            this.lmiResLst = lmiResLst;
        }

        private void addAvailablePort(int neID, int boardType, int slotId) {
            int portId = 0;
            TEPort portIndex = null;
            if (1630 == boardType) {
                portIndex = new TEPort(neID, slotId, boardType, 0);
                portIndex.setPortNo(2);
                this.lmiResLst.add(portIndex);
                return;
            }
            ArrayList portList = TEQueryLogicPort.getLogicPortList((int)neID, (int)slotId, (int)boardType);
            Collections.sort(portList);
            int portLen = portList.size();
            for (int lasIndex = 0; lasIndex < portLen; ++lasIndex) {
                portId = (Integer)portList.get(lasIndex);
                if (1629 == boardType && (9 == portId || 10 == portId)) continue;
                portIndex = new TEPort(neID, slotId, boardType, 0);
                portIndex.setPortNo(portId);
                this.lasResLst.add(portIndex);
            }
        }

        private void addAvailableLMUInfor(int neID, int boardType, int slotId) {
            TEPort portIndex = new TEPort(neID, slotId, boardType, 0, 0, 0);
            LmuResource lmuRes = new LmuResource();
            lmuRes.setLmuPort(portIndex);
            portIndex.setPortNo(1);
            this.lmuResLst.add(lmuRes);
        }

        private TEGetAvaMarineLineResourceHandler getOuterType() {
            return TEGetAvaMarineLineResourceHandler.this;
        }

        boolean isEmpty() {
            return !(null != this.lmuResLst && !this.lmuResLst.isEmpty() || null != this.lmiResLst && !this.lmiResLst.isEmpty() || null != this.lasResLst && !this.lasResLst.isEmpty());
        }
    }

    class LmuResource {
        private TEPort lmuPort;
        private int usedNum = 0;
        private int lasSlotID = 0;
        private int loadingWaveType;
        private int loadingWaveNo;
        private List<probeWaveRes> probeWaveLst = new ArrayList<probeWaveRes>();

        LmuResource() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.lasSlotID;
            result = 31 * result + (this.lmuPort == null ? 0 : this.lmuPort.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LmuResource other = (LmuResource)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.lasSlotID != other.lasSlotID) {
                return false;
            }
            return !(this.lmuPort == null ? other.lmuPort != null : !this.lmuPort.equals((Object)other.lmuPort));
        }

        public String toString() {
            return "LmuResource [lasSlotID=" + this.lasSlotID + ", lmuPort=" + this.lmuPort + ", loadingWaveNo=" + this.loadingWaveNo + ", loadingWaveType=" + this.loadingWaveType + ", probeWaveLst=" + this.probeWaveLst + ", usedNum=" + this.usedNum + "]";
        }

        public TEPort getLmuPort() {
            return this.lmuPort;
        }

        public void setLmuPort(TEPort lmuPort) {
            this.lmuPort = lmuPort;
        }

        public int getUsedNum() {
            return this.usedNum;
        }

        public void setUsedNum(int usedNum) {
            this.usedNum = usedNum;
        }

        public int getLasSlotID() {
            return this.lasSlotID;
        }

        public void setLasSlotID(int lasSlotID) {
            this.lasSlotID = lasSlotID;
        }

        public int getLoadingWaveType() {
            return this.loadingWaveType;
        }

        public void setLoadingWaveType(int loadingWaveType) {
            this.loadingWaveType = loadingWaveType;
        }

        public int getLoadingWaveNo() {
            return this.loadingWaveNo;
        }

        public void setLoadingWaveNo(int loadingWaveNo) {
            this.loadingWaveNo = loadingWaveNo;
        }

        public List<probeWaveRes> getProbeWaveLst() {
            return this.probeWaveLst;
        }

        public void setProbeWaveLst(probeWaveRes probeWave) {
            this.probeWaveLst.add(probeWave);
        }

        private TEGetAvaMarineLineResourceHandler getOuterType() {
            return TEGetAvaMarineLineResourceHandler.this;
        }
    }

    class probeWaveRes {
        private int probeWaveType;
        private int probeWaveNo;

        probeWaveRes() {
        }

        public int getProbeWaveType() {
            return this.probeWaveType;
        }

        public String toString() {
            return "probeWaveRes [probeWaveNo=" + this.probeWaveNo + ", probeWaveType=" + this.probeWaveType + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.probeWaveNo;
            result = 31 * result + this.probeWaveType;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            probeWaveRes other = (probeWaveRes)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.probeWaveNo != other.probeWaveNo) {
                return false;
            }
            return this.probeWaveType == other.probeWaveType;
        }

        public void setProbeWaveType(int probeWaveType) {
            this.probeWaveType = probeWaveType;
        }

        public int getProbeWaveNo() {
            return this.probeWaveNo;
        }

        public void setprobeWaveNo(int probeWaveNo) {
            this.probeWaveNo = probeWaveNo;
        }

        private TEGetAvaMarineLineResourceHandler getOuterType() {
            return TEGetAvaMarineLineResourceHandler.this;
        }
    }
}

