/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDeleteMarineLineReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDeleteMarineLineRsp;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErrList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnNeLineStr;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEDeleteMarineLineHandler {
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private TETaskInfo info = null;
    private String userID;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        this.info = info;
        AsnDeleteMarineLineReq cReq = (AsnDeleteMarineLineReq)req;
        AsnDeleteMarineLineRsp cRsp = (AsnDeleteMarineLineRsp)rsp;
        this.userID = String.valueOf(cReq.userID);
        int idleStatus = 0;
        AsnNeLineStr neLineStr = null;
        int len = cReq.lineList.size();
        for (int i = 0; i < len; ++i) {
            int lineID;
            int snkNeID;
            neLineStr = (AsnNeLineStr)cReq.lineList.get(i);
            int srcNeID = neLineStr.srcNeID.intValue();
            idleStatus = TEMarineLinePubFun.checkLineIsIdle(srcNeID, snkNeID = neLineStr.snkNeID.intValue(), lineID = neLineStr.lineID.intValue());
            if (0 == idleStatus) {
                this.deleteLine(srcNeID, snkNeID, lineID);
                continue;
            }
            if (-1 == idleStatus) {
                this.setErrorCode(srcNeID, lineID, 1090615104);
                continue;
            }
            this.setErrorCode(srcNeID, lineID, idleStatus);
            this.setErrorCode(snkNeID, lineID, idleStatus);
        }
        if (!this.errorDetialList.isEmpty() && cReq.lineList.size() == this.errorDetialList.size()) {
            cRsp.result.isSuccess = false;
            cRsp.detailRet = this.getErrDetail();
            cRsp.result.retCode = BigInteger.valueOf(2L);
        } else if (!this.errorDetialList.isEmpty() && cReq.lineList.size() != this.errorDetialList.size()) {
            cRsp.result.isSuccess = false;
            cRsp.detailRet = this.getErrDetail();
            cRsp.result.retCode = BigInteger.valueOf(1L);
        } else {
            cRsp.result.isSuccess = true;
            cRsp.result.retCode = BigInteger.valueOf(0L);
        }
        return 0;
    }

    private void deleteLine(int srcNeID, int snkNeID, int lineID) {
        TENE snkNe;
        int errCode = 0;
        TENE srcNe = TENEListMgr.getInstance().getNE(srcNeID);
        if (null != srcNe && 0 == (errCode = this.delMarineLine(srcNeID, lineID))) {
            TESLMOTDRDataMgr.deleteTestRecord(srcNeID, lineID);
        }
        if (null != (snkNe = TENEListMgr.getInstance().getNE(snkNeID)) && 0 == (errCode = this.delMarineLine(snkNeID, lineID))) {
            TESLMOTDRDataMgr.deleteTestRecord(snkNeID, lineID);
        }
    }

    private AsnDetailErrList getErrDetail() {
        AsnDetailErrList asnErrList = new AsnDetailErrList();
        AsnDetailErr asnErr = null;
        for (TEMarineLineError errObj : this.errorDetialList) {
            asnErr = new AsnDetailErr();
            asnErr.cmdID = BigInteger.valueOf(errObj.getCmdID());
            asnErr.object = errObj.getErrObject().getBytes();
            asnErr.result.isSuccess = false;
            asnErr.result.retCode = BigInteger.valueOf(errObj.getErrValue());
            asnErrList.add((Object)asnErr);
        }
        return asnErrList;
    }

    private int delMarineLine(int neID, int lineID) {
        int err = 0;
        if (0 == neID) {
            return err;
        }
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rowParam3 = new RowParams();
        bus.addRowParams(rowParam3);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rowParam3.addParam(p);
        p = new Param("lineID", String.valueOf(lineID));
        rowParam3.addParam(p);
        int sfid = 2179384;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            normalLogger.error(e1.toString());
        }
        if (null == subFunc) {
            return 2;
        }
        String classMapping = subFunc.getClassMapping();
        TENEMgrInterface neMgrBean = null;
        try {
            neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        Datainterface allData = null;
        if (null != neMgrBean) {
            allData = neMgrBean.performBussinessProcess(neID, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
            err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 != err) {
                if (null != allData.getBussinessParams() && allData.getBussinessParams().getRowParamsCount() > 0) {
                    int len = allData.getBussinessParams().getRowParamsCount();
                    for (int i = 0; i < len; ++i) {
                        RowParams vRowParams = allData.getBussinessParams().getRowParams(i);
                        int jLen = vRowParams.getRowErrorsCount();
                        for (int j = 0; j < jLen; ++j) {
                            RowErrors vRowError = vRowParams.getRowErrors(j);
                            ErrorMessage errorMessage = vRowError.getErrorMessage();
                            if (null == errorMessage.getErrorcode() || "".equals(errorMessage.getErrorcode())) continue;
                            this.setErrorCode(neID, lineID, Integer.parseInt(errorMessage.getErrorcode()));
                        }
                    }
                }
            } else {
                this.updataNMData(neID, lineID);
            }
        }
        return err;
    }

    private void updataNMData(int neID, int lineID) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair neIDPair = new TEDaoNameValuePair();
        TEDaoNameValuePair lineIDPair = new TEDaoNameValuePair();
        neIDPair.setName("NeID");
        neIDPair.setValue(String.valueOf(neID));
        criteria.add(neIDPair);
        lineIDPair.setName("LineID");
        lineIDPair.setValue(String.valueOf(lineID));
        criteria.add(lineIDPair);
        TEDaoOperationResult dbresult = null;
        try {
            dbresult = TECommonDaoService.deleteByID((int[])new int[]{neID}, TESLMLinePO.class, criteria);
            if (0 != dbresult.getResult()) {
                this.setErrorCode(neID, lineID, dbresult.getResult());
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
        }
        int errCode = dbresult.getResult();
        if (0 != errCode) {
            this.setErrorCode(neID, lineID, errCode);
        }
    }

    private void setErrorCode(int neID, int lineID, int err) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne) {
            TEMarineLineError errInfo = new TEMarineLineError();
            errInfo.setCmdID(30394);
            errInfo.setErrObject(neID + "-" + lineID);
            errInfo.setErrValue(err);
            this.errorDetialList.add(errInfo);
        }
    }
}

