/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnCreateMarineLineReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnCreateMarineLineRsp;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErrList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStructList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnMarineLineStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStructList;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.CreateMarineNewLineBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineDevicePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineSpanPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import gnu.trove.TIntArrayList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TECreateMarineLineHandler {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    private static final int ISNOCONSISTENT = 1;
    private static final int INVALIDE_NEVALUE = 0;
    private int isConsistent = 0;
    private List<TEMarineLineError> errorDetialListSrc = new ArrayList<TEMarineLineError>();
    private List<TEMarineLineError> errorDetialListSnk = new ArrayList<TEMarineLineError>();
    private TETaskInfo info = null;
    private String userID;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        AsnCreateMarineLineReq cReq = (AsnCreateMarineLineReq)req;
        AsnCreateMarineLineRsp cRsp = (AsnCreateMarineLineRsp)rsp;
        this.info = info;
        this.userID = String.valueOf(cReq.userID);
        int lineId = this.getLineFromNM();
        cRsp.lineID = BigInteger.valueOf(lineId);
        int errorSrc = 0;
        int errorSnk = 0;
        int snkNeID = cReq.snkLineStr.neID.intValue();
        errorSrc = this.creatMarineLine(lineId, cReq, 1);
        if (0 != snkNeID) {
            errorSnk = this.creatMarineLine(lineId, cReq, 0);
        }
        this.setConsistentFlag(errorSrc, errorSnk);
        if (0 != errorSrc && 0 != errorSnk) {
            cRsp.result.isSuccess = false;
            cRsp.result.setRetCode(2);
            cRsp.isConsistent = BigInteger.valueOf(this.isConsistent);
        } else {
            cRsp.result.isSuccess = true;
            if (this.errorDetialListSrc.isEmpty() && this.errorDetialListSnk.isEmpty()) {
                cRsp.result.setRetCode(0);
            } else {
                cRsp.result.setRetCode(1);
            }
            cRsp.isConsistent = BigInteger.valueOf(this.isConsistent);
            cRsp.spanInforList = this.spanInforToAsnRsp(cReq.spanNum.intValue());
            cRsp.detailRet = this.errDetailToAsnRsp();
        }
        return 0;
    }

    private int creatMarineLine(int lineId, AsnCreateMarineLineReq asnReq, int direction) {
        AsnMarineLineStruct asnMarineLine = null;
        int opNeId = 0;
        int opLmiSlot = 0;
        int errCode = 0;
        if (1 == direction) {
            asnMarineLine = asnReq.srcLineStr;
            opNeId = asnReq.snkLineStr.neID.intValue();
            opLmiSlot = asnReq.snkLineStr.lmiSlotID.intValue();
        } else {
            asnMarineLine = asnReq.snkLineStr;
            opNeId = asnReq.srcLineStr.neID.intValue();
            opLmiSlot = asnReq.srcLineStr.lmiSlotID.intValue();
        }
        int neID = asnMarineLine.neID.intValue();
        Datainterface din = new Datainterface();
        BussinessParams bParam = new BussinessParams();
        din.setBussinessParams(bParam);
        RowParams rp = new RowParams();
        bParam.addRowParams(rp);
        Param p = null;
        p = new Param("neid", String.valueOf(neID));
        rp.addParam(p);
        p = new Param("lineID", String.valueOf(lineId));
        rp.addParam(p);
        p = new Param("lmuSlot", String.valueOf(asnMarineLine.lmuSlotID.intValue()));
        rp.addParam(p);
        p = new Param("lasSlot", String.valueOf(asnMarineLine.lasSlotID.intValue()));
        rp.addParam(p);
        p = new Param("lasPort", String.valueOf(asnMarineLine.lasPortID.intValue()));
        rp.addParam(p);
        p = new Param("lmiSlot", String.valueOf(asnMarineLine.lmiSlotID.intValue()));
        rp.addParam(p);
        int phyid = 0 == opNeId ? 0 : TEConfigurationDataMgr.getInstance().getNEID(opNeId);
        p = new Param("opNeID", String.valueOf(phyid));
        rp.addParam(p);
        p = new Param("opLmiSlot", String.valueOf(opLmiSlot));
        rp.addParam(p);
        p = new Param("lineDirection", String.valueOf(direction));
        rp.addParam(p);
        p = new Param("probeWaveBand", String.valueOf(asnMarineLine.probeWaveBand.intValue()));
        rp.addParam(p);
        p = new Param("probeWaveIndex", String.valueOf(asnMarineLine.probeWaveIndex.intValue()));
        rp.addParam(p);
        p = new Param("loadingWaveBand", String.valueOf(asnMarineLine.loadingWaveBand.intValue()));
        rp.addParam(p);
        p = new Param("loadingWaveIndex", String.valueOf(asnMarineLine.loadingWaveIndex.intValue()));
        rp.addParam(p);
        p = new Param("lineRemark", String.valueOf(new String(asnReq.remark)));
        rp.addParam(p);
        p = new Param("spanNum", String.valueOf(asnReq.spanNum.intValue()));
        rp.addParam(p);
        p = new Param("eqptNum", String.valueOf(asnReq.eqptNum.intValue()));
        rp.addParam(p);
        AsnEqptStructList asnEqptList = asnReq.eqptStrLst;
        AsnEqptStruct asnEqpt = null;
        int index = asnEqptList.size();
        for (int i = 0; i < index; ++i) {
            asnEqpt = (AsnEqptStruct)asnEqptList.get(i);
            RowParams eqptRp = new RowParams();
            bParam.addRowParams(eqptRp);
            int eqptID = TEMarineLinePubFun.getNERelID(i + 1, index, direction);
            int spanID = TEMarineLinePubFun.getNERelID(asnEqpt.eqptSpan.intValue(), asnReq.spanNum.intValue(), direction);
            int eqptPos = TEMarineLinePubFun.getEqptRelPos(asnEqpt.eqptPos.intValue(), 800, direction);
            p = new Param("lineID", String.valueOf(lineId));
            eqptRp.addParam(p);
            p = new Param("eqptId", String.valueOf(eqptID));
            eqptRp.addParam(p);
            p = new Param("spanId", String.valueOf(spanID));
            eqptRp.addParam(p);
            p = new Param("eqptDistance", String.valueOf(eqptPos));
            eqptRp.addParam(p);
            p = new Param("eqptType", String.valueOf(asnEqpt.eqptType));
            eqptRp.addParam(p);
            p = new Param("eqptName", String.valueOf(new String(asnEqpt.eqptName)));
            eqptRp.addParam(p);
        }
        Datainterface allData = null;
        int sfid = 2179381;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e1) {
            normalLogger.error(e1.toString());
        }
        CreateMarineNewLineBean bean = new CreateMarineNewLineBean();
        allData = bean.performBussinessProcess(neID, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            errCode = this.getErrorDetial(neID, allData, err, direction);
        }
        if (0 == errCode) {
            this.saveMarineLine(asnReq, lineId, direction);
        }
        return err;
    }

    private int getErrorDetial(int neid, Datainterface allData, int err, int direction) {
        int errCode = 0;
        errCode = 1 == err ? 0 : 2;
        List<TEMarineLineError> errorDetailList = TEMarineLinePubFun.setOPErrorCode(neid, allData, err, true);
        if (1 == direction) {
            this.errorDetialListSrc.addAll(errorDetailList);
        } else {
            this.errorDetialListSnk.addAll(errorDetailList);
        }
        return errCode;
    }

    private int getLineFromNM() {
        TIntArrayList neList = TEMarineLinePubFun.getNeList();
        ArrayList<Object> data = new ArrayList<Object>();
        int size = neList.size();
        for (int i = 0; i < size; ++i) {
            int[] metadata = new int[]{neList.get(i)};
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
            }
            catch (Exception e) {
                normalLogger.error(e.toString());
            }
            if (null == dbResult) {
                normalLogger.error("The dbResult is null!");
                continue;
            }
            int retCode = dbResult.getResult();
            int curLineID = 0;
            if (0 != retCode) {
                return curLineID;
            }
            data.addAll(dbResult.getData());
        }
        return this.getCurLineID(data);
    }

    private int getCurLineID(List<Object> data) {
        int i;
        int curLineID = 0;
        TESLMLinePO linePO = null;
        ArrayList<Integer> lineIDLst = new ArrayList<Integer>();
        for (Object obj : data) {
            linePO = (TESLMLinePO)obj;
            lineIDLst.add(linePO.LineID);
        }
        Collections.sort(lineIDLst);
        if (lineIDLst.isEmpty()) {
            return 1;
        }
        curLineID = (Integer)lineIDLst.get(0) + 1;
        int len = lineIDLst.size();
        for (i = 0; i < len; ++i) {
            if (i + 1 >= len || (Integer)lineIDLst.get(i + 1) - (Integer)lineIDLst.get(i) <= 1) continue;
            curLineID = (Integer)lineIDLst.get(i) + 1;
            break;
        }
        if (i == len) {
            curLineID = (Integer)lineIDLst.get(len - 1) + 1;
        }
        return curLineID;
    }

    private void setConsistentFlag(int errorSrc, int errorSnk) {
        if (0 == errorSrc && 0 == errorSnk || 0 != errorSrc && 0 != errorSnk) {
            return;
        }
        if (0 == errorSrc && 1 != errorSnk || 0 != errorSrc && 1 == errorSnk) {
            this.isConsistent = 1;
        }
    }

    private void saveMarineLine(AsnCreateMarineLineReq cReq, int lineID, int direction) {
        List<TEMarineLineError> errorDetialList;
        int opLmiPort;
        int opLmiSlot;
        int opNeID;
        AsnMarineLineStruct slmLineStr = null;
        if (1 == direction) {
            slmLineStr = cReq.srcLineStr;
            opNeID = cReq.snkLineStr.neID.intValue();
            opLmiSlot = cReq.snkLineStr.lmiSlotID.intValue();
            opLmiPort = cReq.snkLineStr.lmiPortID.intValue();
            errorDetialList = this.errorDetialListSrc;
        } else {
            slmLineStr = cReq.snkLineStr;
            opNeID = cReq.srcLineStr.neID.intValue();
            opLmiSlot = cReq.srcLineStr.lmiSlotID.intValue();
            opLmiPort = cReq.srcLineStr.lmiPortID.intValue();
            errorDetialList = this.errorDetialListSnk;
        }
        int neID = slmLineStr.neID.intValue();
        if (TEMarineLinePubFun.isHaveCmdError(errorDetialList, 30440)) {
            return;
        }
        TESLMLinePO slmLinePO = new TESLMLinePO();
        slmLinePO.setLineID(lineID);
        slmLinePO.setNeID((long)neID);
        slmLinePO.setLMUSlot((long)slmLineStr.lmuSlotID.intValue());
        slmLinePO.setLMUPort((long)slmLineStr.lmuPortID.intValue());
        slmLinePO.setLASSlot((long)slmLineStr.lasSlotID.intValue());
        slmLinePO.setLASPort((long)slmLineStr.lasPortID.intValue());
        slmLinePO.setLMISlot((long)slmLineStr.lmiSlotID.intValue());
        slmLinePO.setLMIPort((long)slmLineStr.lmiPortID.intValue());
        slmLinePO.setOppositeNEID((long)opNeID);
        slmLinePO.setOppositeLMISlot((long)opLmiSlot);
        slmLinePO.setOppositeLMIPort((long)opLmiPort);
        slmLinePO.setDirection(direction);
        slmLinePO.setRemark(new String(cReq.remark));
        if (!TEMarineLinePubFun.isHaveCmdError(errorDetialList, 30448)) {
            slmLinePO.setCompensatoryWaveBand(slmLineStr.loadingWaveBand.intValue());
            slmLinePO.setCompensatoryWaveLenth(slmLineStr.loadingWaveIndex.intValue());
            slmLinePO.setProbeWaveBand(slmLineStr.probeWaveBand.intValue());
            slmLinePO.setProbeWaveLenth(slmLineStr.probeWaveIndex.intValue());
        }
        if (!TEMarineLinePubFun.isHaveCmdError(errorDetialList, 30408)) {
            slmLinePO.setSpanNum(cReq.spanNum.intValue());
            TELineSpanPO spanInfo = null;
            int i = 1;
            int len = cReq.spanNum.intValue();
            while (i <= len) {
                int spanNo = i++;
                spanInfo = new TELineSpanPO();
                spanInfo.setSpanID(spanNo);
                spanInfo.setAtteCoefficient(0);
                spanInfo.setFiberLenth(0);
                spanInfo.setFiberType("");
                spanInfo.setRefractiveIndex(0);
                slmLinePO.getSpanList().add(spanInfo);
            }
        }
        if (!TEMarineLinePubFun.isHaveCmdError(errorDetialList, 30442)) {
            slmLinePO.setEqptNum(cReq.eqptNum.intValue());
            Set<TELineDevicePO> eqptInfoSet = null;
            eqptInfoSet = this.addEqptInfo(cReq, errorDetialList);
            if (eqptInfoSet != null) {
                slmLinePO.setDeviceList(eqptInfoSet);
            }
        }
        try {
            TECommonDaoService.create((int[])new int[]{neID}, (Object)slmLinePO);
        }
        catch (Exception e) {
            normalLogger.error("", (Throwable)e);
        }
    }

    private Set<TELineDevicePO> addEqptInfo(AsnCreateMarineLineReq cReq, List<TEMarineLineError> errorDetialList) {
        HashSet<TELineDevicePO> eqptInfoSet = new HashSet<TELineDevicePO>();
        if (!TEMarineLinePubFun.isHaveCmdError(errorDetialList, 30444)) {
            TELineDevicePO eqptInfo = null;
            for (int i = 1; i <= cReq.eqptStrLst.size(); ++i) {
                AsnEqptStruct asnEqptStr = null;
                int size = cReq.eqptStrLst.size();
                for (int j = 0; j < size; ++j) {
                    eqptInfo = new TELineDevicePO();
                    asnEqptStr = (AsnEqptStruct)cReq.eqptStrLst.get(j);
                    eqptInfo.setSpanID(asnEqptStr.eqptSpan.intValue());
                    eqptInfo.setDeviceID(i);
                    eqptInfo.setDeviceType(asnEqptStr.eqptType.intValue());
                    eqptInfo.setDistance(asnEqptStr.eqptPos.intValue());
                    eqptInfo.setRemark(new String(asnEqptStr.eqptName));
                    eqptInfoSet.add(eqptInfo);
                }
            }
        }
        return eqptInfoSet;
    }

    private AsnSpanStructList spanInforToAsnRsp(int spanNum) {
        AsnSpanStructList asnSpanStrList = new AsnSpanStructList();
        AsnSpanStruct asnSpanStr = null;
        for (int i = 1; i <= spanNum; ++i) {
            asnSpanStr = new AsnSpanStruct();
            asnSpanStr.spanID = BigInteger.valueOf(i);
            asnSpanStr.atteCoefficient = BigInteger.valueOf(20L);
            asnSpanStr.fiberLenth = BigInteger.valueOf(800L);
            asnSpanStr.fiberType = "TYPE NOT SET".getBytes();
            asnSpanStr.refractiveIndex = BigInteger.valueOf(1460L);
            asnSpanStr.isConsistent = BigInteger.valueOf(0L);
            asnSpanStrList.add((Object)asnSpanStr);
        }
        return asnSpanStrList;
    }

    private AsnDetailErrList errDetailToAsnRsp() {
        AsnDetailErrList asnErrDetailList = new AsnDetailErrList();
        AsnDetailErr asnErrDetail = null;
        for (TEMarineLineError errObj : this.errorDetialListSrc) {
            asnErrDetail = new AsnDetailErr();
            asnErrDetail.cmdID = BigInteger.valueOf(errObj.getCmdID());
            asnErrDetail.object = errObj.getErrObject().getBytes();
            asnErrDetail.result.isSuccess = false;
            asnErrDetail.result.retCode = BigInteger.valueOf(errObj.getErrValue());
            asnErrDetailList.add((Object)asnErrDetail);
        }
        for (TEMarineLineError errObj : this.errorDetialListSnk) {
            asnErrDetail = new AsnDetailErr();
            asnErrDetail.cmdID = BigInteger.valueOf(errObj.getCmdID());
            asnErrDetail.object = errObj.getErrObject().getBytes();
            asnErrDetail.result.isSuccess = false;
            asnErrDetail.result.retCode = BigInteger.valueOf(errObj.getErrValue());
            asnErrDetailList.add((Object)asnErrDetail);
        }
        return asnErrDetailList;
    }
}

