/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnActivateBaselineReq;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnActivateBaselineRsp;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnDetailErrList;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogInfo;
import com.huawei.nglct.nemgr.marine.e2e.util.TEMarineLogMgrUtil;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.filedata.TESLMTestFile;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.commustru.fstru.FStruct;

public class TEActivateBaselineHandler {
    private List<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
    private TETaskInfo info = null;
    private String userID;
    private static int TECMDCODE_ACTIVATE_BASELINE = 2179487;
    private boolean isLog = false;

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        AsnActivateBaselineReq cReq = (AsnActivateBaselineReq)req;
        AsnActivateBaselineRsp cRsp = (AsnActivateBaselineRsp)rsp;
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("slmnewlinemgr").append(File.separator).append("slmlinemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)0, (StringBuffer)filePath);
        ArrayList<TEMarineLogInfo> marineLogInfoList = new ArrayList<TEMarineLogInfo>();
        TEMarineLogInfo marineLogInfo = new TEMarineLogInfo();
        marineLogInfo.setCmdID(TECMDCODE_ACTIVATE_BASELINE);
        marineLogInfo.setOperateName(res.getString("activate_line"));
        marineLogInfo.setOperateDesc(res.getString("line_id") + ":" + cReq.neLine.lineID.toString());
        marineLogInfo.setOperateObject(cReq.neLine.lineID.toString());
        String ipAddress = TopoUtility.ipToString((long)info.getMsgHead().senderProcIP);
        int userID1 = cReq.userID.intValue();
        this.info = info;
        this.userID = String.valueOf(cReq.userID);
        int srcNeID = cReq.neLine.srcNeID.intValue();
        int snkNeID = cReq.neLine.snkNeID.intValue();
        int lineID = cReq.neLine.lineID.intValue();
        int idleStatus = TEMarineLinePubFun.checkLineIsIdle(srcNeID, snkNeID, lineID);
        if (0 == idleStatus) {
            this.activateBaseLine(srcNeID, lineID, cReq.srcLmiSlotID.intValue(), cReq.srcLmiPortID.intValue());
            if (0 != snkNeID) {
                this.activateBaseLine(snkNeID, lineID, cReq.snkLmiSlotID.intValue(), cReq.snkLmiPortID.intValue());
            }
        }
        cRsp.result.isSuccess = true;
        cRsp.result.retCode = BigInteger.valueOf(0L);
        AsnDetailErrList asnErrList = cRsp.detailRet;
        AsnDetailErr asnErr = null;
        if (null != this.errorDetialList) {
            for (TEMarineLineError errObj : this.errorDetialList) {
                asnErr = new AsnDetailErr();
                asnErr.cmdID = BigInteger.valueOf(errObj.getCmdID());
                asnErr.object = errObj.getErrObject().getBytes();
                asnErr.result.isSuccess = false;
                asnErr.result.retCode = BigInteger.valueOf(errObj.getErrValue());
                asnErrList.add((Object)asnErr);
                cRsp.result.isSuccess = false;
                cRsp.result.retCode = BigInteger.valueOf(1L);
            }
        }
        if (!this.isLog) {
            marineLogInfo.setErrCode(0);
            marineLogInfo.setResult(0);
            marineLogInfoList.add(marineLogInfo);
            TEMarineLogMgrUtil.writeLog(userID1, ipAddress, marineLogInfoList);
        }
        return 0;
    }

    private void activateBaseLine(int neid, int lineID, int lmiSlotID, int lmiPortID) {
        List fileList = TESLMOTDRDataMgr.getUnactivedFileList(neid, neid, lmiSlotID, lmiPortID);
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        ArrayList<TESLMTestFile> testFileList = new ArrayList<TESLMTestFile>();
        ArrayList<TESLMTestFile> baselineFileList = new ArrayList<TESLMTestFile>();
        int len = fileList.size();
        for (int i = 0; i < len; ++i) {
            TESLMTestFile testFile = (TESLMTestFile)fileList.get(i);
            if (testFile.isBaseLIne()) {
                baselineFileList.add(testFile);
                continue;
            }
            testFileList.add(testFile);
        }
        fileList.clear();
        this.sendFile(neid, lineID, testFileList);
    }

    private void sendFile(int neid, int lineID, List fileList) {
        int len = fileList.size();
        for (int index = 0; index < len; ++index) {
            TESLMTestFile testFile = (TESLMTestFile)fileList.get(index);
            String neFileName = this.getNEFileName(neid, testFile.getFileName());
            File sendToNEFile = TESLMOTDRDataMgr.copyNewFile(neid, testFile.getFileName(), neFileName);
            if (null == sendToNEFile) {
                TEMarineLineError errInfo = TEMarineLinePubFun.setErrorDetial(neid + neFileName, 1091092491);
                this.errorDetialList.add(errInfo);
                return;
            }
            int ret = TESLMOTDRDataMgr.sendFileToNE(neid, neFileName);
            try {
                sendToNEFile.delete();
            }
            catch (Exception e2) {
                TELogFactory.getNormalLogger().error("sendFile fail!", (Throwable)e2);
            }
            if (0 != ret) {
                TEMarineLineError errInfo = TEMarineLinePubFun.setErrorDetial(neid + neFileName, ret);
                this.errorDetialList.add(errInfo);
                return;
            }
            Datainterface din = new Datainterface();
            BussinessParams bussinessParams = new BussinessParams();
            din.setBussinessParams(bussinessParams);
            RowParams rp = new RowParams();
            bussinessParams.addRowParams(rp);
            Param p = null;
            p = new Param("neid", String.valueOf(neid));
            rp.addParam(p);
            p = new Param("lineID", String.valueOf(lineID));
            rp.addParam(p);
            p = new Param("testMode", String.valueOf(testFile.getTestMode()));
            rp.addParam(p);
            p = new Param("testType", String.valueOf(testFile.getTestType()));
            rp.addParam(p);
            p = new Param("fileLength", String.valueOf(neFileName.length()));
            rp.addParam(p);
            p = new Param("fileName", String.valueOf(neFileName));
            rp.addParam(p);
            Datainterface allData = null;
            int sfid = 2179487;
            SubFunc subFunc = null;
            try {
                subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
            }
            catch (Exception e1) {
                TELogFactory.getNormalLogger().error("sendFile fail!", (Throwable)e1);
            }
            if (null == subFunc) {
                return;
            }
            String classMapping = subFunc.getClassMapping();
            TENEMgrInterface neMgrBean = null;
            try {
                neMgrBean = classMapping == null ? (TENEMgrInterface)Class.forName("com.huawei.nglct.explorer.TENEExplorerBean").newInstance() : (TENEMgrInterface)Class.forName(classMapping).newInstance();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("sendFile fail!", (Throwable)e);
            }
            if (null == neMgrBean) continue;
            allData = neMgrBean.performBussinessProcess(neid, subFunc, din, null, this.userID, TopoUtility.ipToString((long)this.info.getMsgHead().senderProcIP));
            this.isLog = true;
            int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
            if (0 == err) continue;
            TEMarineLinePubFun.setOPErrorCode(neid, allData, err, false);
        }
    }

    private String getNEFileName(int neid, String nmFileName) {
        String fileNameTmp = nmFileName.substring(0, nmFileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split("_");
        String nmTime = propArray[5];
        String suffix = TESLMOTDRDataMgr.getFileSuffixTypeStr(nmFileName);
        return TESLMOTDRDataMgr.convertNMFileTimeToNEFileTime(nmTime, neid) + "." + suffix;
    }
}

