/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmnewlinemgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineStruct;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEQueryLineData;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import gnu.trove.TIntArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class TELineExternalInf {
    private static final Logger normalLogger = TELogFactory.getNormalLogger();

    public static Set<TEMarineLineError> getLineInfoByNeIdList(TIntArrayList neidList, Map<String, TEQueryLineData> marineLineStrMap) {
        HashSet<TEMarineLineError> errorDetialSet = new HashSet<TEMarineLineError>();
        errorDetialSet.addAll(TELineExternalInf.getMarineLine(neidList, marineLineStrMap));
        TIntArrayList opNeList = new TIntArrayList();
        TELineExternalInf.getOPNeList(opNeList, marineLineStrMap);
        errorDetialSet.addAll(TELineExternalInf.getMarineLine(opNeList, marineLineStrMap));
        return errorDetialSet;
    }

    private static Set<TEMarineLineError> getMarineLine(TIntArrayList neList, Map<String, TEQueryLineData> marineLineStrMap) {
        HashSet<TEMarineLineError> errorDetialSet = new HashSet<TEMarineLineError>();
        for (int i = 0; i < neList.size(); ++i) {
            int neID = neList.get(i);
            int[] metadata = new int[]{neID};
            TEDaoOperationResult dbResult = null;
            try {
                dbResult = TECommonDaoService.findAll((int[])metadata, TESLMLinePO.class);
            }
            catch (Exception e) {
                normalLogger.error(e.toString());
            }
            if (null == dbResult) {
                normalLogger.error("The dbResult is null!");
                continue;
            }
            int retCode = dbResult.getResult();
            if (0 == retCode) {
                TEMarineLinePubFun.getLineDataFromDB(dbResult.getData(), marineLineStrMap);
                continue;
            }
            errorDetialSet.addAll(TELineExternalInf.setNEErrorInfo(neID, retCode));
        }
        return errorDetialSet;
    }

    private static void getOPNeList(TIntArrayList neList, Map<String, TEQueryLineData> marineLineStrMap) {
        Iterator<Map.Entry<String, TEQueryLineData>> itMap = marineLineStrMap.entrySet().iterator();
        TEQueryLineData queryData = null;
        TEMarineLineStruct lineStr = null;
        if (!marineLineStrMap.isEmpty()) {
            int len = marineLineStrMap.size();
            for (int i = 0; i < len; ++i) {
                Map.Entry<String, TEQueryLineData> entry = itMap.next();
                queryData = entry.getValue();
                lineStr = 0 == queryData.getLineStrSrc().getLineID() ? queryData.getLineStrSnk() : queryData.getLineStrSrc();
                int neID = (int)lineStr.getOpNeID();
                neList.add(neID);
            }
        }
    }

    private static Set<TEMarineLineError> setNEErrorInfo(int neID, int err) {
        HashSet<TEMarineLineError> errorDetialSet = new HashSet<TEMarineLineError>();
        TENE neObj = TENEListMgr.getInstance().getNE(neID);
        String neName = "";
        if (null != neObj) {
            neName = neObj.getNEName();
            TEMarineLineError errInfo = new TEMarineLineError();
            errInfo.setCmdID(0);
            errInfo.setErrObject(neName);
            errInfo.setErrValue(err);
            errorDetialSet.add(errInfo);
        }
        return errorDetialSet;
    }
}

