/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStructList;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00.TESLMUnderwaterStruct;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineSpanPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TESLMSetLineCrossSpanBean
extends TENEExplorerBean {
    private int TIME_OUT = 60;
    private int srcNEID = 0;
    private int sinkNEID = 0;
    private HashMap sinkFiberLength = new HashMap();
    private ArrayList sinkUnderwaterList = new ArrayList();
    private CrossSpanBean srcCrossSpanBean = new CrossSpanBean();
    private CrossSpanBean sinkCrossSpanBean = new CrossSpanBean();
    public static final int NSCMD_SLM_SET_UNDERSEA_EQPTPOS = 30444;
    private static Logger normalLogger = TELogFactory.getNormalLogger();
    private int segmentNum = 0;
    private ArrayList<RowErrors> rowErrorList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            Param isLogFlagParam;
            ArrayList resultOperList;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.ipAddress = ipAddress;
            this.srcNEID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("srcNEID").getValue());
            this.sinkNEID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("sinkNEID").getValue());
            this.outputData = new Datainterface();
            BussinessParams bussinessParam = new BussinessParams();
            this.outputData.setBussinessParams(bussinessParam);
            int srcResult = 2;
            if (0 != this.srcNEID) {
                srcResult = this.sendModifyMessage(this.srcNEID, subFunc, inputData, this.srcCrossSpanBean, true);
            }
            int sinkResult = 2;
            if (0 != this.sinkNEID) {
                if (0 != this.srcNEID) {
                    sinkResult = this.sendModifyMessage(this.sinkNEID, subFunc, inputData, this.sinkCrossSpanBean, false);
                    if (!this.sinkFiberLength.isEmpty()) {
                        this.sendQueryUnderwaterMessage(this.sinkNEID, inputData);
                    }
                } else {
                    sinkResult = this.sendModifyMessage(this.sinkNEID, subFunc, inputData, this.sinkCrossSpanBean, true);
                }
            }
            if (0 == srcResult && 0 == sinkResult) {
                if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.updateSpanStruct(this.srcNEID, this.srcCrossSpanBean.getCrossSpanOperationList(), 1);
                    this.updateSpanStruct(this.sinkNEID, this.sinkCrossSpanBean.getCrossSpanOperationList(), 1);
                }
                resultOperList = new ArrayList();
                resultOperList.addAll(this.srcCrossSpanBean.getCrossSpanOperationList());
                resultOperList.addAll(this.sinkCrossSpanBean.getCrossSpanOperationList());
                this.handleMessage(neid, resultOperList, this.subfunc);
            }
            if (0 == srcResult && 0 == this.sinkNEID) {
                if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.updateSpanStruct(this.srcNEID, this.srcCrossSpanBean.getCrossSpanOperationList(), 1);
                }
                resultOperList = new ArrayList();
                resultOperList.addAll(this.srcCrossSpanBean.getCrossSpanOperationList());
                this.handleMessage(neid, resultOperList, this.subfunc);
            }
            if (0 == sinkResult && 0 == this.srcNEID) {
                if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.updateSpanStruct(this.sinkNEID, this.sinkCrossSpanBean.getCrossSpanOperationList(), 1);
                }
                resultOperList = new ArrayList();
                resultOperList.addAll(this.sinkCrossSpanBean.getCrossSpanOperationList());
                this.handleMessage(neid, resultOperList, this.subfunc);
            }
            if (0 != srcResult && 0 != sinkResult) {
                if (0 != this.srcNEID) {
                    TESLMLineUtil.setErrorMessageInfo(this.outputData, this.srcNEID, srcResult, this.srcCrossSpanBean.getCrossSpanOperationList());
                }
                if (0 != this.sinkNEID) {
                    TESLMLineUtil.setErrorMessageInfo(this.outputData, this.sinkNEID, sinkResult, this.sinkCrossSpanBean.getCrossSpanOperationList());
                }
            }
            if ((isLogFlagParam = inputData.getBussinessParams().getRowParams(0).getParam("isLogFlag")) != null && isLogFlagParam.getValue().equals("0")) {
                this.isLogFlag = false;
            }
            if (this.isLogFlag && this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        this.setNeIdParams();
        return this.outputData;
    }

    private int sendModifyMessage(int neid, SubFunc subFunc, Datainterface inputData, CrossSpanBean crossSpanBean, boolean isPositiveDirection) {
        int result = 0;
        try {
            ArrayList<Operation> optList = new ArrayList<Operation>();
            int len = inputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams rowParams = inputData.getBussinessParams().getRowParams(i);
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
                if (null == definitions) continue;
                Operation underwaterOperation = definitions.getOperation("NSCMD_SLM_SET_FIBERPARA");
                Input input = underwaterOperation.getInput();
                this.segmentNum = Integer.parseInt(rowParams.getParam("segmentNum").getValue());
                if (isPositiveDirection) {
                    input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
                    input.setPartValue("spanNo", rowParams.getParam("spanNo").getValue());
                    input.setPartValue("fiberType", rowParams.getParam("fiberType").getValue());
                    input.setPartValue("refractiveRate", rowParams.getParam("refractiveRate").getValue());
                    input.setPartValue("fiberLength", rowParams.getParam("fiberLength").getValue());
                    input.setPartValue("attenuation", rowParams.getParam("attenuation").getValue());
                } else {
                    input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
                    try {
                        int spanNo = Integer.parseInt(rowParams.getParam("spanNo").getValue());
                        input.setPartValue("spanNo", Integer.toString(this.segmentNum + 1 - spanNo));
                    }
                    catch (Exception e) {
                        input.setPartValue("spanNo", rowParams.getParam("spanNo").getValue());
                    }
                    input.setPartValue("fiberType", rowParams.getParam("fiberType").getValue());
                    input.setPartValue("refractiveRate", rowParams.getParam("refractiveRate").getValue());
                    input.setPartValue("fiberLength", rowParams.getParam("fiberLength").getValue());
                    input.setPartValue("attenuation", rowParams.getParam("attenuation").getValue());
                    String isModifyFiberLength = rowParams.getParam("isModifyFiberLength").getValue();
                    if ("true".equals(isModifyFiberLength)) {
                        CrossSpanDataBean csBean = new CrossSpanDataBean();
                        int spanNo = Integer.parseInt(rowParams.getParam("spanNo").getValue());
                        String strSpanNo = Integer.toString(this.segmentNum + 1 - spanNo);
                        csBean.setSpanNo(strSpanNo);
                        csBean.setFiberLength(rowParams.getParam("fiberLength").getValue());
                        csBean.setOriginalFiberLength(rowParams.getParam("originalFiberLength").getValue());
                        this.sinkFiberLength.put(strSpanNo, csBean);
                    }
                }
                optList.add(underwaterOperation);
            }
            result = this.sendMessage(neid, optList);
            crossSpanBean.setCrossSpanOperationList(optList);
            if (0 != result) {
                return result;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Send Modify Line Undersea EQPT Fail!", (Throwable)e);
        }
        return result;
    }

    private int sendQueryUnderwaterMessage(int neid, Datainterface inputData) {
        int result = 0;
        try {
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            if (null != definitions) {
                ArrayList<Operation> optList = new ArrayList<Operation>();
                Operation underwaterOperation = definitions.getOperation("NSCMD_SLM_GET_UNDERSEA_EQPTPOS");
                Input input = underwaterOperation.getInput();
                input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
                input.setPartValue("eqptId", "0");
                optList.add(underwaterOperation);
                result = this.sendMessage(neid, optList);
                if (0 != result) {
                    return result;
                }
                this.handleQueryUnderwaterMessage(neid, optList);
                result = this.sendModifyUnderwaterMessage(neid);
                if (0 != result) {
                    return result;
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Send Modify Line Undersea EQPT Fail!", (Throwable)e);
        }
        return result;
    }

    private int sendModifyUnderwaterMessage(int neid) {
        int result = 0;
        try {
            ArrayList<Operation> optList = new ArrayList<Operation>();
            int len = this.sinkUnderwaterList.size();
            for (int i = 0; i < len; ++i) {
                TESLMUnderwaterStruct uwBean = (TESLMUnderwaterStruct)this.sinkUnderwaterList.get(i);
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
                if (null != definitions) {
                    Operation underwaterOperation = definitions.getOperation("NSCMD_SLM_SET_UNDERSEA_EQPTPOS");
                    Input input = underwaterOperation.getInput();
                    input.setPartValue("lineID", uwBean.getLineID());
                    input.setPartValue("eqptId", uwBean.getEqptId());
                    input.setPartValue("spanId", uwBean.getSpanId());
                    input.setPartValue("eqptType", uwBean.getEqptType());
                    try {
                        CrossSpanDataBean csBean = (CrossSpanDataBean)this.sinkFiberLength.get(uwBean.getSpanId());
                        int eqptOriDistanceLength = (int)(Float.parseFloat(csBean.getOriginalFiberLength()) * 10.0f);
                        int eqptDistanceLength = Integer.parseInt(csBean.getFiberLength());
                        int eqptDistance = Integer.parseInt(uwBean.getEqptPos());
                        input.setPartValue("eqptDistance", Integer.toString(eqptDistance + eqptDistanceLength - eqptOriDistanceLength));
                    }
                    catch (Exception e) {
                        input.setPartValue("eqptDistance", uwBean.getEqptPos());
                    }
                    input.setPartValue("eqptName", uwBean.getEqptName());
                    optList.add(underwaterOperation);
                }
                if (optList.isEmpty()) {
                    return 0;
                }
                result = this.sendMessage(neid, optList);
                if (0 == result) continue;
                return result;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Send Modify Line Undersea EQPT Fail!", (Throwable)e);
        }
        return result;
    }

    public void handleQueryUnderwaterMessage(int neid, ArrayList optList) {
        int len = optList.size();
        for (int i = 0; i < len; ++i) {
            Operation tmpOper = (Operation)optList.get(i);
            for (Output output : tmpOper.getOutput()) {
                String spanId = output.getPart("spanId").getValue();
                if (null == this.sinkFiberLength.get(spanId)) continue;
                TESLMUnderwaterStruct uwBean = new TESLMUnderwaterStruct();
                uwBean.setLineID(output.getPart("lineID").getValue());
                uwBean.setEqptId(output.getPart("eqptId").getValue());
                uwBean.setSpanId(output.getPart("spanId").getValue());
                uwBean.setEqptType(output.getPart("eqptType").getValue());
                uwBean.setEqptPos(output.getPart("eqptPos").getValue());
                uwBean.setEqptName(output.getPart("eqptName").getValue().trim());
                this.sinkUnderwaterList.add(uwBean);
            }
        }
    }

    public int getTimeOut() {
        return this.TIME_OUT;
    }

    public void updateSpanStruct(int neID, ArrayList operationList, int direction) {
        ArrayList<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
        AsnSpanStructList asnSpanList = new AsnSpanStructList();
        int lineID = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Output outputArr;
            Operation tmpOper = (Operation)operationList.get(i);
            Output output = outputArr = tmpOper.getOutput()[0];
            Fault[] faultArr = output.getFault();
            Input input = tmpOper.getInput();
            String spanID = input.getPart("spanNo").getValue();
            lineID = Integer.parseInt(input.getPart("lineID").getValue());
            AsnSpanStruct asnSpan = new AsnSpanStruct();
            asnSpan.spanID = BigInteger.valueOf(Integer.parseInt(input.getPart("spanNo").getValue()));
            asnSpan.fiberType = input.getPart("fiberType").getValue().getBytes();
            asnSpan.refractiveIndex = BigInteger.valueOf(Integer.parseInt(input.getPart("refractiveRate").getValue()));
            asnSpan.atteCoefficient = BigInteger.valueOf(Integer.parseInt(input.getPart("attenuation").getValue()));
            asnSpan.fiberLenth = BigInteger.valueOf(Integer.parseInt(input.getPart("fiberLength").getValue()));
            asnSpanList.add((Object)asnSpan);
            for (Fault fault : faultArr) {
                int code;
                if (null == fault.getCode() || (code = Integer.parseInt(fault.getCode())) == 0) continue;
                TEMarineLineError error = new TEMarineLineError();
                error.setCmdID(30444);
                error.setErrObject(spanID);
                error.setErrValue(code);
                errorDetialList.add(error);
            }
        }
        TEDaoOperationResult dbResult = null;
        TESLMLinePO tmpPO = null;
        try {
            List<Object> data = TESLMLineUtil.getSLMLinePOData(lineID);
            for (Object obj : data) {
                tmpPO = (TESLMLinePO)obj;
                if (lineID != tmpPO.LineID) continue;
                ArrayList<TELineSpanPO> tmpSpanPO = new ArrayList<TELineSpanPO>();
                for (TELineSpanPO spanPO : tmpPO.getSpanList()) {
                    boolean isExist = false;
                    int len2 = asnSpanList.size();
                    for (int i = 0; i < len2; ++i) {
                        AsnSpanStruct asnSpanTmp = (AsnSpanStruct)asnSpanList.get(i);
                        if (asnSpanTmp.spanID.intValue() != spanPO.getSpanID()) continue;
                        isExist = true;
                    }
                    if (isExist) continue;
                    tmpSpanPO.add(spanPO);
                }
                for (TELineSpanPO spanPO : tmpSpanPO) {
                    AsnSpanStruct asnSpanTmp = new AsnSpanStruct();
                    asnSpanTmp.spanID = BigInteger.valueOf(spanPO.getSpanID());
                    asnSpanTmp.fiberType = spanPO.getFiberType().getBytes();
                    asnSpanTmp.refractiveIndex = BigInteger.valueOf(spanPO.getRefractiveIndex());
                    asnSpanTmp.atteCoefficient = BigInteger.valueOf(spanPO.getAtteCoefficient());
                    asnSpanTmp.fiberLenth = BigInteger.valueOf(spanPO.getFiberLenth());
                    asnSpanList.add((Object)asnSpanTmp);
                }
                TEMarineLinePubFun.updateSpanList(asnSpanList.size(), asnSpanList, tmpPO.getSpanList(), direction, errorDetialList);
                dbResult = TECommonDaoService.update((int[])new int[]{neID}, (Object)tmpPO);
                if (0 != dbResult.getResult()) {
                    normalLogger.error("Updata spanPO failed!");
                }
                return;
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("slmlinemgr_u2kv1r3c00").append(File.separator).append("slmlinemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer detailStr = new StringBuffer();
        detailStr.append(res.getString("LINE_ID")).append(rowparams.getParam("lineID").getValue());
        detailStr.append(',');
        detailStr.append(res.getString("SEGMENT_ID")).append(rowparams.getParam("spanNo").getValue());
        detailStr.append(',');
        detailStr.append(res.getString("fiberType")).append(rowparams.getParam("fiberType").getValue());
        detailStr.append(',');
        if (null != rowparams.getParam("refractiveRate")) {
            String refractiveRate = rowparams.getParam("refractiveRate").getValue();
            float fRefractiveRate = Float.parseFloat(refractiveRate) / 1000.0f;
            detailStr.append(res.getString("refractiveRate")).append(fRefractiveRate);
            detailStr.append(',');
        }
        if (null != rowparams.getParam("attenuation")) {
            String attenuation = rowparams.getParam("attenuation").getValue();
            float fAttenuation = Float.parseFloat(attenuation) / 100.0f;
            detailStr.append(res.getString("attenuation")).append(fAttenuation);
            detailStr.append(',');
        }
        if (null != rowparams.getParam("fiberLength")) {
            String fiberLength = rowparams.getParam("fiberLength").getValue();
            float fFiberLength = Float.parseFloat(fiberLength) / 10.0f;
            detailStr.append(res.getString("fiberLength")).append(fFiberLength);
            detailStr.append(';');
        }
        return detailStr.toString();
    }

    class CrossSpanDataBean {
        String spanNo = null;
        String fiberLength = null;
        String originalFiberLength = null;

        CrossSpanDataBean() {
        }

        public String getOriginalFiberLength() {
            return this.originalFiberLength;
        }

        public void setOriginalFiberLength(String originalFiberLength) {
            this.originalFiberLength = originalFiberLength;
        }

        public String getSpanNo() {
            return this.spanNo;
        }

        public void setSpanNo(String spanNo) {
            this.spanNo = spanNo;
        }

        public String getFiberLength() {
            return this.fiberLength;
        }

        public void setFiberLength(String fiberLength) {
            this.fiberLength = fiberLength;
        }
    }

    class CrossSpanBean {
        private ArrayList crossSpanOperationList = null;

        CrossSpanBean() {
        }

        public ArrayList getCrossSpanOperationList() {
            return this.crossSpanOperationList;
        }

        public void setCrossSpanOperationList(ArrayList list) {
            this.crossSpanOperationList = list;
        }
    }
}

