/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.bumanagement.model.TEMarineBUAndTypePair;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.common.TESLMLineGencfgBean;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00.TESLMLineHandleUtil;
import com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00.TESLMUnderwaterStruct;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;

public class TESLMQueryLineUnderSeaEQPTBean
extends TESLMLineGencfgBean {
    private static final int TIME_OUT = 60;
    private int srcNEID = 0;
    private int sinkNEID = 0;
    private UnderwaterBean srcUnderwaterBean = new UnderwaterBean();
    private UnderwaterBean sinkUnderwaterBean = new UnderwaterBean();
    public static final int NSCMD_SLM_GET_SPANNUMBER = 30409;
    public static final int NSCMD_SLM_GET_FIBERPARA = 30411;
    public static final int NSCMD_SLM_GET_UNDERSEA_EQPTNUM = 30443;
    public static final int NSCMD_SLM_GET_UNDERSEA_EQPTPOS = 30445;
    public static final int NSERR_MARINE_LINE_NOT_CONSISTANT = 1090615103;
    public static final int NSERR_MARINE_BU_INCONSISTENT = 1090615173;
    private Logger normalLogger = TELogFactory.getNormalLogger();
    private int lineID = 0;

    @Override
    public void operationNE() {
        this.srcNEID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("srcNEID").getValue());
        this.sinkNEID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("sinkNEID").getValue());
        this.lineID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("lineID").getValue());
        int srcResult = 2;
        if (0 != this.srcNEID) {
            srcResult = this.sendQueryMessage(this.srcNEID, this.subfunc, this.inputData, this.srcUnderwaterBean);
        }
        int sinkResult = 2;
        if (0 != this.sinkNEID) {
            sinkResult = this.sendQueryMessage(this.sinkNEID, this.subfunc, this.inputData, this.sinkUnderwaterBean);
        }
        if (0 != srcResult && 0 != sinkResult) {
            if (this.srcNEID == this.neid) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)srcResult));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)sinkResult));
            }
        } else if (0 == srcResult && 0 != sinkResult) {
            this.handleNEMessage(this.srcNEID, this.srcUnderwaterBean, false);
        } else if (0 != srcResult && 0 == sinkResult) {
            this.handleNEMessage(this.sinkNEID, this.sinkUnderwaterBean, false);
        } else {
            this.handleNEMessage(this.srcNEID, this.srcUnderwaterBean, true);
        }
        TESLMLineHandleUtil.getAvailBUAndTypeInfo(this.outputData);
    }

    @Override
    public boolean initOperationList() {
        return true;
    }

    public void handleNEMessage(int neid, UnderwaterBean underwaterBean, boolean isCompare) {
        this.normalLogger.info("handleNEMessage start, and the current neid is -> " + neid);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        BussinessParams bussinessParam = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParam);
        Operation tmpOper = underwaterBean.getCrossspanNumOperation();
        Output[] outputArr = tmpOper.getOutput();
        Output output2 = outputArr[0];
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(underwaterBean.getCrossspanNumOperation());
        operationList.add(underwaterBean.getCrossspanOperation());
        operationList.add(underwaterBean.getUnderwaterNumOperation());
        operationList.add(underwaterBean.getUnderwaterOperation());
        TESLMLineUtil.setErrorMessageInfoList(this.outputData, neid, operationList);
        String bigErrorCode = this.outputData.getErrorMessage().getErrorcode();
        if (!bigErrorCode.equals(String.valueOf(0))) {
            return;
        }
        RowParams rowparam = new RowParams();
        Param param = null;
        param = new Param("neid", neid + "");
        rowparam.addParam(param);
        param = new Param("lineID", output2.getPart("lineID").getValue());
        rowparam.addParam(param);
        param = new Param("spanNum", output2.getPart("spanNum").getValue());
        rowparam.addParam(param);
        bussinessParam.addRowParams(rowparam);
        if (!isCompare) {
            rowparam = new RowParams();
            param = null;
            param = new Param("neid", neid + "");
            rowparam.addParam(param);
            param = new Param("lineID", output2.getPart("lineID").getValue());
            rowparam.addParam(param);
            param = new Param("isSame", "true");
            rowparam.addParam(param);
            bussinessParam.addRowParams(rowparam);
        } else {
            rowparam = new RowParams();
            param = null;
            param = new Param("neid", neid + "");
            rowparam.addParam(param);
            param = new Param("lineID", output2.getPart("lineID").getValue());
            rowparam.addParam(param);
            String isSame = Boolean.toString(this.isSame());
            param = new Param("isSame", isSame);
            rowparam.addParam(param);
            bussinessParam.addRowParams(rowparam);
            if ("false".equals(isSame)) {
                ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
                this.outputData.setErrorMessage(bigErr);
                BussinessParams bParam1 = null;
                if (null == this.outputData.getBussinessParams()) {
                    bParam1 = new BussinessParams();
                    this.outputData.setBussinessParams(bParam1);
                } else {
                    bParam1 = this.outputData.getBussinessParams();
                }
                RowParams rParam = new RowParams();
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(this.sinkNEID).getNEName());
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1090615103));
                rParam.addRowErrors(rowError);
                bParam1.addRowParams(rParam);
            }
        }
        tmpOper = underwaterBean.getCrossspanOperation();
        for (Output output2 : tmpOper.getOutput()) {
            rowparam = new RowParams();
            param = null;
            param = new Param("neid", neid + "");
            rowparam.addParam(param);
            param = new Param("lineID", output2.getPart("lineID").getValue());
            rowparam.addParam(param);
            param = new Param("spanNo", output2.getPart("spanNo").getValue());
            rowparam.addParam(param);
            param = new Param("fiberLength", output2.getPart("fiberLength").getValue());
            rowparam.addParam(param);
            bussinessParam.addRowParams(rowparam);
        }
        tmpOper = underwaterBean.getUnderwaterNumOperation();
        outputArr = tmpOper.getOutput();
        output2 = outputArr[0];
        int spanNum = Integer.parseInt(output2.getPart("eqptNum").getValue());
        if (0 != spanNum) {
            tmpOper = underwaterBean.getUnderwaterOperation();
            for (Output output2 : tmpOper.getOutput()) {
                rowparam = new RowParams();
                param = null;
                param = new Param("neid", neid + "");
                rowparam.addParam(param);
                param = new Param("lineID", output2.getPart("lineID").getValue());
                rowparam.addParam(param);
                param = new Param("eqptId", output2.getPart("eqptId").getValue());
                rowparam.addParam(param);
                param = new Param("spanId", output2.getPart("spanId").getValue());
                rowparam.addParam(param);
                String eqptType = output2.getPart("eqptType").getValue();
                param = new Param("eqptType", eqptType);
                rowparam.addParam(param);
                param = new Param("eqptPos", output2.getPart("eqptPos").getValue());
                rowparam.addParam(param);
                String eqptName = output2.getPart("eqptName").getValue().trim();
                param = new Param("eqptName", eqptName);
                rowparam.addParam(param);
                String isSameFlag = "true";
                if (null != output2.getPart("isSameFlag")) {
                    isSameFlag = output2.getPart("isSameFlag").getValue();
                }
                param = new Param("isSameFlag", isSameFlag);
                rowparam.addParam(param);
                bussinessParam.addRowParams(rowparam);
                this.checkBUNameAndType(eqptName, Integer.parseInt(eqptType));
            }
        }
        this.normalLogger.info("handleNEMessage end.");
    }

    private boolean isSame() {
        int i;
        boolean bReturn = true;
        Operation tmpOper2 = this.sinkUnderwaterBean.getCrossspanNumOperation();
        Output[] outputArr2 = tmpOper2.getOutput();
        Output output2 = outputArr2[0];
        String spanNum2 = output2.getPart("spanNum").getValue();
        Operation tmpOper3 = this.srcUnderwaterBean.getUnderwaterNumOperation();
        Output[] outputArr3 = tmpOper3.getOutput();
        Output output3 = outputArr3[0];
        String eqptNum1 = output3.getPart("eqptNum").getValue();
        Operation tmpOper4 = this.sinkUnderwaterBean.getUnderwaterNumOperation();
        Output[] outputArr4 = tmpOper4.getOutput();
        Output output4 = outputArr4[0];
        String eqptNum2 = output4.getPart("eqptNum").getValue();
        if (eqptNum1.equals("0") && eqptNum2.equals("0")) {
            return true;
        }
        if (!eqptNum1.equals(eqptNum2)) {
            return false;
        }
        HashMap<String, String> fiberLengthList = new HashMap<String, String>();
        Operation tmpOper = this.sinkUnderwaterBean.getCrossspanOperation();
        for (Output output : tmpOper.getOutput()) {
            fiberLengthList.put(output.getPart("spanNo").getValue(), output.getPart("fiberLength").getValue());
        }
        ArrayList<TESLMUnderwaterStruct> sinkUnderwaterList = new ArrayList<TESLMUnderwaterStruct>();
        tmpOper = this.sinkUnderwaterBean.getUnderwaterOperation();
        Output[] outputArr = tmpOper.getOutput();
        int len = outputArr.length;
        for (i = 0; i < len; ++i) {
            TESLMUnderwaterStruct unBean = new TESLMUnderwaterStruct();
            Output output = outputArr[i];
            unBean.setLineID(output.getPart("lineID").getValue());
            unBean.setEqptId(output.getPart("eqptId").getValue());
            unBean.setEqptType(output.getPart("eqptType").getValue());
            unBean.setEqptName(output.getPart("eqptName").getValue().trim());
            if (0 != Integer.parseInt(output.getPart("spanId").getValue())) {
                int spanId = Integer.parseInt(spanNum2) + 1 - Integer.parseInt(output.getPart("spanId").getValue());
                unBean.setSpanId(Integer.toString(spanId));
                int eqptPos = Integer.parseInt((String)fiberLengthList.get(output.getPart("spanId").getValue())) - Integer.parseInt(output.getPart("eqptPos").getValue());
                unBean.setEqptPos(Integer.toString(eqptPos));
            } else {
                unBean.setSpanId("0");
                unBean.setEqptPos("0");
            }
            sinkUnderwaterList.add(unBean);
        }
        tmpOper = this.srcUnderwaterBean.getUnderwaterOperation();
        outputArr = tmpOper.getOutput();
        len = outputArr.length;
        for (i = 0; i < len; ++i) {
            boolean isHave = false;
            TESLMUnderwaterStruct unBean = new TESLMUnderwaterStruct();
            Output output = outputArr[i];
            unBean.setLineID(output.getPart("lineID").getValue());
            unBean.setEqptId(output.getPart("eqptId").getValue());
            unBean.setEqptType(output.getPart("eqptType").getValue());
            unBean.setEqptName(output.getPart("eqptName").getValue().trim());
            unBean.setSpanId(output.getPart("spanId").getValue());
            unBean.setEqptPos(output.getPart("eqptPos").getValue());
            int k = sinkUnderwaterList.size();
            for (int j = 0; j < k; ++j) {
                if (!unBean.equals(sinkUnderwaterList.get(j))) continue;
                isHave = true;
                break;
            }
            if (!isHave) {
                bReturn = false;
            }
            Part tmpPart = new Part();
            tmpPart.setName("isSameFlag");
            tmpPart.setValue(String.valueOf(isHave));
            output.addPart(tmpPart);
        }
        return bReturn;
    }

    private int sendQueryMessage(int neid, SubFunc subFunc, Datainterface inputData, UnderwaterBean underwaterBean) {
        int result = 0;
        try {
            RowParams rowParams1 = inputData.getBussinessParams().getRowParams(0);
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            if (null != definitions) {
                ArrayList<Operation> optList = new ArrayList<Operation>();
                Operation crossspanNumOperation = definitions.getOperation("NSCMD_SLM_GET_SPANNUMBER");
                Input input = crossspanNumOperation.getInput();
                input.setPartValue("lineID", rowParams1.getParam("lineID").getValue());
                optList.add(crossspanNumOperation);
                Operation underwaterNumOperation = definitions.getOperation("NSCMD_SLM_GET_UNDERSEA_EQPTNUM");
                input = underwaterNumOperation.getInput();
                input.setPartValue("lineID", rowParams1.getParam("lineID").getValue());
                optList.add(underwaterNumOperation);
                Operation crossspanOperation = definitions.getOperation("NSCMD_SLM_GET_FIBERPARA");
                input = crossspanOperation.getInput();
                input.setPartValue("lineID", rowParams1.getParam("lineID").getValue());
                input.setPartValue("spanNo", rowParams1.getParam("spanNo").getValue());
                optList.add(crossspanOperation);
                Operation underwaterOperation = definitions.getOperation("NSCMD_SLM_GET_UNDERSEA_EQPTPOS");
                input = underwaterOperation.getInput();
                input.setPartValue("lineID", rowParams1.getParam("lineID").getValue());
                input.setPartValue("eqptId", rowParams1.getParam("eqptId").getValue());
                optList.add(underwaterOperation);
                result = this.sendMessage(neid, optList);
                if (0 != result) {
                    return result;
                }
                int len = optList.size();
                for (int i = 0; i < len; ++i) {
                    Operation opt = (Operation)optList.get(i);
                    if (30409 == opt.getCmdid()) {
                        underwaterBean.setCrossspanNumOperation(opt);
                    }
                    if (30443 == opt.getCmdid()) {
                        underwaterBean.setUnderwaterNumOperation(opt);
                    }
                    if (30411 == opt.getCmdid()) {
                        underwaterBean.setCrossspanOperation(opt);
                    }
                    if (30445 != opt.getCmdid()) continue;
                    underwaterBean.setUnderwaterOperation(opt);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Send Modify Line Undersea EQPT Fail!", (Throwable)e);
        }
        return result;
    }

    private void checkBUNameAndType(String eqptName, int eqptType) {
        int errorCode = 0;
        if (2 == eqptType || 1 == eqptType) {
            Set<TEMarineBUAndTypePair> buTypeSet = TEMarineBUUtil.getBUAndTypeList();
            TEMarineBUAndTypePair nBuTypeObj = new TEMarineBUAndTypePair();
            nBuTypeObj.setBuName(eqptName);
            nBuTypeObj.setBuType(eqptType);
            if (buTypeSet.contains(nBuTypeObj)) {
                for (TEMarineBUAndTypePair tmpBU : buTypeSet) {
                    if (!tmpBU.getBuName().equals(eqptName) || tmpBU.getBuType() == eqptType) continue;
                    errorCode = 1090615173;
                }
            } else {
                errorCode = 1090615228;
            }
        }
        if (0 != errorCode) {
            this.getErrorParams(eqptName, errorCode);
        }
    }

    private void getErrorParams(String eqptName, int errorCode) {
        if (null != this.outputData.getBussinessParams()) {
            BussinessParams busParams = this.outputData.getBussinessParams();
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            RowParams rParam = new RowParams();
            RowErrors rowError = new RowErrors();
            String neName = null == TENEListMgr.getInstance().getNE(this.srcNEID) ? TENEListMgr.getInstance().getNE(this.sinkNEID).getNEName() : TENEListMgr.getInstance().getNE(this.srcNEID).getNEName();
            Param errorParam = new Param("nename", neName);
            rowError.addParam(errorParam);
            errorParam = new Param("lineid", String.valueOf(this.lineID));
            rowError.addParam(errorParam);
            errorParam = new Param("eqptname", eqptName);
            rowError.addParam(errorParam);
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)errorCode));
            rParam.addRowErrors(rowError);
            busParams.addRowParams(rParam);
        }
    }

    public int getTimeOut() {
        return 60;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    class UnderwaterBean {
        private Operation crossspanNumOperation = null;
        private Operation underwaterNumOperation = null;
        private Operation crossspanOperation = null;
        private Operation underwaterOperation = null;

        UnderwaterBean() {
        }

        public Operation getUnderwaterNumOperation() {
            return this.underwaterNumOperation;
        }

        public void setUnderwaterNumOperation(Operation operation) {
            this.underwaterNumOperation = operation;
        }

        public Operation getCrossspanOperation() {
            return this.crossspanOperation;
        }

        public void setCrossspanOperation(Operation operation) {
            this.crossspanOperation = operation;
        }

        public Operation getUnderwaterOperation() {
            return this.underwaterOperation;
        }

        public void setUnderwaterOperation(Operation operation) {
            this.underwaterOperation = operation;
        }

        public Operation getCrossspanNumOperation() {
            return this.crossspanNumOperation;
        }

        public void setCrossspanNumOperation(Operation operation) {
            this.crossspanNumOperation = operation;
        }
    }
}

