/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.common.TESLMLineGencfgBean;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.nemgr.marine.common.TESLMSinkNEStruct;
import com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00.TEMarineLineMgrUploadBean;
import com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00.TESLMLineHandleUtil;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TESLMQueryLineInfoBean
extends TESLMLineGencfgBean {
    public static final int NSCMD_SLM_R2_RTRV_LINE = 30440;
    public static final int NSCMD_SLM_GET_LINEMEMO = 30405;
    public static final int NSCMD_SLM_GET_LINE_WAVELEN = 30449;
    protected static final String NSERR_SLM_IDX_NOTEXIST = "42781";
    protected static final int POSITIVE_LINE_DIRECTION = 1;
    protected List<TESLMSinkNEStruct> sinkNEList = new ArrayList<TESLMSinkNEStruct>();
    private TESLMSinkNEStruct sinkNEStuct = null;
    protected Logger normalLogger = TELogFactory.getNormalLogger();
    public static final int NSERR_MARINE_LINE_NOT_CONSISTANT = 1090615103;

    @Override
    public void operationNE() {
        int result = this.sendCurNEMessage();
        if (0 == result) {
            this.sendOtherNEListMessage();
            this.setErrorLineNotConsistant();
        }
    }

    private void sendOtherNEListMessage() {
        int len = this.sinkNEList.size();
        for (int j = 0; j < len; ++j) {
            this.sinkNEStuct = this.sinkNEList.get(j);
            this.sendOtherNEMessage(this.sinkNEStuct);
        }
    }

    private int sendOtherNEMessage(TESLMSinkNEStruct sinkNEStuct) {
        int logicNEID = TENECommMgr.getInstance().getLogicNEID(sinkNEStuct.getSinkNEID());
        TENE neInfo = TEConfigurationDataMgr.getInstance().getNE(logicNEID);
        if (null == neInfo) {
            return TESLMLineHandleUtil.handleQueryLineOPNENotExist(sinkNEStuct, this.outputData);
        }
        if (0 == neInfo.getComStarus()) {
            TESLMLineUtil.setErrorMessageInfo(this.outputData, neInfo.getNEID(), 1, 1090617361);
            return TESLMLineHandleUtil.handleQueryLineOPNENotExist(sinkNEStuct, this.outputData);
        }
        if (0 == neInfo.getLogStatus()) {
            TESLMLineUtil.setErrorMessageInfo(this.outputData, neInfo.getNEID(), 1, 1090646046);
            return TESLMLineHandleUtil.handleQueryLineOPNENotExist(sinkNEStuct, this.outputData);
        }
        Datainterface input1 = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        RowParams row = new RowParams();
        row.addParam(new Param("neid", String.valueOf(logicNEID)));
        row.addParam(new Param("lineID", String.valueOf(sinkNEStuct.getLineID())));
        bussinessParams.addRowParams(row);
        input1.setBussinessParams(bussinessParams);
        ArrayList otherNEOperationList1 = this.getOperation(logicNEID, this.subfunc, input1, null);
        int result = 0;
        if (!otherNEOperationList1.isEmpty()) {
            result = this.sendMessage(logicNEID, otherNEOperationList1);
        }
        if (result == 0 && !otherNEOperationList1.isEmpty()) {
            this.handleOtherNEMessage(logicNEID, otherNEOperationList1, this.getFilterErrorCodeList());
        } else {
            TESLMLineUtil.setErrorMessageInfoList(this.outputData, logicNEID, otherNEOperationList1);
        }
        return result;
    }

    public void handleOtherNEMessage(int sinkNEID, ArrayList otherNEOperationList, ArrayList filterErrorCodeList) {
        Operation tmpOper = null;
        int len = otherNEOperationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)otherNEOperationList.get(i);
            this.handleLineInfoOutput(sinkNEID, tmpOper);
        }
        this.handleRemarkWaveOutput(sinkNEID, otherNEOperationList);
    }

    private int sendCurNEMessage() {
        this.normalLogger.info("sendCurNEMessage start, and the current neid is -> " + this.neid);
        int result = this.sendMessage(this.neid);
        if (result == 0) {
            TENE neInfo;
            TEMarineLineMgrUploadBean uploadBean;
            int errcode;
            this.handleNEMessage(this.neid, this.operationList, this.getFilterErrorCodeList());
            this.handleRemarkWaveOutput(this.neid, this.operationList);
            TESLMLineUtil.setErrorMessageInfoList(this.outputData, this.neid, this.operationList);
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts() && 0 != (errcode = (uploadBean = new TEMarineLineMgrUploadBean()).upLoad(neInfo = TEConfigurationDataMgr.getInstance().getNE(this.neid), this.user, this.ipAddress))) {
                TESLMLineUtil.setErrorMessageInfo(this.outputData, this.neid, 1, errcode);
            }
        } else {
            TESLMLineUtil.setErrorMessageInfoList(this.outputData, this.neid, this.operationList);
            ErrorMessage bigErr = this.outputData.getErrorMessage();
            if (bigErr.getErrorcode().equals(String.valueOf(0))) {
                TESLMLineUtil.setErrorMessageInfo(this.outputData, this.neid, 2, result);
            }
        }
        this.normalLogger.info("sendCurNEMessage end, and the result is -> " + result);
        return result;
    }

    public void handleNEMessage(int neid, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.normalLogger.info("handleNEMessage start, and the current neid is -> " + neid);
        this.cleanLineInfo();
        Operation tmpOper = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            if (30440 != tmpOper.getCmdid()) continue;
            String errcodeStr = tmpOper.getOutput(0).getFault(0).getCode();
            if (NSERR_SLM_IDX_NOTEXIST.equals(errcodeStr)) {
                return;
            }
            this.handleLineInfoOutput(neid, tmpOper);
        }
        this.normalLogger.info("handleNEMessage end.");
    }

    protected void handleLineInfoOutput(int handleNEID, Operation tmpOper) {
        HashSet<Integer> indexSet = new HashSet<Integer>();
        if (null == tmpOper) {
            return;
        }
        Output output = null;
        int code = -1;
        int indexLen = tmpOper.getOutputCount();
        for (int index = 0; index < indexLen; ++index) {
            output = tmpOper.getOutput(index);
            code = Integer.parseInt(output.getFault(0).getCode());
            if (0 != code || 30440 != tmpOper.getCmdid()) continue;
            this.handleOutputData(handleNEID, output);
            Integer indexIDInteger = Integer.valueOf(output.getPartValue("lineID"));
            indexSet.add(indexIDInteger);
        }
        this.refreshNELineData(handleNEID, indexSet);
    }

    private void handleRemarkWaveOutput(int curNEID, ArrayList operationList) {
        Operation tmpOper = null;
        Output output = null;
        int code = -1;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            int indexLen = tmpOper.getOutputCount();
            for (int index = 0; index < indexLen; ++index) {
                output = tmpOper.getOutput(index);
                code = Integer.parseInt(output.getFault(0).getCode());
                if (0 != code) continue;
                if (30405 == tmpOper.getCmdid()) {
                    this.handleMemoOutputData(curNEID, output);
                    continue;
                }
                if (30449 != tmpOper.getCmdid()) continue;
                this.handleWaveLenOuputData(curNEID, output);
            }
        }
    }

    private void handleMemoOutputData(int curNEID, Output output) {
        ArrayList rowParamList = this.outputData.getBussinessParams().getRowParamList();
        int lineID = Integer.valueOf(output.getPart("lineID").getValue());
        String remark = "";
        if (null != output.getPart("lineRemark").getValue()) {
            remark = output.getPart("lineRemark").getValue().trim();
        }
        for (RowParams rowParams : rowParamList) {
            if (null == rowParams.getParam("lineID")) continue;
            int tmpLineID = Integer.valueOf(rowParams.getParam("lineID").getValue());
            if (this.neid != curNEID || lineID != tmpLineID) continue;
            rowParams.addParam("remark", remark);
        }
    }

    private void handleWaveLenOuputData(int curNEID, Output output) {
        ArrayList rowParamList = this.outputData.getBussinessParams().getRowParamList();
        int lineID = Integer.valueOf(output.getPart("lineID").getValue());
        for (RowParams rowParams : rowParamList) {
            int tmpLineID = Integer.valueOf(rowParams.getParam("lineID").getValue());
            if (lineID != tmpLineID) continue;
            this.handleWaveLenDetail(curNEID, output, rowParams);
        }
    }

    private void handleWaveLenDetail(int curNEID, Output output, RowParams rowParams) {
        if (null != rowParams.getParam("srcLmuneid") && curNEID == Integer.parseInt(rowParams.getParam("srcLmuneid").getValue())) {
            String[] srcParamNames = new String[]{"srcProbeWaveBand", "srcProbeWaveIndex", "srcLoadingWaveBand", "srcLoadingWaveIndex"};
            this.handleWaveLenValue(output, rowParams, srcParamNames);
        }
        if (null != rowParams.getParam("sinkLmuneid") && curNEID == Integer.parseInt(rowParams.getParam("sinkLmuneid").getValue())) {
            String[] sinkParamNames = new String[]{"sinkProbeWaveBand", "sinkProbeWaveIndex", "sinkLoadingWaveBand", "sinkLoadingWaveIndex"};
            this.handleWaveLenValue(output, rowParams, sinkParamNames);
        }
    }

    private void handleWaveLenValue(Output output, RowParams rowParams, String[] paramNames) {
        rowParams.addParam(paramNames[0], output.getPartValue("probeWaveBand"));
        rowParams.addParam(paramNames[1], output.getPartValue("probeWaveIndex"));
        rowParams.addParam(paramNames[2], output.getPartValue("loadingWaveBand"));
        rowParams.addParam(paramNames[3], output.getPartValue("loadingWaveIndex"));
    }

    private void refreshNELineData(int neid, Set<Integer> indexSet) {
        TIntArrayList list = new TIntArrayList();
        for (Integer bint : indexSet) {
            list.add(bint.intValue());
        }
        TESLMOTDRDataMgr.refreshNELineData(neid, list);
    }

    protected void handleOutputData(int handleNEID, Output output) {
        if (null == output) {
            return;
        }
        if (null == output.getPart("lineDirection").getValue()) {
            return;
        }
        boolean isSame = true;
        int direction = Integer.parseInt(output.getPart("lineDirection").getValue());
        if (handleNEID != this.neid && this.sinkNEStuct.getDirection() == direction) {
            direction = this.sinkNEStuct.getDirection() == 0 ? 1 : 0;
        }
        if (1 == direction) {
            TESLMLineUtil.handlePositiveOutputData(this.outputData, this.neid, handleNEID, output, direction, this.sinkNEList, true);
        } else {
            TESLMLineUtil.handleReserveOutputData(this.outputData, this.neid, handleNEID, output, direction, this.sinkNEList, true);
        }
        if (handleNEID != this.neid) {
            int opNeID = Integer.parseInt(output.getPart("opNeID").getValue());
            int lmiSoltID = Integer.parseInt(output.getPart("lmiSlot").getValue());
            int opLmiSlot = Integer.parseInt(output.getPart("opLmiSlot").getValue());
            int opLogicNEID = TENECommMgr.getInstance().getLogicNEID(opNeID);
            int lineDirection = Integer.parseInt(output.getPart("lineDirection").getValue());
            if (this.sinkNEStuct.getSrcNEID() != opLogicNEID || this.sinkNEStuct.getSrcLMISlotID() != opLmiSlot || this.sinkNEStuct.getSinkLMISlotID() != lmiSoltID || this.sinkNEStuct.getDirection() == lineDirection) {
                isSame = false;
            }
            if (!isSame) {
                int lineID = Integer.parseInt(output.getPart("lineID").getValue());
                RowParams rowparams = TESLMLineUtil.getOutputRowParams(this.outputData, output);
                rowparams.addParam("isSame", String.valueOf(isSame));
                TESLMLineUtil.setRowErrorMessageInfo(this.outputData, rowparams, this.neid, handleNEID, lineID, 1090615103);
            }
        }
    }

    private void setErrorLineNotConsistant() {
        ArrayList rowParamsList = this.outputData.getBussinessParams().getRowParamList();
        for (RowParams rowParams : rowParamsList) {
            Param param = rowParams.getParam("srcSaveSinkLmineid");
            if (null == param) continue;
            int logicNEID = TENECommMgr.getInstance().getLogicNEID(Integer.parseInt(param.getValue()));
            TESLMLineUtil.setRowErrorLineNotConsistant(this.outputData, this.neid, logicNEID, rowParams, rowParams.getParam("srcLmuneid"), rowParams.getParam("sinkLmuneid"));
        }
    }

    protected void cleanLineInfo() {
        this.sinkNEList.clear();
    }

    @Override
    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(Integer.valueOf(NSERR_SLM_IDX_NOTEXIST));
        return errorCodeList;
    }
}

