/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.common.TESLMLineGencfgBean;
import com.huawei.nglct.nemgr.marine.common.TESLMLineUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TESLMQueryLineCrossSpanBean
extends TESLMLineGencfgBean {
    private static final int TIME_OUT = 60;
    private int srcNEID = 0;
    private int sinkNEID = 0;
    private CrossSpanBean srcCrossSpanBean = new CrossSpanBean();
    private CrossSpanBean sinkCrossSpanBean = new CrossSpanBean();
    public static final int NSCMD_SLM_GET_SPANNUMBER = 30409;
    public static final int NSCMD_SLM_GET_FIBERPARA = 30411;
    public static final int NSERR_MARINE_LINE_NOT_CONSISTANT = 1090615103;
    private Logger normalLogger = TELogFactory.getNormalLogger();

    @Override
    public void operationNE() {
        this.srcNEID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("srcNEID").getValue());
        this.sinkNEID = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("sinkNEID").getValue());
        int srcResult = 2;
        if (0 != this.srcNEID) {
            srcResult = this.sendQueryMessage(this.srcNEID, this.subfunc, this.inputData, this.srcCrossSpanBean);
        }
        int sinkResult = 2;
        if (0 != this.sinkNEID) {
            sinkResult = this.sendQueryMessage(this.sinkNEID, this.subfunc, this.inputData, this.sinkCrossSpanBean);
        }
        if (0 != srcResult && 0 != sinkResult) {
            if (this.srcNEID == this.neid) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)srcResult));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)sinkResult));
            }
        } else if (0 == srcResult && 0 != sinkResult) {
            this.handleNEMessage(this.srcNEID, this.srcCrossSpanBean, false);
        } else if (0 != srcResult && 0 == sinkResult) {
            this.handleNEMessage(this.sinkNEID, this.sinkCrossSpanBean, false);
        } else {
            this.handleNEMessage(this.srcNEID, this.srcCrossSpanBean, true);
        }
    }

    @Override
    public boolean initOperationList() {
        return true;
    }

    public void handleNEMessage(int neid, CrossSpanBean crossSpanBean, boolean isCompare) {
        this.normalLogger.info("handleNEMessage start, and the current neid is -> " + neid);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        BussinessParams bussinessParam = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParam);
        Operation tmpOper = crossSpanBean.getCrossspanOperation();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        operationList.add(crossSpanBean.getCrossspanNumOperation());
        operationList.add(crossSpanBean.getCrossspanOperation());
        TESLMLineUtil.setErrorMessageInfoList(this.outputData, neid, operationList);
        String bigErrorCode = this.outputData.getErrorMessage().getErrorcode();
        if (!bigErrorCode.equals(String.valueOf(0))) {
            return;
        }
        RowParams rowparam = null;
        Param param = null;
        String isSame = "true";
        if (isCompare) {
            isSame = Boolean.toString(this.isSame());
        }
        if ("false".equals(isSame)) {
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)1);
            this.outputData.setErrorMessage(bigErr);
            BussinessParams bParam = null;
            if (null == this.outputData.getBussinessParams()) {
                bParam = new BussinessParams();
                this.outputData.setBussinessParams(bParam);
            } else {
                bParam = this.outputData.getBussinessParams();
            }
            RowParams rParam = new RowParams();
            RowErrors rowError = new RowErrors();
            Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(this.sinkNEID).getNEName());
            rowError.addParam(errorParam);
            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1090615103));
            rParam.addRowErrors(rowError);
            bParam.addRowParams(rParam);
        }
        for (Output output : tmpOper.getOutput()) {
            rowparam = new RowParams();
            param = new Param("neid", neid + "");
            rowparam.addParam(param);
            param = new Param("lineID", output.getPart("lineID").getValue());
            rowparam.addParam(param);
            param = new Param("spanNo", output.getPart("spanNo").getValue());
            rowparam.addParam(param);
            param = new Param("fiberType", this.getFiberType(output.getPart("fiberType").getValue()));
            rowparam.addParam(param);
            param = new Param("refractiveRate", output.getPart("refractiveRate").getValue());
            rowparam.addParam(param);
            param = new Param("fiberLength", output.getPart("fiberLength").getValue());
            rowparam.addParam(param);
            param = new Param("attenuation", output.getPart("attenuation").getValue());
            rowparam.addParam(param);
            param = new Param("isSame", isSame);
            rowparam.addParam(param);
            String isSameFlag = "true";
            if (null != output.getPart("isSameFlag")) {
                isSameFlag = output.getPart("isSameFlag").getValue();
            }
            param = new Param("isSameFlag", isSameFlag);
            rowparam.addParam(param);
            bussinessParam.addRowParams(rowparam);
        }
        this.normalLogger.info("handleNEMessage end.");
    }

    public String getFiberType(String fiberType) {
        int i;
        byte[] bFiberType = fiberType.getBytes();
        int index = 0;
        int len = bFiberType.length;
        for (i = 0; i < len; ++i) {
            if (0 != bFiberType[i]) continue;
            index = i;
        }
        if (0 == index) {
            return "";
        }
        len = bFiberType.length;
        for (i = index + 1; i < len; ++i) {
            bFiberType[i] = 0;
        }
        return new String(bFiberType).trim();
    }

    private boolean isSame() {
        int i;
        Operation tmpOper2;
        Output[] outputArr2;
        Output output2;
        String spanNum2;
        boolean bReturn = true;
        Operation tmpOper1 = this.srcCrossSpanBean.getCrossspanNumOperation();
        Output[] outputArr1 = tmpOper1.getOutput();
        Output output1 = outputArr1[0];
        String spanNum1 = output1.getPart("spanNum").getValue();
        if (!spanNum1.equals(spanNum2 = (output2 = (outputArr2 = (tmpOper2 = this.sinkCrossSpanBean.getCrossspanNumOperation()).getOutput())[0]).getPart("spanNum").getValue())) {
            return false;
        }
        ArrayList<CrossSpanDataBean> sinkCrossSpanList = new ArrayList<CrossSpanDataBean>();
        Operation tmpOper = this.sinkCrossSpanBean.getCrossspanOperation();
        Output[] outputArr = tmpOper.getOutput();
        int len = outputArr.length;
        for (i = 0; i < len; ++i) {
            CrossSpanDataBean csBean = new CrossSpanDataBean();
            Output output = outputArr[i];
            csBean.setLineID(output.getPart("lineID").getValue());
            int spanNo = Integer.parseInt(spanNum2) + 1 - Integer.parseInt(output.getPart("spanNo").getValue());
            csBean.setSpanNo(Integer.toString(spanNo));
            csBean.setFiberType(output.getPart("fiberType").getValue().trim());
            csBean.setRefractiveRate(output.getPart("refractiveRate").getValue());
            csBean.setFiberLength(output.getPart("fiberLength").getValue());
            csBean.setAttenuation(output.getPart("attenuation").getValue());
            sinkCrossSpanList.add(csBean);
        }
        tmpOper = this.srcCrossSpanBean.getCrossspanOperation();
        outputArr = tmpOper.getOutput();
        len = outputArr.length;
        for (i = 0; i < len; ++i) {
            boolean isHave = false;
            CrossSpanDataBean csBean = new CrossSpanDataBean();
            Output output = outputArr[i];
            csBean.setLineID(output.getPart("lineID").getValue());
            csBean.setSpanNo(output.getPart("spanNo").getValue());
            csBean.setFiberType(output.getPart("fiberType").getValue().trim());
            csBean.setRefractiveRate(output.getPart("refractiveRate").getValue());
            csBean.setFiberLength(output.getPart("fiberLength").getValue());
            csBean.setAttenuation(output.getPart("attenuation").getValue());
            int k = sinkCrossSpanList.size();
            for (int j = 0; j < k; ++j) {
                if (!csBean.equals(sinkCrossSpanList.get(j))) continue;
                isHave = true;
                break;
            }
            if (!isHave) {
                bReturn = false;
            }
            Part tmpPart = new Part();
            tmpPart.setName("isSameFlag");
            tmpPart.setValue(String.valueOf(isHave));
            output.addPart(tmpPart);
        }
        return bReturn;
    }

    private int sendQueryMessage(int neid, SubFunc subFunc, Datainterface inputData, CrossSpanBean crossSpanBean) {
        int result = 0;
        try {
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
            if (null != definitions) {
                ArrayList<Operation> optList = new ArrayList<Operation>();
                Operation crossspanNumOperation = definitions.getOperation("NSCMD_SLM_GET_SPANNUMBER");
                Input input = crossspanNumOperation.getInput();
                input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
                optList.add(crossspanNumOperation);
                Operation crossspanOperation = definitions.getOperation("NSCMD_SLM_GET_FIBERPARA");
                input = crossspanOperation.getInput();
                input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
                input.setPartValue("spanNo", rowParams.getParam("spanNo").getValue());
                optList.add(crossspanOperation);
                result = this.sendMessage(neid, optList);
                if (0 != result) {
                    return result;
                }
                int len = optList.size();
                for (int i = 0; i < len; ++i) {
                    Operation opt = (Operation)optList.get(i);
                    if (30409 == opt.getCmdid()) {
                        crossSpanBean.setCrossspanNumOperation(opt);
                    }
                    if (30411 != opt.getCmdid()) continue;
                    crossSpanBean.setCrossspanOperation(opt);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Send Modify Line Undersea EQPT Fail!", (Throwable)e);
        }
        return result;
    }

    public int getTimeOut() {
        return 60;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    class CrossSpanDataBean {
        String lineID = null;
        String spanNo = null;
        String fiberType = null;
        String refractiveRate = null;
        String fiberLength = null;
        String attenuation = null;

        CrossSpanDataBean() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.attenuation == null ? 0 : this.attenuation.hashCode());
            result = 31 * result + (this.fiberLength == null ? 0 : this.fiberLength.hashCode());
            result = 31 * result + (this.fiberType == null ? 0 : this.fiberType.hashCode());
            result = 31 * result + (this.lineID == null ? 0 : this.lineID.hashCode());
            result = 31 * result + (this.refractiveRate == null ? 0 : this.refractiveRate.hashCode());
            result = 31 * result + (this.spanNo == null ? 0 : this.spanNo.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CrossSpanDataBean)) {
                return false;
            }
            CrossSpanDataBean other = (CrossSpanDataBean)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.attenuation == null ? other.attenuation != null : !this.attenuation.equals(other.attenuation)) {
                return false;
            }
            if (this.fiberLength == null ? other.fiberLength != null : !this.fiberLength.equals(other.fiberLength)) {
                return false;
            }
            if (this.fiberType == null ? other.fiberType != null : !this.fiberType.equals(other.fiberType)) {
                return false;
            }
            if (this.lineID == null ? other.lineID != null : !this.lineID.equals(other.lineID)) {
                return false;
            }
            if (this.refractiveRate == null ? other.refractiveRate != null : !this.refractiveRate.equals(other.refractiveRate)) {
                return false;
            }
            return !(this.spanNo == null ? other.spanNo != null : !this.spanNo.equals(other.spanNo));
        }

        public String getLineID() {
            return this.lineID;
        }

        public void setLineID(String lineID) {
            this.lineID = lineID;
        }

        public String getSpanNo() {
            return this.spanNo;
        }

        public void setSpanNo(String spanNo) {
            this.spanNo = spanNo;
        }

        public String getFiberType() {
            return this.fiberType;
        }

        public void setFiberType(String fiberType) {
            this.fiberType = fiberType;
        }

        public String getRefractiveRate() {
            return this.refractiveRate;
        }

        public void setRefractiveRate(String refractiveRate) {
            this.refractiveRate = refractiveRate;
        }

        public String getFiberLength() {
            return this.fiberLength;
        }

        public void setFiberLength(String fiberLength) {
            this.fiberLength = fiberLength;
        }

        public String getAttenuation() {
            return this.attenuation;
        }

        public void setAttenuation(String attenuation) {
            this.attenuation = attenuation;
        }

        private TESLMQueryLineCrossSpanBean getOuterType() {
            return TESLMQueryLineCrossSpanBean.this;
        }
    }

    class CrossSpanBean {
        private Operation crossspanNumOperation = null;
        private Operation crossspanOperation = null;

        CrossSpanBean() {
        }

        public Operation getCrossspanOperation() {
            return this.crossspanOperation;
        }

        public void setCrossspanOperation(Operation operation) {
            this.crossspanOperation = operation;
        }

        public Operation getCrossspanNumOperation() {
            return this.crossspanNumOperation;
        }

        public void setCrossspanNumOperation(Operation operation) {
            this.crossspanNumOperation = operation;
        }
    }
}

