/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnEqptStructList;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStruct;
import com.huawei.nglct.nemgr.f_interface.marinelinemgr.AsnSpanStructList;
import com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00.TESLMCreateLineBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineError;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineSpanPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineBUPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TESLMModifyLineBean
extends TESLMCreateLineBean {
    public static final int NSCMD_SLM_R2_EDIT_LINE = 30441;
    private TESLMLinePO srcMarineLinePO = null;
    private TESLMLinePO snkMarineLinePO = null;
    private List<TESLMLinePO> srcLinePOList = new ArrayList<TESLMLinePO>();
    private List<TESLMLinePO> snkLinePOList = new ArrayList<TESLMLinePO>();
    private static Logger normalLogger = TELogFactory.getNormalLogger();

    @Override
    public void operationNE() {
        int result = this.sendMessage(this.neid);
        TELogFactory.getNormalLogger().info("TESLMModifyLineBean sendMessage result is : " + result);
        if (result != 0) {
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage((int)result);
            this.outputData.setErrorMessage(bigErr);
            this.outputData.setBussinessParams(this.getBussinessParamsWithErrorList());
        } else {
            this.handleMessage(this.neid, this.resultOperList, this.subfunc);
        }
    }

    @Override
    public int sendMessage(int neid) {
        if (0 != this.checkNECommumite(neid)) {
            return 2;
        }
        int opNeID = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("opNeID").getValue());
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            int lineID = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("lineID").getValue());
            this.getMarineLinePO(neid, opNeID, lineID);
        }
        int srcNEID = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("neid").getValue());
        int result = 0;
        if (0 != srcNEID && 0 != (result = this.sendMarineNEMessage(true))) {
            return result;
        }
        int tmpNEID = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("opNeID").getValue());
        if (0 != tmpNEID) {
            result = this.sendMarineNEMessage(false);
        }
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            this.saveMarineLinePO(neid, opNeID);
            List<TEMarineBUPO> buBondList = TEMarineLinePubFun.modifyBUBondLinePO(this.srcMarineLinePO, this.snkMarineLinePO);
            if (!buBondList.isEmpty()) {
                for (TEMarineBUPO buPO : buBondList) {
                    TEDaoOperationResult dbResult = null;
                    try {
                        dbResult = TECommonDaoService.update((Object)buPO);
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().error("Marine----Update BU in DataBase fail!", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private int sendMarineNEMessage(boolean isSrcNE) {
        int direction = 1;
        int retCode = 0;
        List<Operation> createLineOperList = this.getMofifyLineOperList(isSrcNE);
        ArrayList<String> buNumOperNameList = new ArrayList<String>();
        buNumOperNameList.add("NSCMD_SLM_SET_UNDERSEA_EQPTNUM");
        ArrayList<Operation> buNumOperList = this.getOtherOperList(isSrcNE, buNumOperNameList);
        ArrayList<Operation> buOperList = this.getUnderwaterInfoOperList(this.operNEID, isSrcNE);
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add("NSCMD_SLM_SET_LINEMEMO");
        operNameList.add("NSCMD_SLM_SET_SPANNUMBER");
        ArrayList<Operation> otherOperList = this.getOtherOperList(isSrcNE, operNameList);
        ArrayList<String> operWavelenList = new ArrayList<String>();
        operWavelenList.add("NSCMD_SLM_SET_LINE_WAVELEN");
        ArrayList<Operation> wavelenOperList = this.getOtherOperList(isSrcNE, operWavelenList);
        if (null == createLineOperList || null == buOperList || null == otherOperList) {
            return retCode;
        }
        String isModifyPortTable = this.inputData.getBussinessParams().getRowParams(0).getParam("isModifyPortTable").getValue();
        String isModifyRptTable = this.inputData.getBussinessParams().getRowParams(0).getParam("isModifyRptTable").getValue();
        String isModifyBUTable = this.inputData.getBussinessParams().getRowParams(0).getParam("isModifyBUTable").getValue();
        if ("true".equals(isModifyPortTable)) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.operNEID, createLineOperList, this.getTimeOut());
            if (null != result) {
                retCode = result.retCode;
            }
            String errorCode = createLineOperList.get(0).getOutput(0).getFault(0).getCode();
            this.resultOperList.addAll(createLineOperList);
            if (0 == retCode && 0 == Integer.parseInt(errorCode)) {
                if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.updateMarineLine(createLineOperList.get(0), direction);
                }
                if (0 == (retCode = this.sendMarineMessage(this.operNEID, wavelenOperList, this.resultOperList)) && TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.updateWaveLen((Operation)wavelenOperList.get(0), direction);
                }
                if (0 == (retCode = this.sendMarineMessage(this.operNEID, otherOperList, this.resultOperList)) && TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    for (Operation oper : otherOperList) {
                        if (30404 == oper.getCmdid()) {
                            this.updataLineRemark(oper, direction);
                        }
                        if (30408 != oper.getCmdid()) continue;
                        this.updataSpanPO(oper, direction);
                    }
                }
                int retCode1 = this.sendMarineMessage(this.operNEID, buNumOperList, this.resultOperList);
                int eqptNum = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("eqptNum").getValue());
                if (eqptNum > 0 && !buOperList.isEmpty()) {
                    retCode = this.sendMarineMessage(this.operNEID, buOperList, this.resultOperList);
                }
                if (0 == retCode1 && TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.updataEqptPO((Operation)buNumOperList.get(0), buOperList, direction);
                }
            } else if (null != errorCode) {
                retCode = Integer.parseInt(errorCode);
            }
        } else {
            if ("true".equals(isModifyRptTable) && 0 == (retCode = this.sendMarineMessage(this.operNEID, otherOperList, this.resultOperList)) && TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                for (Operation oper : otherOperList) {
                    if (30404 == oper.getCmdid()) {
                        this.updataLineRemark(oper, direction);
                    }
                    if (30408 != oper.getCmdid()) continue;
                    this.updataSpanPO(oper, direction);
                }
            }
            if ("true".equals(isModifyBUTable)) {
                int retCode1;
                ArrayList clearBuOperList = this.getClearUnderwaterInfoOperList(this.operNEID);
                if (!clearBuOperList.isEmpty() && 0 == (retCode1 = this.sendMessage(this.operNEID, clearBuOperList))) {
                    TELogFactory.getNormalLogger().error("Clear Line Undersea EQPT Fail!");
                }
                retCode1 = this.sendMarineMessage(this.operNEID, buNumOperList, this.resultOperList);
                int eqptNum = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("eqptNum").getValue());
                if (0 == retCode1 && eqptNum > 0 && !buOperList.isEmpty()) {
                    retCode = this.sendMarineMessage(this.operNEID, buOperList, this.resultOperList);
                }
                if (0 == retCode1 && 0 == retCode && TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    this.updataEqptPO((Operation)buNumOperList.get(0), buOperList, direction);
                }
            }
        }
        int len = this.resultOperList.size();
        for (int i = 0; i < len; ++i) {
            Output outputArr;
            Operation tmpOper = (Operation)this.resultOperList.get(i);
            Output output = outputArr = tmpOper.getOutput()[0];
            for (Fault fault1 : output.getFault()) {
                int code;
                if (null == fault1.getCode() || 0 == (code = Integer.parseInt(fault1.getCode()))) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neid, (int)code));
                RowErrors rowError1 = new RowErrors();
                Param errorParam = new Param("nename", TENEListMgr.getInstance().getNE(this.operNEID).getNEName());
                rowError1.addParam(errorParam);
                rowError1.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)code));
                this.rowErrorList.add(rowError1);
            }
        }
        if (!this.rowErrorList.isEmpty()) {
            retCode = 1;
        }
        if (this.rowErrorList.size() == this.resultOperList.size()) {
            retCode = 2;
        }
        if (this.rowErrorList.isEmpty()) {
            retCode = 0;
        }
        return retCode;
    }

    private List<Operation> getMofifyLineOperList(boolean isSrc) {
        int tmpNEID;
        ArrayList operList = new ArrayList();
        if (0 == this.inputData.getBussinessParams().getRowParamsCount()) {
            return operList;
        }
        Datainterface tmpInputData = new Datainterface();
        BussinessParams tmpBussinessParams = new BussinessParams();
        tmpInputData.setBussinessParams(tmpBussinessParams);
        ArrayList<String> operNameList = new ArrayList<String>();
        operNameList.add("NSCMD_SLM_R2_EDIT_LINE");
        RowParams tmpRowParams = this.getRowParamsForMofifyLine(isSrc);
        this.operNEID = tmpNEID = Integer.valueOf(tmpRowParams.getParam("neid").getValue()).intValue();
        tmpBussinessParams.addRowParams(tmpRowParams);
        operList = TEDataConverter.convertToOperation((SubFunc)this.subfunc, (Datainterface)tmpInputData, (int)tmpNEID, operNameList);
        return operList;
    }

    private RowParams getRowParamsForMofifyLine(boolean isSrc) {
        int len = this.inputData.getBussinessParams().getRowParamsCount();
        for (int index = 0; index < len; ++index) {
            String neIDStr = this.inputData.getBussinessParams().getRowParams(index).getParam("neid").getValue();
            if (isSrc && this.neid == Integer.valueOf(neIDStr)) {
                return this.inputData.getBussinessParams().getRowParams(index);
            }
            if (isSrc || this.neid == Integer.valueOf(neIDStr)) continue;
            return this.inputData.getBussinessParams().getRowParams(index);
        }
        return null;
    }

    private ArrayList getClearUnderwaterInfoOperList(int neid) {
        ArrayList<Object> optList = new ArrayList<Object>();
        try {
            int len = this.inputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowParams rowParams = this.inputData.getBussinessParams().getRowParams(i);
                int curNEID = Integer.parseInt(rowParams.getParam("neid").getValue());
                if (neid != curNEID) continue;
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
                if (null != definitions) {
                    Operation underwaterOperation = definitions.getOperation("NSCMD_SLM_SET_UNDERSEA_EQPTNUM");
                    Input input = underwaterOperation.getInput();
                    input.setPartValue("lineID", rowParams.getParam("lineID").getValue());
                    input.setPartValue("eqptNum", "0");
                    optList.add(underwaterOperation.clone());
                }
                return optList;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Send Modify Line Undersea EQPT Fail!", (Throwable)e);
        }
        return optList;
    }

    private int sendMarineMessage(int marineNEID, List<Operation> tmpOperationList, List<Operation> resultOperList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(marineNEID, tmpOperationList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        if (0 != retCode) {
            int len = tmpOperationList.size();
            for (int i = 0; i < len; ++i) {
                tmpOperationList.get(i).getOutput(0).getFault(0).setCode(retCode + "");
            }
        }
        resultOperList.addAll(tmpOperationList);
        return retCode;
    }

    private void updateMarineLine(Operation oper, int direction) {
        int lmuSlotID = 0;
        int lasSlotID = 0;
        int lasPortID = 0;
        if (30441 == oper.getCmdid()) {
            Input input = oper.getInput();
            lmuSlotID = Integer.parseInt(input.getPart("lmuSlot").getValue());
            lasSlotID = Integer.parseInt(input.getPart("lasSlot").getValue());
            lasPortID = Integer.parseInt(input.getPart("lasPort").getValue());
        }
        if (1 == direction && null != this.srcMarineLinePO) {
            this.srcMarineLinePO.setLMUSlot((long)lmuSlotID);
            this.srcMarineLinePO.setLASSlot((long)lasSlotID);
            this.srcMarineLinePO.setLASPort((long)lasPortID);
        } else if (null != this.snkMarineLinePO) {
            this.snkMarineLinePO.setLMUSlot((long)lmuSlotID);
            this.snkMarineLinePO.setLASSlot((long)lasSlotID);
            this.snkMarineLinePO.setLASPort((long)lasPortID);
        }
    }

    private void updateWaveLen(Operation oper, int direction) {
        int probeWaveBand = 0;
        int probeWaveIndex = 0;
        int loadingWaveBand = 0;
        int loadingWaveIndex = 0;
        if (30448 == oper.getCmdid()) {
            Input input = oper.getInput();
            probeWaveBand = Integer.parseInt(input.getPart("probeWaveBand").getValue());
            probeWaveIndex = Integer.parseInt(input.getPart("probeWaveIndex").getValue());
            loadingWaveBand = Integer.parseInt(input.getPart("loadingWaveBand").getValue());
            loadingWaveIndex = Integer.parseInt(input.getPart("loadingWaveIndex").getValue());
        }
        if (1 == direction && null != this.srcMarineLinePO) {
            this.srcMarineLinePO.setProbeWaveBand(probeWaveBand);
            this.srcMarineLinePO.setProbeWaveLenth(probeWaveIndex);
            this.srcMarineLinePO.setCompensatoryWaveBand(loadingWaveBand);
            this.srcMarineLinePO.setCompensatoryWaveLenth(loadingWaveIndex);
        } else if (null != this.snkMarineLinePO) {
            this.snkMarineLinePO.setProbeWaveBand(probeWaveBand);
            this.snkMarineLinePO.setProbeWaveLenth(probeWaveIndex);
            this.snkMarineLinePO.setCompensatoryWaveBand(loadingWaveBand);
            this.snkMarineLinePO.setCompensatoryWaveLenth(loadingWaveIndex);
        }
    }

    private void updataLineRemark(Operation oper, int direction) {
        String newRemark = "";
        if (30404 == oper.getCmdid()) {
            Input input = oper.getInput();
            newRemark = input.getPart("lineRemark").getValue();
        }
        if (1 == direction && null != this.srcMarineLinePO) {
            this.srcMarineLinePO.setRemark(newRemark);
        } else if (null != this.snkMarineLinePO) {
            this.snkMarineLinePO.setRemark(newRemark);
        }
    }

    private void updataSpanPO(Operation oper, int direction) {
        ArrayList<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
        int newSpanNum = 0;
        if (30408 == oper.getCmdid()) {
            Input input = oper.getInput();
            newSpanNum = Integer.parseInt(input.getPart("spanNum").getValue());
        }
        Set spanPOSet = null;
        if (1 == direction && null != this.srcMarineLinePO) {
            spanPOSet = this.srcMarineLinePO.getSpanList();
        } else if (null != this.snkMarineLinePO) {
            spanPOSet = this.snkMarineLinePO.getSpanList();
        }
        if (null != spanPOSet && spanPOSet.size() != newSpanNum) {
            AsnSpanStructList asnSpanList = new AsnSpanStructList();
            AsnSpanStruct asnSpan = null;
            for (TELineSpanPO spanPO : spanPOSet) {
                asnSpan = new AsnSpanStruct();
                asnSpan.spanID = BigInteger.valueOf(spanPO.getSpanID());
                asnSpan.fiberType = spanPO.getFiberType().getBytes();
                asnSpan.refractiveIndex = BigInteger.valueOf(spanPO.getRefractiveIndex());
                asnSpan.atteCoefficient = BigInteger.valueOf(spanPO.getAtteCoefficient());
                asnSpan.fiberLenth = BigInteger.valueOf(spanPO.getFiberLenth());
                asnSpanList.add((Object)asnSpan);
            }
            TEMarineLinePubFun.updateSpanList(newSpanNum, asnSpanList, spanPOSet, direction, errorDetialList);
        }
    }

    private void updataEqptPO(Operation eqptNumOper, List<Operation> underwaterList, int direction) {
        ArrayList<TEMarineLineError> errorDetialList = new ArrayList<TEMarineLineError>();
        int newEqptNum = 0;
        if (30442 == eqptNumOper.getCmdid()) {
            Input input = eqptNumOper.getInput();
            newEqptNum = Integer.parseInt(input.getPart("eqptNum").getValue());
        }
        Set eqptPOSet = null;
        if (1 == direction && null != this.srcMarineLinePO) {
            eqptPOSet = this.srcMarineLinePO.getDeviceList();
        } else if (null != this.snkMarineLinePO) {
            eqptPOSet = this.snkMarineLinePO.getDeviceList();
        }
        Set spanPOSet = null;
        if (1 == direction && null != this.srcMarineLinePO) {
            spanPOSet = this.srcMarineLinePO.getSpanList();
        } else if (null != this.snkMarineLinePO) {
            spanPOSet = this.snkMarineLinePO.getSpanList();
        }
        AsnEqptStructList asnEqmList = new AsnEqptStructList();
        int len = underwaterList.size();
        for (int i = 0; i < len; ++i) {
            Operation tmpOper = underwaterList.get(i);
            Output output = tmpOper.getOutput()[0];
            Fault[] faultArr = output.getFault();
            Input input1 = tmpOper.getInput();
            String eqptId = input1.getPart("eqptId").getValue();
            AsnEqptStruct asnEqm = new AsnEqptStruct();
            asnEqm.eqptID = BigInteger.valueOf(Integer.parseInt(input1.getPart("eqptId").getValue()));
            asnEqm.eqptType = BigInteger.valueOf(Integer.parseInt(input1.getPart("eqptType").getValue()));
            asnEqm.eqptName = input1.getPart("eqptName").getValue().getBytes();
            asnEqm.eqptSpan = BigInteger.valueOf(Integer.parseInt(input1.getPart("spanId").getValue()));
            asnEqm.eqptPos = BigInteger.valueOf(Integer.parseInt(input1.getPart("eqptDistance").getValue()));
            for (TELineSpanPO spanPO : spanPOSet) {
                if (spanPO.getSpanID() != Integer.parseInt(eqptId)) continue;
                asnEqm.fiberLenth = BigInteger.valueOf(spanPO.getFiberLenth());
            }
            asnEqm.isAdd = BigInteger.valueOf(0L);
            asnEqmList.add((Object)asnEqm);
            for (Fault fault : faultArr) {
                int code1;
                if (null == fault.getCode() || (code1 = Integer.parseInt(fault.getCode())) == 0) continue;
                TEMarineLineError error = new TEMarineLineError();
                error.setCmdID(30444);
                error.setErrObject(eqptId);
                error.setErrValue(code1);
                errorDetialList.add(error);
            }
        }
        if (null != asnEqmList && null != eqptPOSet) {
            TEMarineLinePubFun.updateEqptList(newEqptNum, asnEqmList, eqptPOSet, direction, errorDetialList);
        }
    }

    private void getMarineLinePO(int srcNeID, int snkNeID, int lineID) {
        TEDaoOperationResult dbResult1 = null;
        TESLMLinePO tmpPO = null;
        try {
            dbResult1 = TECommonDaoService.findAll((int[])new int[]{srcNeID}, TESLMLinePO.class);
            List data = dbResult1.getData();
            for (Object obj : data) {
                tmpPO = (TESLMLinePO)obj;
                this.srcLinePOList.add(tmpPO);
                if (lineID != tmpPO.LineID) continue;
                this.srcMarineLinePO = tmpPO;
            }
            if (0 != snkNeID) {
                dbResult1 = TECommonDaoService.findAll((int[])new int[]{snkNeID}, TESLMLinePO.class);
                data = dbResult1.getData();
                for (Object obj : data) {
                    tmpPO = (TESLMLinePO)obj;
                    this.snkLinePOList.add(tmpPO);
                    if (lineID != tmpPO.LineID) continue;
                    this.snkMarineLinePO = tmpPO;
                }
            }
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
        }
    }

    private void saveMarineLinePO(int srcNeID, int snkNeID) {
        TEDaoOperationResult dbResult1 = null;
        try {
            if (null != this.srcMarineLinePO && 0 != (dbResult1 = TECommonDaoService.update((int[])new int[]{srcNeID}, (Object)this.srcMarineLinePO)).getResult()) {
                normalLogger.error("Save LinePO failed!");
            }
            if (null != this.snkMarineLinePO && 0 != (dbResult1 = TECommonDaoService.update((int[])new int[]{snkNeID}, (Object)this.snkMarineLinePO)).getResult()) {
                normalLogger.error("Save LinePO failed!");
            }
            return;
        }
        catch (Exception e) {
            normalLogger.error(e.toString());
            return;
        }
    }
}

