/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr_u2kv1r3c00;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nemgr.marine.bumanagement.util.TEMarineBUUtil;
import com.huawei.nglct.nemgr.marine.common.TESLMSinkNEStruct;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;

public final class TESLMLineHandleUtil {
    public static final int DEFAULT_OPNE_NOTEXIST_ID = 0;
    public static final int DEFAULT_OPLMI_NOTEXIST_ID = 0;
    private static final int PARM_INDEX_SLOTID = 0;
    private static final int PARM_INDEX_NEID = 1;
    private static final int PARM_INDEX_NENAME = 2;
    private static final int PARM_INDEX_BDNAME = 3;
    private static final int PARM_INDEX_BDTYPE = 4;
    private static final int PARM_INDEX_PORTID = 5;
    private static final int PARM_INDEX_PORTNAME = 6;
    private static final int DEFAULT_VALUE = 0;
    private static final String UNKNOWN = "UNKNOWN";
    private static final int POSITIVE_LINE_DIRECTION = 1;
    private static final boolean OPT_SINGLELINE = true;
    private static final boolean OPT_NENOTEXIST = false;

    private TESLMLineHandleUtil() {
    }

    public static int handleQueryLineOPNENotExist(TESLMSinkNEStruct sinkNEStuct, Datainterface outputData) {
        if (null == sinkNEStuct) {
            return 2;
        }
        int opNEID = sinkNEStuct.getSinkNEID();
        int opLMISlotID = sinkNEStuct.getSinkLMISlotID();
        if (0 == opNEID && 0 == opLMISlotID) {
            TESLMLineHandleUtil.handleLineInfo(outputData, sinkNEStuct, true);
            return 0;
        }
        TESLMLineHandleUtil.handleLineInfo(outputData, sinkNEStuct, true);
        return 0;
    }

    private static void handleLineInfo(Datainterface outputData, TESLMSinkNEStruct sinkNEStuct, boolean opt) {
        int lineID = sinkNEStuct.getLineID();
        int direction = sinkNEStuct.getDirection();
        int neID = sinkNEStuct.getSinkNEID();
        ArrayList rowParamsList = outputData.getBussinessParams().getRowParamList();
        for (RowParams rowParams : rowParamsList) {
            int tmpLineID;
            Param param = rowParams.getParam("lineID");
            if (null != param && lineID == (tmpLineID = Integer.valueOf(param.getValue()).intValue())) {
                TESLMLineHandleUtil.handleOpNENotExistDetail(direction, rowParams);
            }
            if (opt) continue;
            TESLMLineHandleUtil.handlePartSuccessData(neID, outputData, rowParams);
        }
    }

    private static void handlePartSuccessData(int neID, Datainterface outputData, RowParams rowParams) {
        RowErrors rowError = new RowErrors();
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
        Param param = new Param();
        param.setName("neID");
        param.setValue(String.valueOf(neID));
        rowError.addParam(param);
        rowParams.addRowErrors(rowError);
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
    }

    private static void handleOpNENotExistDetail(int direction, RowParams rowParams) {
        if (1 != direction) {
            TESLMLineHandleUtil.convertLineSrcOutput(rowParams);
        } else {
            TESLMLineHandleUtil.convertLineSinkOutput(rowParams);
        }
    }

    private static void handleSingleLineSinkInfo(Datainterface outputData, int lineID) {
        ArrayList rowParamsList = outputData.getBussinessParams().getRowParamList();
        for (RowParams rowParams : rowParamsList) {
            int tmpLineID;
            Param param = rowParams.getParam("lineID");
            if (null == param || lineID != (tmpLineID = Integer.valueOf(param.getValue()).intValue())) continue;
            TESLMLineHandleUtil.convertLineSinkOutput(rowParams);
        }
    }

    private static void convertLineSrcOutput(RowParams rowParams) {
        int handleNEID = 0;
        int slotID = 0;
        int portID = 0;
        String[] lmuParamNames = new String[]{"srcLmuSlotId", "srcLmuneid", "srcLmuNeName", "srcLmuBoardName", "srcLmuBoardType", "srcLmuPortId", "srcLmuPortName"};
        TESLMLineHandleUtil.handlePortUnit(handleNEID, rowParams, lmuParamNames, 1628, slotID, portID);
        String[] loaParamNames = new String[]{"srcLasSlotId", "srcLasneid", "srcLasNeName", "srcLasBoardName", "srcLasBoardType", "srcLasPortId", "srcLasPortName"};
        TESLMLineHandleUtil.handlePortUnit(handleNEID, rowParams, loaParamNames, 1629, slotID, portID);
        String[] lmiParamNames = new String[]{"srcLmiSlotId", "srcLmineid", "srcLmiNeName", "srcLmiBoardName", "srcLmiBoardType", "srcLmiPortId", "srcLmiPortName"};
        TESLMLineHandleUtil.handlePortUnit(handleNEID, rowParams, lmiParamNames, 1630, slotID, portID);
        rowParams.addParam("srcProbeWaveBand", String.valueOf(0));
        rowParams.addParam("srcProbeWaveIndex", String.valueOf(0));
        rowParams.addParam("srcLoadingWaveBand", String.valueOf(0));
        rowParams.addParam("srcLoadingWaveIndex", String.valueOf(0));
    }

    private static void convertLineSinkOutput(RowParams rowParams) {
        int handleNEID = 0;
        int slotID = 0;
        int portID = 0;
        String[] lmuParamNames = new String[]{"sinkLmuSlotId", "sinkLmuneid", "sinkLmuNeName", "sinkLmuBoardName", "sinkLmuBoardType", "sinkLmuPortId", "sinkLmuPortName"};
        TESLMLineHandleUtil.handlePortUnit(handleNEID, rowParams, lmuParamNames, 1628, slotID, portID);
        String[] loaParamNames = new String[]{"sinkLasSlotId", "sinkLasneid", "sinkLasNeName", "sinkLasBoardName", "sinkLasBoardType", "sinkLasPortId", "sinkLasPortName"};
        TESLMLineHandleUtil.handlePortUnit(handleNEID, rowParams, loaParamNames, 1629, slotID, portID);
        String[] lmiParamNames = new String[]{"sinkLmiSlotId", "sinkLmineid", "sinkLmiNeName", "sinkLmiBoardName", "sinkLmiBoardType", "sinkLmiPortId", "sinkLmiPortName"};
        TESLMLineHandleUtil.handlePortUnit(handleNEID, rowParams, lmiParamNames, 1630, slotID, portID);
        rowParams.addParam("sinkProbeWaveBand", String.valueOf(0));
        rowParams.addParam("sinkProbeWaveIndex", String.valueOf(0));
        rowParams.addParam("sinkLoadingWaveBand", String.valueOf(0));
        rowParams.addParam("sinkLoadingWaveIndex", String.valueOf(0));
    }

    private static void handlePortUnit(int handleNEID, RowParams rowparams, String[] paramNames, int boardType, int slotID, int portID) {
        if (7 != paramNames.length) {
            return;
        }
        int neID = handleNEID;
        rowparams.addParam(paramNames[1], String.valueOf(neID));
        rowparams.addParam(paramNames[0], String.valueOf(slotID));
        rowparams.addParam(paramNames[5], String.valueOf(portID));
        TENE neInfo = TEConfigurationDataMgr.getInstance().getNE(neID);
        if (null == neInfo) {
            rowparams.addParam(paramNames[2], UNKNOWN);
            rowparams.addParam(paramNames[3], UNKNOWN);
            rowparams.addParam(paramNames[4], String.valueOf(boardType));
            rowparams.addParam(paramNames[6], UNKNOWN);
            return;
        }
        rowparams.addParam(paramNames[2], neInfo.getNEName());
        TEBoard boardInfo = neInfo.getBoard(slotID);
        if (null == boardInfo) {
            rowparams.addParam(paramNames[3], UNKNOWN);
            rowparams.addParam(paramNames[4], String.valueOf(boardType));
            rowparams.addParam(paramNames[6], UNKNOWN);
            return;
        }
        rowparams.addParam(paramNames[3], boardInfo.getBoardName());
        rowparams.addParam(paramNames[4], String.valueOf(boardInfo.getBoardType()));
        TEPort portInfo = boardInfo.getPort(portID);
        String portName = null == portInfo ? UNKNOWN : portInfo.getPortName();
        rowparams.addParam(paramNames[6], portName);
    }

    public static void getAvailBUAndTypeInfo(Datainterface outputData) {
        String[] buAndTypeStrs = TEMarineBUUtil.getAvailBUAndTypeInfo();
        if (null != buAndTypeStrs && buAndTypeStrs.length >= 2) {
            TESLMLineHandleUtil.addResRowParam(outputData, buAndTypeStrs[0], buAndTypeStrs[1]);
        }
    }

    private static void addResRowParam(Datainterface outputData, String buType1, String buType2) {
        if (null != outputData && null != outputData.getBussinessParams() && outputData.getBussinessParams().getRowParamsCount() > 0) {
            RowParams row = outputData.getBussinessParams().getRowParams(0);
            Param param = new Param("butype1", buType1);
            row.addParam(param);
            param = new Param("butype2", buType2);
            row.addParam(param);
        }
    }
}

