/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr.wnemgrsvr;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIUpLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgUploadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.QueryMarineNewLineBean;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLinePubFun;
import com.huawei.nglct.nemgr.marine.slmnewlinemgr.linee2e.TEMarineLineStruct;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineDevicePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineSpanPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEMarineLineMgrUploadHandler
implements TECIUpLoadHandler {
    protected TEDataCfgUploadPara pPara = null;
    protected Map<Integer, TEMarineLineStruct> oneNELineStrMap = new HashMap<Integer, TEMarineLineStruct>();
    protected static final int NO_NEID = 0;
    protected int neID;

    public int upLoad(TEDataCfgUploadPara pPara) {
        if (null == pPara) {
            return -1;
        }
        this.pPara = pPara;
        TEDataCfgNEInfo neInfo = pPara.getTmpNEInfo();
        this.neID = neInfo.getNeID();
        Datainterface din = new Datainterface();
        BussinessParams bus = new BussinessParams();
        din.setBussinessParams(bus);
        RowParams rp = new RowParams();
        bus.addRowParams(rp);
        Param p = null;
        int neType = neInfo.getNeType();
        String neVersion = neInfo.getNeVersion();
        p = new Param("neid", String.valueOf(this.neID));
        rp.addParam(p);
        p = new Param("lineID", String.valueOf(0));
        rp.addParam(p);
        p = new Param("version", this.convertToVersionStr(neVersion));
        rp.addParam(p);
        p = new Param("netype", String.valueOf(TEGetNEDomainVersion.getInstance().getNeType(neType)));
        rp.addParam(p);
        Datainterface allData = null;
        int sfid = 2179382;
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFuncByVer((int)this.neID, (int)sfid, (int)neType, (String)neVersion);
        }
        catch (Exception e1) {
            TELogFactory.getNormalLogger().info("TEMarineLineMgrUploadHandler get subFunc fail!");
        }
        if (null == subFunc) {
            return 0;
        }
        QueryMarineNewLineBean neMgrBean = new QueryMarineNewLineBean();
        subFunc.setTransSupport(true);
        allData = neMgrBean.performBussinessProcess(this.neID, subFunc, din, null, "", "");
        int err = Integer.parseInt(allData.getErrorMessage().getErrorcode());
        if (0 != err) {
            err = 1 == err ? 1090588678 : err;
            return err;
        }
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair neIDPair = new TEDaoNameValuePair();
        neIDPair.setName("NeID");
        neIDPair.setValue(String.valueOf(this.neID));
        criteria.add(neIDPair);
        TEDaoOperationResult dbresult = null;
        try {
            dbresult = TECommonDaoService.deleteByID_NonLock((int[])new int[]{this.neID}, TESLMLinePO.class, criteria);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEMarineLineMgrUploadHandler delete data fail!", (Throwable)e);
        }
        if (null != dbresult && 0 == Integer.parseInt(allData.getErrorMessage().getErrorcode())) {
            RowParams[] rows;
            bus = allData.getBussinessParams();
            for (RowParams row : rows = bus.getRowParams()) {
                this.getRowData(row, this.neID);
            }
            err = this.fillMarineLineMO();
        }
        return err;
    }

    protected void getRowData(RowParams rowParams, int neid) {
        Param param = null;
        param = rowParams.getParam("cmdCode");
        if (null == param) {
            return;
        }
        int cmdCode = Integer.parseInt(rowParams.getParam("cmdCode").getValue());
        switch (cmdCode) {
            case 30440: {
                this.setMarineLineInfo(rowParams, neid);
                break;
            }
            case 30449: {
                this.setLineWaveLen(rowParams, neid);
                break;
            }
            case 30405: {
                this.setLineMemo(rowParams, neid);
                break;
            }
            case 30409: {
                this.setLineSpanNum(rowParams, neid);
                break;
            }
            case 30443: {
                this.setLineEqptNum(rowParams, neid);
                break;
            }
            case 30411: {
                this.setLineFiberPara(rowParams, neid);
                break;
            }
            case 30445: {
                this.setLineEqptPos(rowParams, neid);
                break;
            }
        }
    }

    private void setMarineLineInfo(RowParams row, int neid) {
        TEMarineLineStruct lineStruct1 = new TEMarineLineStruct();
        lineStruct1.setLineID(Integer.parseInt(row.getParam("lineID").getValue()));
        int lineID = lineStruct1.getLineID();
        lineStruct1.setNeID(neid);
        lineStruct1.setLmuSlot(Integer.parseInt(row.getParam("lmuSlot").getValue()));
        lineStruct1.setLasSlot(Integer.parseInt(row.getParam("lasSlot").getValue()));
        lineStruct1.setLasPort(Integer.parseInt(row.getParam("lasPort").getValue()));
        lineStruct1.setLmiSlot(Integer.parseInt(row.getParam("lmiSlot").getValue()));
        int phyNeID = Integer.parseInt(row.getParam("opNeID").getValue());
        int logicNeID = 0 == phyNeID ? 0 : TENECommMgr.getInstance().getLogicNEID(phyNeID);
        lineStruct1.setOpNeID(logicNeID);
        lineStruct1.setOpLmiSlot(Integer.parseInt(row.getParam("opLmiSlot").getValue()));
        lineStruct1.setDirection(Integer.parseInt(row.getParam("lineDirection").getValue()));
        this.oneNELineStrMap.put(lineID, lineStruct1);
    }

    private void setLineWaveLen(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null == neLine) {
            return;
        }
        neLine.setProbeWaveBand(Integer.parseInt(row.getParam("probeWaveBand").getValue()));
        neLine.setProbeWaveIndex(Integer.parseInt(row.getParam("probeWaveIndex").getValue()));
        neLine.setLoadingWaveBand(Integer.parseInt(row.getParam("loadingWaveBand").getValue()));
        neLine.setLoadingWaveIndex(Integer.parseInt(row.getParam("loadingWaveIndex").getValue()));
    }

    private void setLineMemo(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null != neLine) {
            neLine.setRemark(row.getParam("lineRemark").getValue().trim());
        }
    }

    private void setLineSpanNum(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null != neLine) {
            neLine.setSpanNum(Integer.parseInt(row.getParam("spanNum").getValue()));
        }
    }

    private void setLineFiberPara(RowParams row, int neid) {
        List<TEMarineLineStruct.SpanStruct> spanStrList = null;
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null == neLine) {
            return;
        }
        int direction = neLine.getDirection();
        int spanNum = neLine.getSpanNum();
        spanStrList = neLine.getSpanStrList();
        if (null == spanStrList) {
            spanStrList = new ArrayList<TEMarineLineStruct.SpanStruct>();
            neLine.setSpanStrList(spanStrList);
        }
        TEMarineLineStruct.SpanStruct spanStruct = new TEMarineLineStruct.SpanStruct();
        int spanID = Integer.parseInt(row.getParam("spanNo").getValue());
        if (1 == direction) {
            spanStruct.setSpanID(spanID);
        } else {
            spanStruct.setSpanID(spanNum - spanID + 1);
        }
        spanStruct.setFiberType(row.getParam("fiberType").getValue().trim());
        spanStruct.setrefractiveIndex(Integer.parseInt(row.getParam("refraction").getValue()));
        int fiberLenth = Integer.parseInt(row.getParam("fiberLenth").getValue());
        spanStruct.setFiberLenth(fiberLenth);
        neLine.setFiberLenth(fiberLenth);
        spanStruct.setAtteCoefficient(Integer.parseInt(row.getParam("attenuation").getValue()));
        spanStrList.add(spanStruct);
    }

    private void setLineEqptNum(RowParams row, int neid) {
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null != neLine) {
            neLine.setEqptNum(Integer.parseInt(row.getParam("eqptNum").getValue()));
        }
    }

    private void setLineEqptPos(RowParams row, int neid) {
        List<TEMarineLineStruct.EqptStruct> eqptStrList = null;
        int lineID = Integer.parseInt(row.getParam("lineID").getValue());
        TEMarineLineStruct neLine = this.oneNELineStrMap.get(lineID);
        if (null == neLine) {
            return;
        }
        int direction = neLine.getDirection();
        int eqptNum = neLine.getEqptNum();
        int fiberLenth = neLine.getFiberLenth();
        int spanNum = neLine.getSpanNum();
        eqptStrList = neLine.getEqptStrList();
        if (null == eqptStrList) {
            eqptStrList = new ArrayList<TEMarineLineStruct.EqptStruct>();
            neLine.setEqptStrList(eqptStrList);
        }
        TEMarineLineStruct.EqptStruct eqptStruct = new TEMarineLineStruct.EqptStruct();
        int eqptID = TEMarineLinePubFun.getNERelID(Integer.parseInt(row.getParam("eqptId").getValue()), eqptNum, direction);
        int spanID = TEMarineLinePubFun.getNERelID(Integer.parseInt(row.getParam("spanId").getValue()), spanNum, direction);
        int eqptPos = TEMarineLinePubFun.getEqptRelPos(Integer.parseInt(row.getParam("eqptPos").getValue()), fiberLenth, direction);
        eqptStruct.setEqptID(eqptID);
        eqptStruct.setEqptSpan(spanID);
        eqptStruct.setEqptPos(eqptPos);
        eqptStruct.setEqptType(Integer.parseInt(row.getParam("eqptType").getValue()));
        eqptStruct.setEqptName(row.getParam("eqptName").getValue().trim());
        eqptStrList.add(eqptStruct);
    }

    protected int fillMarineLineMO() {
        if (null == this.oneNELineStrMap || 0 == this.neID) {
            return 0;
        }
        Iterator<Map.Entry<Integer, TEMarineLineStruct>> itMap = this.oneNELineStrMap.entrySet().iterator();
        TEMarineLineStruct neLineStr = null;
        Set<TELineSpanPO> spanList = null;
        Set<TELineDevicePO> eqpList = null;
        List<TEMarineLineStruct.SpanStruct> spanStrList = null;
        List<TEMarineLineStruct.EqptStruct> eqptStrList = null;
        TESLMLinePO marineLine = null;
        int errorCode = 0;
        while (itMap.hasNext()) {
            Map.Entry<Integer, TEMarineLineStruct> entry = itMap.next();
            neLineStr = entry.getValue();
            marineLine = new TESLMLinePO();
            marineLine.setNeID((long)this.neID);
            marineLine.setLineID(neLineStr.getLineID());
            marineLine.setLMUSlot(neLineStr.getLmuSlot());
            marineLine.setLMUPort(1L);
            marineLine.setLASSlot(neLineStr.getLasSlot());
            marineLine.setLASPort(neLineStr.getLasPort());
            marineLine.setLMISlot(neLineStr.getLmiSlot());
            marineLine.setLMIPort(2L);
            marineLine.setOppositeNEID(neLineStr.getOpNeID());
            marineLine.setOppositeLMISlot(neLineStr.getOpLmiSlot());
            marineLine.setOppositeLMIPort(2L);
            marineLine.setProbeWaveBand(neLineStr.getProbeWaveBand());
            marineLine.setProbeWaveLenth(neLineStr.getProbeWaveIndex());
            marineLine.setCompensatoryWaveBand(neLineStr.getLoadingWaveBand());
            marineLine.setCompensatoryWaveLenth(neLineStr.getLoadingWaveIndex());
            marineLine.setDirection(neLineStr.getDirection());
            marineLine.setRemark(null == neLineStr.getRemark() ? "" : neLineStr.getRemark());
            marineLine.setSpanNum(neLineStr.getSpanNum());
            marineLine.setEqptNum(neLineStr.getEqptNum());
            spanStrList = neLineStr.getSpanStrList();
            if (null != spanStrList) {
                spanList = this.getSpanList(spanStrList);
                marineLine.setSpanList(spanList);
            }
            if (null != (eqptStrList = neLineStr.getEqptStrList())) {
                eqpList = this.getEqptList(eqptStrList);
                marineLine.setDeviceList(eqpList);
            }
            TEDaoOperationResult dbresult = null;
            try {
                dbresult = TECommonDaoService.create_NonLock((int[])new int[]{this.neID}, (Object)marineLine);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            }
            if (null == dbresult || 0 == dbresult.getResult()) continue;
            TELogFactory.getNormalLogger().error("save data fail!");
            errorCode = dbresult.getResult();
        }
        return errorCode;
    }

    private Set<TELineSpanPO> getSpanList(List<TEMarineLineStruct.SpanStruct> spanStrList) {
        HashSet<TELineSpanPO> spanSet = new HashSet<TELineSpanPO>();
        TELineSpanPO span = null;
        for (TEMarineLineStruct.SpanStruct spanObj : spanStrList) {
            span = new TELineSpanPO();
            span.setSpanID(spanObj.getSpanID());
            span.setFiberType(spanObj.getFiberType());
            span.setRefractiveIndex(spanObj.getRefractiveIndex());
            span.setFiberLenth(spanObj.getFiberLenth());
            span.setAtteCoefficient(spanObj.getAtteCoefficient());
            spanSet.add(span);
        }
        return spanSet;
    }

    private Set<TELineDevicePO> getEqptList(List<TEMarineLineStruct.EqptStruct> eqptStrList) {
        HashSet<TELineDevicePO> eqptSet = new HashSet<TELineDevicePO>();
        TELineDevicePO eqpt = null;
        for (TEMarineLineStruct.EqptStruct eqptObj : eqptStrList) {
            eqpt = new TELineDevicePO();
            eqpt.setDeviceID(eqptObj.getEqptID());
            eqpt.setSpanID(eqptObj.getEqptSpan());
            eqpt.setDeviceType(eqptObj.getEqptType());
            eqpt.setRemark(eqptObj.getEqptName());
            eqpt.setDistance(eqptObj.getEqptPos());
            eqptSet.add(eqpt);
        }
        return eqptSet;
    }

    public int getItemID() {
        return 2179382;
    }

    public String getItemName() {
        return this.pPara.getCfgItemName();
    }

    public TECfgItem getOperIF(int OperType) {
        return null;
    }

    protected String convertToVersionStr(String neVersion) {
        if (null == neVersion || "".equals(neVersion)) {
            return "";
        }
        String[] tmpArray = neVersion.split("\\.");
        StringBuffer neVersionStr = new StringBuffer();
        for (int i = 0; i < tmpArray.length; ++i) {
            String indexStr = tmpArray[i];
            int tmpValue = Integer.valueOf(indexStr);
            if (0 != i && tmpValue >= 0 && tmpValue <= 10) {
                indexStr = "0" + tmpValue;
            }
            neVersionStr.append(indexStr);
            if (i == tmpArray.length - 1) continue;
            neVersionStr.append(".");
        }
        return neVersionStr.toString();
    }
}

