/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class TESLMQueryAvailablePortBean
extends TENEExplorerBean {
    private static final int SLM_LMI_PORT_ID = 2;
    private static final int SLM_LOA_PORT_NONSUPPORT_ID = 2;
    private static final int SLM_LSU_PORT_NONSUPPORT_ID = 9;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.outputData = new Datainterface();
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        if (null != neObj) {
            this.getAvaliableBoard();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
        }
        return this.outputData;
    }

    private void getAvaliableBoard() {
        int slotId;
        int boardType;
        this.outputData.setBussinessParams(new BussinessParams());
        TEBoard board = null;
        String boardName = null;
        Vector boardList = TENEListMgr.getInstance().getNE(this.neid).getClonedBoardList();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            board = (TEBoard)boardList.get(i);
            boardType = board.getBoardType();
            boardName = board.getBoardName();
            slotId = board.getSlotID();
            if (1229 != boardType && 1228 != boardType && 1227 != boardType) continue;
            this.addAvailablePort(boardType, boardName, slotId);
        }
        TIntArrayList neList = TENEListMgr.getInstance().getNEIDList();
        int len = neList.size();
        for (int i = 0; i < len; ++i) {
            TENE neData = TENEListMgr.getInstance().getNE(neList.get(i));
            Vector bdList = TENEListMgr.getInstance().getNE(neData.getNEID()).getBoardList();
            if (null == bdList) continue;
            int indexLen = bdList.size();
            for (int index = 0; index < indexLen; ++index) {
                board = (TEBoard)bdList.get(index);
                boardType = board.getBoardType();
                boardName = board.getBoardName();
                slotId = board.getSlotID();
                if (1226 != boardType) continue;
                this.addAvailableLMIPort(boardType, boardName, slotId, neData);
            }
        }
    }

    private void addAvailablePort(int boardType, String boardName, int slotId) {
        RowParams rowparams = null;
        ArrayList portList = TEQueryLogicPort.getLogicPortList((int)this.neid, (int)slotId, (int)boardType);
        Collections.sort(portList);
        int phyNEId = TEConfigurationDataMgr.getInstance().getNE(this.neid).getRealNEID();
        int portLen = portList.size();
        for (int lmiIndex = 0; lmiIndex < portLen; ++lmiIndex) {
            int portId = (Integer)portList.get(lmiIndex);
            if (1228 == boardType && 2 == portId || 1227 == boardType && 9 == portId) continue;
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(phyNEId));
            rowparams.addParam("neName", TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEName());
            rowparams.addParam("slotId", String.valueOf(slotId));
            rowparams.addParam("boardName", boardName);
            rowparams.addParam("boardType", String.valueOf(boardType));
            rowparams.addParam("portId", String.valueOf(portId));
            rowparams.addParam("portName", TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotId, boardType, portId));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    private void addAvailableLMIPort(int boardType, String boardName, int slotId, TENE neData) {
        RowParams rowparams = null;
        ArrayList portList = TEQueryLogicPort.getLogicPortList((int)neData.getNEID(), (int)slotId, (int)boardType);
        Collections.sort(portList);
        int portLen = portList.size();
        for (int lmiIndex = 0; lmiIndex < portLen; ++lmiIndex) {
            int portId = (Integer)portList.get(lmiIndex);
            if (2 != portId) continue;
            rowparams = new RowParams();
            rowparams.addParam("neid", String.valueOf(neData.getRealNEID()));
            rowparams.addParam("neName", neData.getNEName());
            rowparams.addParam("slotId", String.valueOf(slotId));
            rowparams.addParam("boardName", boardName);
            rowparams.addParam("boardType", String.valueOf(boardType));
            rowparams.addParam("portId", String.valueOf(portId));
            rowparams.addParam("portName", TEConfigurationDataMgr.getInstance().getPortName(neData.getNEID(), slotId, boardType, portId));
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

