/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.slmlinemgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.filedata.TESLMTestFile;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TESLMActivateBaselineBean
extends TENEExplorerBean {
    private static final int NSCMD_SLM_ACTIVATE_BASELINE = 30420;
    private static final int NSCMD_SLM_GET_LINESTATE = 30402;
    protected static final int NSERR_SLM_FILEOPT_ERR = 43059;
    protected static final int NSERR_SLM_BASELINE_ALREADY_EXIST = 42794;
    private static final int FILE_OPERATE_FAILED = 1091092491;
    protected static final int SLM_LINE_FREE_STATE = 1;
    protected static final int SLM_LINE_TESTING_ERROR = 42782;
    protected int succCount = 0;
    protected int partSuccErrorCode = 0;
    private Definitions definitions = null;
    protected ArrayList tmpOperationList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            String nename = TEConfigurationDataMgr.getInstance().getNE(neid).getNEName();
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            RowParams[] inputrows = inputData.getBussinessParams().getRowParams();
            int lineID = Integer.parseInt(inputrows[0].getParam("lineID").getValue());
            int lmiPhyNEID = Integer.parseInt(inputrows[0].getParam("lmineid").getValue());
            int lmiSlotId = Integer.parseInt(inputrows[0].getParam("lmiSlotId").getValue());
            int lmiPortId = Integer.parseInt(inputrows[0].getParam("lmiPortId").getValue());
            this.operationList = this.getQueryOperation(neid, lineID);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                Operation operation = (Operation)this.operationList.get(0);
                int errorCode = Integer.parseInt(operation.getOutput(0).getFault(0).getCode());
                if (0 == errorCode) {
                    int lmineid = TENEListMgr.getInstance().getPhyNE(lmiPhyNEID).getNEID();
                    int currentWorkStatus = Integer.parseInt(operation.getOutput(0).getPart("currentWorkStatus").getValue());
                    if (1 == currentWorkStatus) {
                        int baseRet;
                        List fileList = TESLMOTDRDataMgr.getUnactivedFileList(neid, lmineid, lmiSlotId, lmiPortId);
                        if (fileList == null || fileList.isEmpty()) {
                            return this.sendSuccessHandler(subFunc, user, ipAddress);
                        }
                        ArrayList<TESLMTestFile> testFileList = new ArrayList<TESLMTestFile>();
                        ArrayList<TESLMTestFile> baselineFileList = new ArrayList<TESLMTestFile>();
                        int len = fileList.size();
                        for (int i = 0; i < len; ++i) {
                            TESLMTestFile testFile = (TESLMTestFile)fileList.get(i);
                            if (testFile.isBaseLIne()) {
                                baselineFileList.add(testFile);
                                continue;
                            }
                            testFileList.add(testFile);
                        }
                        fileList.clear();
                        fileList = null;
                        int testRet = this.sendFile(testFileList, inputrows, 43059, subFunc, user, ipAddress);
                        if (0 != testRet) {
                            return this.sendFailedHandler(subFunc, user, ipAddress, testRet);
                        }
                        if (this.succCount == testFileList.size()) {
                            TESLMOTDRDataMgr.activeLine(neid, lineID, lmineid, lmiSlotId, lmiPortId);
                        }
                        if (0 != (baseRet = this.sendFile(baselineFileList, inputrows, 42794, subFunc, user, ipAddress))) {
                            return this.sendFailedHandler(subFunc, user, ipAddress, baseRet);
                        }
                        ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                        this.operationList = (ArrayList)this.tmpOperationList.clone();
                        this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
                        if (0 == this.partSuccErrorCode) {
                            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                        } else {
                            BussinessParams bussinessParams = this.getBussinessParams();
                            RowParams rowParams = new RowParams();
                            RowErrors rowError = new RowErrors();
                            rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.partSuccErrorCode));
                            Param param = new Param();
                            param.setName("nename");
                            param.setValue(nename);
                            rowError.addParam(param);
                            rowParams.addRowErrors(rowError);
                            bussinessParams.addRowParams(rowParams);
                            this.outputData.setBussinessParams(bussinessParams);
                            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
                        }
                    } else {
                        BussinessParams bussinessParams = this.getBussinessParams();
                        RowParams rowParams = new RowParams();
                        RowErrors rowError = new RowErrors();
                        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)42782));
                        Param param = new Param();
                        param.setName("nename");
                        param.setValue(nename);
                        rowError.addParam(param);
                        rowParams.addRowErrors(rowError);
                        bussinessParams.addRowParams(rowParams);
                        this.outputData.setBussinessParams(bussinessParams);
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                    }
                } else {
                    BussinessParams bussinessParams = this.getBussinessParams();
                    RowParams rowParams = new RowParams();
                    RowErrors rowError = new RowErrors();
                    rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorCode));
                    Param param = new Param();
                    param.setName("nename");
                    param.setValue(nename);
                    rowError.addParam(param);
                    rowParams.addRowErrors(rowError);
                    bussinessParams.addRowParams(rowParams);
                    this.outputData.setBussinessParams(bussinessParams);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected BussinessParams getBussinessParams() {
        if (null != this.outputData.getBussinessParams()) {
            return this.outputData.getBussinessParams();
        }
        return new BussinessParams();
    }

    protected Datainterface sendFailedHandler(SubFunc subFunc, String user, String ipAddress, int errorCode) {
        BussinessParams bussinessParams = this.getBussinessParams();
        RowParams rowParams = new RowParams();
        RowErrors rowError = new RowErrors();
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errorCode));
        Param param = new Param();
        param.setName("nename");
        param.setValue(TEConfigurationDataMgr.getInstance().getNE(this.neid).getNEName());
        rowError.addParam(param);
        rowParams.addRowErrors(rowError);
        bussinessParams.addRowParams(rowParams);
        this.outputData.setBussinessParams(bussinessParams);
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, this.inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    protected Datainterface sendSuccessHandler(SubFunc subFunc, String user, String ipAddress) {
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (this.isNeedOperationlog()) {
            this.writeLog(this.neid, this.subfunc, this.inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    protected int sendFile(ArrayList fileList, RowParams[] inputrows, int fileErrorcode, SubFunc subFunc, String user, String ipAddress) {
        int lineID = Integer.parseInt(inputrows[0].getParam("lineID").getValue());
        this.succCount = 0;
        if (0 == fileList.size()) {
            this.succCount = fileList.size();
            return 0;
        }
        int len = fileList.size();
        for (int index = 0; index < len; ++index) {
            TESLMTestFile testFile = (TESLMTestFile)fileList.get(index);
            String neFileName = this.getNEFileName(testFile.getFileName());
            File sendToNEFile = TESLMOTDRDataMgr.copyNewFile(this.neid, testFile.getFileName(), neFileName);
            if (null == sendToNEFile) {
                return 1091092491;
            }
            int ret = TESLMOTDRDataMgr.sendFileToNE(this.neid, neFileName);
            try {
                sendToNEFile.delete();
            }
            catch (Exception e1) {
                TELogFactory.getNormalLogger().error("sendFile fail!", (Throwable)e1);
            }
            if (0 != ret) {
                return ret;
            }
            this.operationList = this.getOperation(this.neid, inputrows, testFile);
            int result = this.sendMessage(this.neid);
            if (result == 0) {
                if (null == this.operationList || 0 == this.operationList.size()) continue;
                Operation operation = (Operation)this.operationList.get(0);
                int errorCount = operation.getOutput(0).getFaultCount();
                for (int i = 0; i < errorCount; ++i) {
                    int errorcode = Integer.parseInt(operation.getOutput(0).getFault(i).getCode());
                    if (0 == errorcode) {
                        if (testFile.isBaseLIne()) {
                            TESLMOTDRDataMgr.updateBaseLineAfterActiveOp(this.neid, lineID, testFile);
                        }
                        this.addOperationList(this.tmpOperationList);
                        ++this.succCount;
                        continue;
                    }
                    if (errorcode == fileErrorcode) {
                        this.partSuccErrorCode = fileErrorcode;
                        if (testFile.isBaseLIne()) {
                            TESLMOTDRDataMgr.backupBaseLineAfterActiveOp(this.neid, lineID, testFile);
                        }
                        this.addOperationList(this.tmpOperationList);
                        ++this.succCount;
                        continue;
                    }
                    return errorcode;
                }
                continue;
            }
            return result;
        }
        return 0;
    }

    protected void addOperationList(ArrayList tmpList) {
        for (Operation operation : this.operationList) {
            tmpList.add(operation);
        }
    }

    public ArrayList getOperation(int neid, RowParams[] inputrows, TESLMTestFile testFile) {
        Operation operation = null;
        Input input = null;
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
        ArrayList<Object> tmpOperationList = new ArrayList<Object>();
        operation = this.definitions.getOperation(30420);
        input = operation.getInput();
        input.setPartValue("lineID", inputrows[0].getParam("lineID").getValue());
        input.setPartValue("testMode", String.valueOf(testFile.getTestMode()));
        input.setPartValue("testType", String.valueOf(testFile.getTestType()));
        String neFileName = this.getNEFileName(testFile.getFileName());
        input.setPartValue("fileLength", String.valueOf(neFileName.length()));
        input.setPartValue("fileName", neFileName);
        tmpOperationList.add(operation.clone());
        return tmpOperationList;
    }

    protected ArrayList getQueryOperation(int neid, int lineID) {
        Operation operation = null;
        Input input = null;
        try {
            this.definitions = TECreateObjectFactory.parseQxDesFile((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getQueryOperation fail!", (Throwable)e);
            return null;
        }
        ArrayList<Object> tmpOperationList = new ArrayList<Object>();
        operation = this.definitions.getOperation(30402);
        input = operation.getInput();
        input.setPartValue("lineID", String.valueOf(lineID));
        tmpOperationList.add(operation.clone());
        return tmpOperationList;
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("slmlinemgr").append(File.separator).append("slmlinemgr_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        StringBuffer detailStr = new StringBuffer();
        detailStr.append(res.getString("LINE_ID")).append(rowparams.getParam("lineID").getValue());
        return detailStr.toString();
    }

    protected String getNEFileName(String nmFileName) {
        String fileNameTmp = nmFileName.substring(0, nmFileName.lastIndexOf("."));
        String[] propArray = fileNameTmp.split("_");
        String nmTime = propArray[5];
        String suffix = TESLMOTDRDataMgr.getFileSuffixTypeStr(nmFileName);
        return TESLMOTDRDataMgr.convertNMFileTimeToNEFileTime(nmTime, this.neid) + "." + suffix;
    }
}

