/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.locator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.quicklocating.QuickLocatingMainMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocater;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObj;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObjByOTDR;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObjByPFE;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocatorByOTDR;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocatorByPFE;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.QFLocatorInf;

public class QFLocatorMgr {
    private static QFLocatorMgr locatorMgr = new QFLocatorMgr();

    private QFLocatorMgr() {
    }

    public static QFLocatorMgr getInstance() {
        return locatorMgr;
    }

    public QFLocatorInf getLocator(int faultType, QuickLocatingMainMgr mainMgr) {
        FaultLocater locator = null;
        switch (faultType) {
            case 1: {
                locator = new FaultLocatorByPFE(mainMgr);
                break;
            }
            case 2: {
                locator = new FaultLocatorByOTDR(mainMgr);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().error("Can not get the locator! False type is " + faultType);
            }
        }
        return locator;
    }

    public FaultLocationObj getLocationObj(int faultType) {
        FaultLocationObj locationObj = null;
        switch (faultType) {
            case 1: {
                locationObj = new FaultLocationObjByPFE();
                break;
            }
            case 2: {
                locationObj = new FaultLocationObjByOTDR();
                break;
            }
            default: {
                TELogFactory.getNormalLogger().error("Can not get the locationObj! False type is " + faultType);
            }
        }
        return locationObj;
    }
}

