/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.locator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EConstants;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEQuickFaultDaoService;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.GeographicCoordinate;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.Latitude;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.Longitude;
import com.huawei.nglct.nemgr.marine.e2ecommon.longlatcalculor.PositionCalculator;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoDetailPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultInfoPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultUserPO;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;

class FaultPointLocation {
    private static final String KILOMETRE_STR = "km";
    private double distance;
    private TEMarineEngineerInfoDetailPO preDetail;
    private TEMarineEngineerInfoDetailPO curDetail;
    private boolean isDetailForward;
    private double dis_to_detailStart;
    private String startPointName;
    private GeographicCoordinate resultPoint = null;
    private TEMarineQuickFaultInfoPO qfInfoPO = null;
    private TEResourceUtil res = TEMarineE2EConstants.LOGRES;
    private int fromNEID = -1;
    private int deepness;
    private long faultTime;

    FaultPointLocation() {
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public int getDeepness() {
        return this.deepness;
    }

    public void setDeepness(int deepness) {
        this.deepness = deepness;
    }

    public TEMarineEngineerInfoDetailPO getPreDetail() {
        return this.preDetail;
    }

    public void setPreDetail(TEMarineEngineerInfoDetailPO preDetail) {
        this.preDetail = preDetail;
    }

    public TEMarineEngineerInfoDetailPO getCurDetail() {
        return this.curDetail;
    }

    public void setCurDetail(TEMarineEngineerInfoDetailPO curDetail) {
        this.curDetail = curDetail;
    }

    public boolean isDetailForward() {
        return this.isDetailForward;
    }

    public void setDetailForward(boolean isDetailForward) {
        this.isDetailForward = isDetailForward;
    }

    public double getDis_to_detailStart() {
        return this.dis_to_detailStart;
    }

    public void setDis_to_detailStart(double disToDetailStart) {
        this.dis_to_detailStart = disToDetailStart;
    }

    public String getStartPointName() {
        return this.startPointName;
    }

    public void setStartPointName(String startPointName) {
        this.startPointName = startPointName;
    }

    public void setFromNEID(int fromNEID) {
        this.fromNEID = fromNEID;
    }

    public int calcPointPosition() {
        if (!this.isRightConditions()) {
            return this.checkFaultPointInStn();
        }
        if (null == this.preDetail) {
            Latitude curLat = new Latitude(Integer.parseInt(this.curDetail.getLatitudeDegree()), Double.parseDouble(this.curDetail.getLatitudeMinute()), this.curDetail.getLatitudeDirection().toCharArray()[0]);
            Longitude curLong = new Longitude(Integer.parseInt(this.curDetail.getLongitudeDegree()), Double.parseDouble(this.curDetail.getLongitudeMinute()), this.curDetail.getLongitudeDirection().toCharArray()[0]);
            this.resultPoint = new GeographicCoordinate(curLat, curLong);
            TELogFactory.getNormalLogger().debug("The point is the end point! The point is " + curLat.toString() + curLong.toString());
            return 0;
        }
        Latitude startLat = new Latitude(Integer.parseInt(this.preDetail.getLatitudeDegree()), Double.parseDouble(this.preDetail.getLatitudeMinute()), this.preDetail.getLatitudeDirection().toCharArray()[0]);
        Longitude startLong = new Longitude(Integer.parseInt(this.preDetail.getLongitudeDegree()), Double.parseDouble(this.preDetail.getLongitudeMinute()), this.preDetail.getLongitudeDirection().toCharArray()[0]);
        GeographicCoordinate startPoint = new GeographicCoordinate(startLat, startLong);
        Latitude endLat = new Latitude(Integer.parseInt(this.curDetail.getLatitudeDegree()), Double.parseDouble(this.curDetail.getLatitudeMinute()), this.curDetail.getLatitudeDirection().toCharArray()[0]);
        Longitude endLong = new Longitude(Integer.parseInt(this.curDetail.getLongitudeDegree()), Double.parseDouble(this.curDetail.getLongitudeMinute()), this.curDetail.getLongitudeDirection().toCharArray()[0]);
        GeographicCoordinate endPoint = new GeographicCoordinate(endLat, endLong);
        TELogFactory.getNormalLogger().debug("Before calculate the right point: start point is " + startLat.toString() + startLong.toString() + "; end point is " + endLat.toString() + endLong.toString());
        if (this.dis_to_detailStart == 0.0) {
            this.resultPoint = startPoint;
            TELogFactory.getNormalLogger().debug("The point is the start point! The point is " + startPoint.getLatitude().toString() + startPoint.getLongitude().toString());
        } else {
            this.resultPoint = PositionCalculator.calcPointPosition(startPoint, endPoint, this.dis_to_detailStart);
            TELogFactory.getNormalLogger().debug("The point is " + this.resultPoint.getLatitude().toString() + this.resultPoint.getLongitude().toString());
        }
        if (null == this.resultPoint) {
            return 2;
        }
        return 0;
    }

    public TEMarineQuickFaultInfoPO convertToQFInfoPO() {
        this.qfInfoPO = new TEMarineQuickFaultInfoPO();
        this.qfInfoPO.ClearanceStatue = 0;
        this.qfInfoPO.ClearanceTime = "";
        this.qfInfoPO.ClearanceUser = "";
        this.qfInfoPO.Depth = 0;
        this.qfInfoPO.Distance = (int)this.distance;
        this.faultTime = System.currentTimeMillis();
        this.qfInfoPO.FaultArea = this.getFaultAreaString();
        this.qfInfoPO.FaultTime = String.valueOf(this.faultTime);
        this.qfInfoPO.Latitude = null == this.resultPoint ? "" : this.resultPoint.getLatitude().toString();
        this.qfInfoPO.Longitude = null == this.resultPoint ? "" : this.resultPoint.getLongitude().toString();
        this.qfInfoPO.Theme = this.res.getString("fault_alarm_res");
        this.qfInfoPO.ToAddressee = this.getEmailUserStrings();
        this.qfInfoPO.Content = this.getContent();
        this.qfInfoPO.PursuantNe = this.fromNEID;
        return this.qfInfoPO;
    }

    private String getEmailUserStrings() {
        ArrayList<TEMarineQuickFaultUserPO> userList = new ArrayList<TEMarineQuickFaultUserPO>();
        int redCode = TEQuickFaultDaoService.getInstance().findQuickFaultEmailUsers(userList);
        StringBuilder userNames = new StringBuilder();
        if (0 == redCode) {
            for (TEMarineQuickFaultUserPO user : userList) {
                if (!"".equals(userNames.toString())) {
                    userNames.append(",");
                }
                userNames.append(user.getUserName());
            }
            if ("".equals(userNames.toString())) {
                TELogFactory.getNormalLogger().error("There is no Quick Fault Email User!");
            }
        } else {
            TELogFactory.getNormalLogger().error("Finding Quick Fault Email Users fail! The error code is " + redCode);
        }
        return userNames.toString();
    }

    private String getFaultAreaString() {
        if (null == this.resultPoint) {
            return MessageFormat.format(this.res.getString("faultpoint_in_station"), this.startPointName);
        }
        StringBuilder faultAreaStr = new StringBuilder();
        faultAreaStr.append(this.res.getString("distance")).append(this.startPointName).append(" ");
        DecimalFormat distanceformat = new DecimalFormat("0.###");
        String distanceStr = distanceformat.format(this.distance);
        faultAreaStr.append(distanceStr).append(this.res.getString(KILOMETRE_STR)).append(",").append(this.res.getString("lat_and_long")).append(this.resultPoint.getLatitude().toString()).append(",").append(this.resultPoint.getLongitude().toString());
        return faultAreaStr.toString();
    }

    private String getContent() {
        StringBuilder contentStr = new StringBuilder();
        String formatTime = TEMarineE2EUtil.formatTimeInServer(this.faultTime);
        contentStr.append(this.res.getString("send_mail_date")).append(formatTime).append("\n\r");
        contentStr.append(this.res.getString("fault_mailtheme")).append(this.res.getString("fault_alarm_res")).append("\n\r");
        contentStr.append(this.getMailContent());
        return contentStr.toString();
    }

    public String getMailContent() {
        StringBuilder contentStr = new StringBuilder();
        contentStr.append(this.res.getString("fault_locate_info")).append("\n\r");
        String formatTime = TEMarineE2EUtil.formatTimeInServer(this.faultTime);
        contentStr.append(this.res.getString("fault_time")).append(formatTime).append("\n\r");
        contentStr.append(this.res.getString("fault_address")).append(this.getFaultAreaString()).append("\n\r");
        contentStr.append(this.res.getString("fault_dispose"));
        return contentStr.toString();
    }

    private boolean isRightConditions() {
        return null != this.curDetail;
    }

    private int checkFaultPointInStn() {
        if (null == this.startPointName || "".equals(this.startPointName)) {
            TELogFactory.getNormalLogger().error("There must be something wrong with the fault point!!");
            return 1090605056;
        }
        TELogFactory.getNormalLogger().debug("The fault point is in starttion " + this.startPointName);
        return 0;
    }
}

