/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.locator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineRoute;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineRouteGetter;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineStationGetter;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEPFEStatusObj;
import com.huawei.nglct.nemgr.marine.quicklocating.QuickLocatingMainMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocater;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.QFLocatorInf;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;

class FaultLocatorByPFE
extends FaultLocater
implements QFLocatorInf {
    public FaultLocatorByPFE(QuickLocatingMainMgr mainMgr) {
        super(mainMgr);
    }

    @Override
    public int getFaultLocateResult() {
        TEPFEStatusObj selectedPFEObj = this.locationObj.getSelectedPFE();
        int retCode = 0;
        if (null == selectedPFEObj) {
            retCode = 2;
            TELogFactory.getNormalLogger().error("The selectedPFEObj is empty!");
        } else {
            retCode = this.calcFaultDistanceByPFE();
            if (0 == retCode) {
                retCode = this.calcLongAndLatLocation();
            }
        }
        this.setLocateFaultEnd(true);
        return retCode;
    }

    private int calcFaultDistanceByPFE() {
        int retCode = 0;
        this.getStationByPFE();
        if (null == this.locationObj.getStationPO()) {
            TELogFactory.getNormalLogger().error("Can not find the station whitch contain " + this.locationObj.getSelectedPFE().getNeName());
            retCode = 1090615234;
        } else {
            retCode = this.findCableSet();
            if (0 == retCode) {
                retCode = this.calcLengthByPFE();
            }
        }
        return retCode;
    }

    private void getStationByPFE() {
        TEMarineStationGetter stationGetter = new TEMarineStationGetter();
        TEMarineStationPO station = stationGetter.getStationByNeName(this.locationObj.getSelectedPFE().getNeName());
        this.locationObj.setStationPO(station);
    }

    private int findCableSet() {
        int retCode = 0;
        TEMarineRouteGetter routeGetter = new TEMarineRouteGetter();
        TEMarineRoute route = routeGetter.getMarineRouteByStation(this.locationObj.getStationPO(), this.locationObj.getSelectedPFE().getNeName());
        if (null == route || !route.isFull()) {
            TELogFactory.getNormalLogger().error("Can not find the intack route!");
            retCode = 1090615236;
        } else {
            this.locationObj.setRoute(route);
        }
        return retCode;
    }

    private int calcLengthByPFE() {
        int retCode = this.locationObj.calcFaultPoint();
        if (retCode == 0) {
            TELogFactory.getNormalLogger().debug("The distance between the start point and the fault is " + this.locationObj.getFaultPoint().getDistance());
        } else {
            TELogFactory.getNormalLogger().error("Can not calculate the location of the fault! The error code is " + retCode);
        }
        return retCode;
    }
}

