/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.locator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2e.stnelecable.TEMarineStnEleCblDBOper;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineCableEngInfo;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineEngInfoDaoService;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObj;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultPointLocation;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoDetailPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStnEleCablePO;
import java.math.BigDecimal;
import java.util.List;

public class FaultLocationObjByPFE
extends FaultLocationObj {
    private BigDecimal diff_vol;

    private int getProjectInfo() {
        int retCode = 0;
        if (null != this.route) {
            retCode = TEMarineEngInfoDaoService.getInstance().getEngineerInfoByRoute(this.route);
        }
        return retCode;
    }

    @Override
    public int calcFaultPoint() {
        int resultCode = this.checkBasicInfo();
        if (0 != resultCode || this.isFPInStartStn()) {
            return resultCode;
        }
        int n = resultCode = 0 == resultCode ? this.getProjectInfo() : resultCode;
        if (0 == resultCode) {
            this.calcFaultPointOnRout();
            if (this.diff_vol.doubleValue() > 0.0) {
                this.diff_vol = this.diff_vol.subtract(BigDecimal.valueOf(this.getECableVolInEndStn()));
                if (this.diff_vol.doubleValue() <= 0.0) {
                    String endNodeName = this.getEndStationName();
                    this.setFaultPointInStation(endNodeName);
                    return resultCode;
                }
                resultCode = 1090615237;
                TELogFactory.getNormalLogger().debug("The voltage is over hight! Can not work out the fault point!");
            }
        }
        return resultCode;
    }

    private int checkBasicInfo() {
        return null == this.selectedPFE || 0 != this.selectedPFE.getQueryResult() || null == this.route ? 1090615236 : 0;
    }

    private boolean isFPInStartStn() {
        this.diff_vol = this.getStartVol();
        this.diff_vol = this.diff_vol.subtract(BigDecimal.valueOf(this.getECableVolInStartStn()));
        if (this.diff_vol.doubleValue() <= 0.0) {
            String startNodeName = this.getStationPO().Name;
            this.setFaultPointInStation(startNodeName);
            return true;
        }
        return false;
    }

    private void calcFaultPointOnRout() {
        int current = this.selectedPFE.getCurrent();
        BigDecimal distance = BigDecimal.valueOf(0L);
        List<TEMarineCableEngInfo> cableEngInfoLst = this.route.getCableEngInfoLst();
        int listLen = cableEngInfoLst.size();
        for (int cable_index = 0; cable_index < listLen; ++cable_index) {
            TEMarineCableEngInfo cableEngInfo = cableEngInfoLst.get(cable_index);
            TEMarineCablePO cable = cableEngInfo.getCable();
            int impedance = cable.CableResistance;
            boolean isDetailForward = cableEngInfo.isLstForward();
            List<TEMarineEngineerInfoDetailPO> detailLst = cableEngInfo.getDetailList();
            TEMarineEngineerInfoDetailPO preDetailInfo = null;
            TEMarineEngineerInfoDetailPO curDetailInfo = null;
            boolean calSucc = false;
            BigDecimal disToDetailStart = BigDecimal.valueOf(0L);
            int len = detailLst.size();
            for (int i = 0; i < len; ++i) {
                TEMarineEngineerInfoDetailPO detail = detailLst.get(i);
                this.diff_vol = this.diff_vol.subtract(BigDecimal.valueOf(isDetailForward || 0 == i ? 0L : (long)this.getDetailPointVoltage(cableEngInfo, detail)));
                if (this.diff_vol.doubleValue() <= 0.0) {
                    curDetailInfo = detail;
                    disToDetailStart = BigDecimal.valueOf(0L);
                    calSucc = true;
                    break;
                }
                BigDecimal spanLength = isDetailForward ? (null == preDetailInfo ? BigDecimal.valueOf(0L) : BigDecimal.valueOf(Double.parseDouble(detail.getCmlDst())).subtract(BigDecimal.valueOf(Double.parseDouble(preDetailInfo.getCmlDst())))) : (null == preDetailInfo ? BigDecimal.valueOf(0L) : BigDecimal.valueOf(Double.parseDouble(preDetailInfo.getCmlDst())).subtract(BigDecimal.valueOf(Double.parseDouble(detail.getCmlDst()))).abs());
                this.diff_vol = this.diff_vol.subtract(spanLength.multiply(BigDecimal.valueOf(current * impedance)).divide(BigDecimal.valueOf(10000L)));
                if (this.diff_vol.doubleValue() == 0.0) {
                    curDetailInfo = detail;
                    disToDetailStart = spanLength;
                    distance = distance.add(spanLength);
                    calSucc = true;
                    break;
                }
                if (this.diff_vol.doubleValue() < 0.0) {
                    curDetailInfo = detail;
                    disToDetailStart = spanLength.subtract(this.diff_vol.abs().divide(BigDecimal.valueOf(cable.getCableResistance()), 6).divide(BigDecimal.valueOf(current), 6).multiply(BigDecimal.valueOf(10000L)));
                    distance = distance.add(disToDetailStart);
                    calSucc = true;
                    break;
                }
                distance = distance.add(spanLength);
                this.diff_vol = this.diff_vol.subtract(BigDecimal.valueOf(isDetailForward && i != 0 ? (long)this.getDetailPointVoltage(cableEngInfo, detail) : 0L));
                if (this.diff_vol.doubleValue() <= 0.0) {
                    curDetailInfo = detail;
                    disToDetailStart = spanLength;
                    calSucc = true;
                    preDetailInfo = null;
                    break;
                }
                preDetailInfo = detail;
            }
            if (!calSucc) continue;
            this.faultPoint = new FaultPointLocation();
            this.faultPoint.setDeepness(Integer.parseInt(curDetailInfo.getDepth()));
            this.faultPoint.setDistance(distance.doubleValue());
            this.faultPoint.setPreDetail(preDetailInfo);
            this.faultPoint.setCurDetail(curDetailInfo);
            this.faultPoint.setDetailForward(isDetailForward);
            this.faultPoint.setDis_to_detailStart(disToDetailStart.doubleValue());
            this.faultPoint.setStartPointName(this.stationPO.Name);
            this.faultPoint.setFromNEID(this.selectedPFE.getNeid());
            break;
        }
    }

    private BigDecimal getStartVol() {
        return null == this.selectedPFE ? BigDecimal.valueOf(0L) : BigDecimal.valueOf(Math.abs(this.selectedPFE.getVoltage()));
    }

    private double getECableVolInStartStn() {
        TEMarineStnEleCblDBOper eCableDBOper = TEMarineStnEleCblDBOper.getInstance();
        TEMarineStnEleCablePO eCable = eCableDBOper.getStnECableByNodeName(this.selectedPFE.getNeName());
        return this.calcECableVol(eCable);
    }

    private double calcECableVol(TEMarineStnEleCablePO eCable) {
        double vol = 0.0;
        if (null != eCable) {
            vol = Double.parseDouble(eCable.getResistance()) * Double.parseDouble(eCable.getLength()) * (double)this.selectedPFE.getCurrent() / 1000.0;
        }
        return vol;
    }

    private void setFaultPointInStation(String pointName) {
        this.faultPoint = new FaultPointLocation();
        this.faultPoint.setDeepness(0);
        this.faultPoint.setDistance(this.distance);
        this.faultPoint.setPreDetail(null);
        this.faultPoint.setCurDetail(null);
        this.faultPoint.setDetailForward(true);
        this.faultPoint.setDis_to_detailStart(0.0);
        this.faultPoint.setStartPointName(pointName);
        this.faultPoint.setFromNEID(this.selectedPFE.getNeid());
    }

    private int getDetailPointVoltage(TEMarineCableEngInfo cableEngInfo, TEMarineEngineerInfoDetailPO detail) {
        int evtType = detail.getEvtType();
        String detailPointName = detail.getEvent();
        int voltage_drop = 0;
        switch (evtType) {
            case 1: {
                voltage_drop = 0;
                break;
            }
            case 2: {
                voltage_drop = this.route.getBUVoltage(detailPointName);
                break;
            }
            case 3: {
                voltage_drop = cableEngInfo.getRPTVoltage(detailPointName);
                break;
            }
            default: {
                voltage_drop = 0;
            }
        }
        return voltage_drop;
    }

    @Override
    public int getFaultAlarmNeID() {
        if (null != this.selectedPFE) {
            return this.selectedPFE.getNeid();
        }
        return -1;
    }

    private double getECableVolInEndStn() {
        String endCTBName = this.getEndCTBName();
        TEMarineStnEleCblDBOper eCableDBOper = TEMarineStnEleCblDBOper.getInstance();
        TEMarineStnEleCablePO eCable = eCableDBOper.getStnECableByNodeName(endCTBName);
        return this.calcECableVol(eCable);
    }

    private String getEndCTBName() {
        String ctbName = "";
        if (!this.route.getCableList().isEmpty()) {
            int cableCount = this.route.getCableList().size();
            TEMarineCablePO cable = this.route.getCableList().get(cableCount - 1);
            if (cable.SrcType == 0 && cable.SrcStationID != this.stationPO.StationID) {
                ctbName = cable.SrcNodeName;
            } else if (cable.SinkType == 0 && cable.SinkStationID != this.stationPO.StationID) {
                ctbName = cable.SinkNodeName;
            }
        }
        return ctbName;
    }

    private String getEndStationName() {
        String endStationName = "";
        if (!this.route.getCableList().isEmpty()) {
            int cableCount = this.route.getCableList().size();
            TEMarineCablePO cable = this.route.getCableList().get(cableCount);
            if (cable.SrcType == 0 && cable.SrcStationID != this.stationPO.StationID) {
                endStationName = cable.SrcStationName;
            } else if (cable.SinkType == 0 && cable.SinkStationID != this.stationPO.StationID) {
                endStationName = cable.SinkStationName;
            }
        }
        return endStationName;
    }
}

