/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.locator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineCableEngInfo;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineEngInfoDaoService;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineRouteGetter;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineStationGetter;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObj;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultPointLocation;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineDevicePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TELineSpanPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEndCablePO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineEngineerInfoDetailPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import java.util.List;

public class FaultLocationObjByOTDR
extends FaultLocationObj {
    @Override
    public int calcFaultPoint() {
        TEMarineCableEngInfo cableEngInfo;
        if (null == this.testLinePO || null == this.getStationPO()) {
            TELogFactory.getNormalLogger().error("testLinePO or stationPO is null! calcFaultPoint is fail!");
            return 1090605056;
        }
        String startNodeName = this.getStationPO().Name;
        String endNodeName = this.getEndPointName();
        double dis_to_start = this.distance;
        double startStationEndCableLen = this.getStationEndCableLen(this.getStationPO().getStationID(), (int)this.testLinePO.getNeID(), (int)this.testLinePO.getLMISlot());
        if (dis_to_start - startStationEndCableLen <= 0.0) {
            this.distance = 0.0;
            this.setFaultPointInStation(startNodeName);
            TELogFactory.getNormalLogger().error("The fault point is in start station " + startNodeName);
            return 0;
        }
        this.distance -= startStationEndCableLen;
        dis_to_start = this.distance;
        if (this.testLinePO.getEqptNum() > 0) {
            List spanList = this.testLinePO.getSpanListInOrder();
            List deviceList = this.testLinePO.getDeviceListInOrder();
            int tmpLen = 0;
            TELineDevicePO preDevice = null;
            int preDevicePos = 0;
            int i = 0;
            for (TELineDevicePO device : deviceList) {
                if (device.DeviceType == 3) continue;
                int index = device.SpanID - 1;
                while (i < index) {
                    TELineSpanPO span = (TELineSpanPO)spanList.get(i);
                    tmpLen += span.FiberLenth;
                    ++i;
                }
                if ((double)(tmpLen + device.Distance) >= this.distance * 10.0) {
                    endNodeName = device.Remark;
                    dis_to_start = (this.distance * 10.0 - (double)preDevicePos) / 10.0;
                    break;
                }
                preDevice = device;
                startNodeName = preDevice.Remark;
                preDevicePos = tmpLen + device.Distance;
            }
        }
        if (null == (cableEngInfo = TEMarineEngInfoDaoService.getInstance().getCableEngInfoByNodeName(startNodeName, endNodeName)) || null == cableEngInfo.getDetailList() || cableEngInfo.getDetailList().isEmpty()) {
            TELogFactory.getNormalLogger().error("cableEngInfo is null or detailList is null or empty!");
            return 1090615237;
        }
        return this.getFaultPoint(cableEngInfo, dis_to_start);
    }

    private String getEndPointName() {
        String endNodeName = this.getEndStationName();
        if (endNodeName.isEmpty()) {
            if (0 == this.testLinePO.getEqptNum()) {
                endNodeName = this.getNearNodeName((int)this.testLinePO.NeID, (int)this.testLinePO.LMISlot);
            } else {
                List devList = this.testLinePO.getDeviceListInOrder();
                endNodeName = ((TELineDevicePO)devList.get((int)(devList.size() - 1))).Remark;
            }
        }
        return endNodeName;
    }

    private String getEndStationName() {
        TEMarineStationPO station;
        TEMarineStationGetter stGetter = new TEMarineStationGetter();
        int oppositeNeID = (int)this.testLinePO.getOppositeNEID();
        String endStationName = "";
        if (0 != oppositeNeID && -1 != oppositeNeID && null != (station = stGetter.getStationByNeID((int)this.testLinePO.OppositeNEID))) {
            endStationName = station.getName();
        }
        return endStationName;
    }

    private String getNearNodeName(int neid, int slotid) {
        TEMarineStationGetter stGetter = new TEMarineStationGetter();
        TEMarineStationPO station = stGetter.getStationByNeID(neid);
        String nodeName = "";
        if (null != station) {
            TEMarineRouteGetter rtGetter = new TEMarineRouteGetter();
            TEMarineCablePO cable = rtGetter.getCableByNeInfo(station, neid, slotid);
            if (null == cable) {
                TELogFactory.getNormalLogger().debug("the station has no cable!");
                return nodeName;
            }
            nodeName = cable.SrcStationName.equals(station.Name) ? (cable.SinkType == 0 ? cable.SinkStationName : cable.SinkNodeName) : (cable.SrcType == 0 ? cable.SrcStationName : cable.SrcNodeName);
        }
        return nodeName;
    }

    private int getFaultPoint(TEMarineCableEngInfo cableEngInfo, double dis_to_start) {
        boolean isDetailForward = cableEngInfo.isLstForward();
        List<TEMarineEngineerInfoDetailPO> detailLst = cableEngInfo.getDetailList();
        TEMarineEngineerInfoDetailPO preDetailInfo = null;
        TEMarineEngineerInfoDetailPO curDetailInfo = null;
        boolean calSucc = false;
        double disToDetailStart = 0.0;
        double tmpDistance = 0.0;
        for (TEMarineEngineerInfoDetailPO detail : detailLst) {
            double spanLength;
            if (isDetailForward) {
                spanLength = null == preDetailInfo ? 0.0 : Double.parseDouble(detail.getCmlDst()) - Double.parseDouble(preDetailInfo.getCmlDst());
            } else {
                double d = spanLength = null == preDetailInfo ? 0.0 : Math.abs(Double.parseDouble(preDetailInfo.getCmlDst()) - Double.parseDouble(detail.getCmlDst()));
            }
            if (tmpDistance + spanLength >= dis_to_start) {
                disToDetailStart = dis_to_start - tmpDistance;
                curDetailInfo = detail;
                calSucc = true;
                break;
            }
            tmpDistance += spanLength;
            preDetailInfo = detail;
        }
        if (calSucc) {
            this.faultPoint = new FaultPointLocation();
            this.faultPoint.setDeepness(Integer.parseInt(curDetailInfo.getDepth()));
            this.faultPoint.setDistance(this.distance);
            this.faultPoint.setPreDetail(preDetailInfo);
            this.faultPoint.setCurDetail(curDetailInfo);
            this.faultPoint.setDetailForward(isDetailForward);
            this.faultPoint.setDis_to_detailStart(disToDetailStart);
            this.faultPoint.setStartPointName(this.stationPO.Name);
            this.faultPoint.setFromNEID((int)this.testLinePO.NeID);
            return 0;
        }
        TEMarineCablePO cable = cableEngInfo.getCable();
        String preDetailAddInfo = preDetailInfo.getAdditionalFeatures().toLowerCase();
        if (null != cable && (preDetailAddInfo.contains(cable.getSrcStationName().toLowerCase()) || preDetailAddInfo.contains(cable.getSinkStationName().toLowerCase()))) {
            int endStnID = preDetailAddInfo.contains(cable.getSrcStationName().toLowerCase()) ? cable.getSrcStationID() : cable.getSinkStationID();
            String endStnName = preDetailAddInfo.contains(cable.getSrcStationName().toLowerCase()) ? cable.getSrcStationName() : cable.getSinkStationName();
            return this.checkFaultPointInEndStn(endStnID, endStnName, tmpDistance);
        }
        return 1090615238;
    }

    @Override
    public int getFaultAlarmNeID() {
        if (null != this.testLinePO) {
            return (int)this.testLinePO.NeID;
        }
        return -1;
    }

    private double getStationEndCableLen(int stationID, int neid, int slotid) {
        TEMarineStationGetter stGetter = new TEMarineStationGetter();
        TEMarineEndCablePO endCable = stGetter.getEndCable(stationID, neid, slotid);
        double endCableLen = 0.0;
        if (null != endCable) {
            endCableLen = Double.parseDouble(endCable.getLength());
        }
        return endCableLen;
    }

    private void setFaultPointInStation(String startPointName) {
        this.faultPoint = new FaultPointLocation();
        this.faultPoint.setDeepness(0);
        this.faultPoint.setDistance(this.distance);
        this.faultPoint.setPreDetail(null);
        this.faultPoint.setCurDetail(null);
        this.faultPoint.setDetailForward(true);
        this.faultPoint.setDis_to_detailStart(0.0);
        this.faultPoint.setStartPointName(startPointName);
        this.faultPoint.setFromNEID((int)this.testLinePO.NeID);
    }

    private int checkFaultPointInEndStn(int endStnID, String endStnName, double tmpDistance) {
        if (endStnID == this.getStationPO().getStationID() || 0L == this.testLinePO.OppositeNEID || -1L == this.testLinePO.OppositeNEID) {
            return 1090615238;
        }
        double endCableLen = this.getStationEndCableLen(endStnID, (int)this.testLinePO.OppositeNEID, (int)this.testLinePO.OppositeLMISlot);
        if (tmpDistance - endCableLen <= 0.0) {
            this.setFaultPointInStation(endStnName);
            return 0;
        }
        return 1090615238;
    }
}

