/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.locator;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEQuickFaultDaoService;
import com.huawei.nglct.nemgr.marine.quicklocating.QuickLocatingMainMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObj;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.QFLocatorInf;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineQuickFaultInfoPO;

abstract class FaultLocater
implements QFLocatorInf {
    private static final int WAITING_ONCE_TIME = 10000;
    protected FaultLocationObj locationObj = null;
    protected QuickLocatingMainMgr mainMgr = null;
    protected boolean locateFaultEnd = false;

    public FaultLocater(QuickLocatingMainMgr mainMgr) {
        this.locationObj = mainMgr.getLocationObj();
        this.mainMgr = mainMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int faultLocate() {
        int retCode = this.getFaultLocateResult();
        int timeCounter = 0;
        FaultLocater faultLocater = this;
        synchronized (faultLocater) {
            while (!this.isLocateFaultEnd() && timeCounter < 1200000) {
                try {
                    timeCounter += 10000;
                    this.wait(10000L);
                }
                catch (InterruptedException e) {
                    TELogFactory.getNormalLogger().error("locatingPoint failed: ", (Throwable)e);
                }
            }
        }
        if (!this.isLocateFaultEnd() && timeCounter >= 1200000) {
            this.setLocateFaultEnd(true);
            TELogFactory.getNormalLogger().error("locatingFaultPoint time out!");
            retCode = 1090650120;
        }
        if (0 == retCode) {
            TEMarineQuickFaultInfoPO qfInfoPO = this.locationObj.getFaultPoint().convertToQFInfoPO();
            retCode = TEQuickFaultDaoService.getInstance().saveQuickFaultInfo(qfInfoPO);
        }
        if (0 == retCode) {
            TEMarineE2EUtil.sendQFLampStatusToClient(1);
        }
        return retCode;
    }

    public abstract int getFaultLocateResult();

    protected int calcLongAndLatLocation() {
        int retCode = 2;
        if (null != this.locationObj) {
            retCode = this.locationObj.getFaultPoint().calcPointPosition();
        }
        return retCode;
    }

    public boolean isLocateFaultEnd() {
        return this.locateFaultEnd;
    }

    public void setLocateFaultEnd(boolean locateFaultEnd) {
        this.locateFaultEnd = locateFaultEnd;
    }

    @Override
    public void locationEnding() {
        this.locateFaultEnd = true;
    }
}

