/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.judge;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEPFEStatusObj;
import com.huawei.nglct.nemgr.marine.quicklocating.judge.FaultJudgeByPFE;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class TEPFEVoltageGetter {
    private static final String TIMER_NAME = "TEPFEVoltageGetterTimer";
    public static final int TIMER_PERIOD = 120000;
    private static final int QUERY_COUNT = 3;
    private Set<Integer> pfeIDList = null;
    private Timer queryTimer = new Timer("TEPFEVoltageGetterTimer");
    private Map<Integer, TEPFEStatusObj[]> pfeVoltageMap = new HashMap<Integer, TEPFEStatusObj[]>();
    private FaultJudgeByPFE faultJudge = null;
    private boolean isEnding = false;

    public TEPFEVoltageGetter(Set<Integer> pfeIDList) {
        this.pfeIDList = pfeIDList;
        for (Integer pfeNeID : pfeIDList) {
            this.pfeVoltageMap.put(pfeNeID, new TEPFEStatusObj[3]);
        }
    }

    public String getStartingPFE() {
        return "";
    }

    public void getPFEsVoltage(FaultJudgeByPFE faultJudge) {
        this.faultJudge = faultJudge;
        this.startVolQueryTimer();
    }

    public Set<Integer> getPfeIDList() {
        return this.pfeIDList;
    }

    private void startVolQueryTimer() {
        VoltageQueryTmTask queryTimeTask = new VoltageQueryTmTask();
        this.queryTimer.scheduleAtFixedRate((TimerTask)queryTimeTask, 0L, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endTimer() {
        Timer timer = this.queryTimer;
        synchronized (timer) {
            this.queryTimer.cancel();
        }
    }

    private TEPFEStatusObj queryVoltage(Integer pfeID) {
        TEPFEStatusObj pfeStatusObj = new TEPFEStatusObj(pfeID);
        pfeStatusObj.queryVoltage(true, this.faultJudge.getWriteLogInfo());
        return pfeStatusObj;
    }

    public void setEnding(boolean isEnding) {
        this.isEnding = isEnding;
    }

    public Map<Integer, TEPFEStatusObj[]> getPfeVoltageMap() {
        return this.pfeVoltageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyJudge() {
        try {
            FaultJudgeByPFE faultJudgeByPFE = this.faultJudge;
            synchronized (faultJudgeByPFE) {
                try {
                    this.faultJudge.setQueryPFEStatusEnd(true);
                    this.faultJudge.notifyAll();
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("TEPFEVoltageGetter ---- quick locating is end by thread exception!");
                    TELogFactory.getNormalLogger().error("Query PFE Voltage failed", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("error:", (Throwable)e);
        }
    }

    private class VoltageQueryTmTask
    extends TimerTask {
        private int count = 0;

        private VoltageQueryTmTask() {
        }

        @Override
        public void run() {
            for (Integer pfeNeId : TEPFEVoltageGetter.this.pfeVoltageMap.keySet()) {
                TEPFEStatusObj pfeStatusObj = TEPFEVoltageGetter.this.queryVoltage(pfeNeId);
                TEPFEStatusObj[] voltageArr = (TEPFEStatusObj[])TEPFEVoltageGetter.this.pfeVoltageMap.get(pfeNeId);
                voltageArr[this.count] = pfeStatusObj;
            }
            ++this.count;
            if (this.count >= 3 || TEPFEVoltageGetter.this.isEnding) {
                TEPFEVoltageGetter.this.endTimer();
                TEPFEVoltageGetter.this.isEnding = true;
                TEPFEVoltageGetter.this.notifyJudge();
            }
        }
    }
}

