/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.judge;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEPFEStatusObj;
import com.huawei.nglct.nemgr.marine.quicklocating.QuickLocatingMainMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.judge.FaultJudge;
import com.huawei.nglct.nemgr.marine.quicklocating.judge.TEPFEVoltageGetter;
import java.util.Map;
import java.util.Set;

class FaultJudgeByPFE
extends FaultJudge {
    private static final float CHANGE_BOUND = 0.1f;
    private TEPFEStatusObj selectedPfeObj = null;
    private int changeVolValue = 0;
    private TEPFEVoltageGetter pfeVolGetter = null;
    private boolean isQueryPFEStatusEnd = false;

    public FaultJudgeByPFE(QuickLocatingMainMgr mainMgr) {
        super(mainMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int confirmFault() {
        if (this.mainMgr.isEnd()) {
            return 0;
        }
        int retCode = 0;
        this.queryPFEStatus();
        int timeCounter = 0;
        FaultJudgeByPFE faultJudgeByPFE = this;
        synchronized (faultJudgeByPFE) {
            while (!this.isQueryPFEStatusEnd() && timeCounter < 1200000) {
                try {
                    timeCounter += 10000;
                    this.wait(10000L);
                }
                catch (InterruptedException e) {
                    TELogFactory.getNormalLogger().error("waiting time out!", (Throwable)e);
                }
            }
        }
        if (!this.isQueryPFEStatusEnd() && timeCounter >= 1200000) {
            this.setQueryPFEStatusEnd(true);
            TELogFactory.getNormalLogger().error("getFaultPointByPFE time out!");
            retCode = 1090650120;
        } else {
            if (this.mainMgr.isEnd()) {
                return 0;
            }
            retCode = this.confirmFault(this.pfeVolGetter.getPfeVoltageMap());
        }
        return retCode;
    }

    public void queryPFEStatus() {
        this.pfeVolGetter = new TEPFEVoltageGetter(this.alarmNeLists.getvAlarmPFELst());
        this.pfeVolGetter.getPFEsVoltage(this);
    }

    public boolean isQueryPFEStatusEnd() {
        return this.isQueryPFEStatusEnd;
    }

    public void setQueryPFEStatusEnd(boolean isQueryPFEStatusEnd) {
        this.isQueryPFEStatusEnd = isQueryPFEStatusEnd;
    }

    public int confirmFault(Map<Integer, TEPFEStatusObj[]> pfeStatusObjMap) {
        boolean allQueryFail = true;
        if (null == pfeStatusObjMap || pfeStatusObjMap.isEmpty()) {
            allQueryFail = true;
            TELogFactory.getNormalLogger().error("confirmFault error: pfeStatusObjMap is null or empty!");
        } else {
            Set<Map.Entry<Integer, TEPFEStatusObj[]>> mapEntrySet = pfeStatusObjMap.entrySet();
            this.selectedPfeObj = null;
            boolean FIRST_INDEX = false;
            for (Map.Entry<Integer, TEPFEStatusObj[]> mapEntry : mapEntrySet) {
                TEPFEStatusObj pfeHisObj;
                int aPfeID = mapEntry.getKey();
                TEPFEStatusObj[] pfeStatusArr = mapEntry.getValue();
                boolean isFull = this.isFullPFEStatus(pfeStatusArr);
                TEPFEStatusObj tEPFEStatusObj = pfeHisObj = isFull ? this.getPFEHistoryPM(pfeStatusArr[0].getNeid()) : null;
                if (isFull && null != pfeHisObj && 0 == pfeHisObj.getQueryResult()) {
                    allQueryFail = false;
                    this.getGreatChangePFE(pfeStatusArr[0], pfeHisObj);
                    continue;
                }
                TELogFactory.getNormalLogger().debug(aPfeID + "has not full infomation.");
            }
        }
        int errCode = 0;
        if (allQueryFail || null == this.selectedPfeObj) {
            errCode = 1090615232;
        } else {
            this.mainMgr.getLocationObj().setSelectedPFE(this.selectedPfeObj);
            TELogFactory.getNormalLogger().info("The selected PFE is " + this.selectedPfeObj.getNeName());
        }
        return errCode;
    }

    private boolean isFullPFEStatus(TEPFEStatusObj[] pfeStatusArr) {
        boolean isFull = true;
        if (null == pfeStatusArr || 3 != pfeStatusArr.length) {
            TELogFactory.getNormalLogger().debug("pfeStatusArr is null!");
            isFull = false;
        } else {
            TEPFEStatusObj prePfeObj = pfeStatusArr[0];
            if (null == prePfeObj || 0 != prePfeObj.getQueryResult()) {
                TELogFactory.getNormalLogger().debug("prePfeObj is null or the query result is fail!");
                isFull = false;
            } else {
                int len = pfeStatusArr.length;
                for (int i = 1; i < len; ++i) {
                    TEPFEStatusObj pfeObj = pfeStatusArr[i];
                    if (!this.isRightPFEStatus(pfeObj, prePfeObj)) {
                        isFull = false;
                        break;
                    }
                    prePfeObj = pfeObj;
                }
            }
        }
        TELogFactory.getNormalLogger().debug("this result of isFullPFEStatus is " + isFull);
        return isFull;
    }

    private void getGreatChangePFE(TEPFEStatusObj pfeObj, TEPFEStatusObj pfeHistoryObj) {
        if (null == pfeHistoryObj || 0 != pfeHistoryObj.getQueryResult()) {
            TELogFactory.getNormalLogger().error("Getting PFE history PM fail!");
        } else {
            int hisVoltage = pfeHistoryObj.getVoltage();
            int curVoltage = pfeObj.getVoltage();
            int aDiff = Math.abs(hisVoltage - curVoltage);
            if (null == this.selectedPfeObj || aDiff > this.changeVolValue) {
                this.selectedPfeObj = pfeObj;
                this.changeVolValue = aDiff;
            }
        }
    }

    private boolean isRightPFEStatus(TEPFEStatusObj pfeObj, TEPFEStatusObj prePfeObj) {
        boolean isRight;
        boolean bl = isRight = null != pfeObj && 0 == pfeObj.getQueryResult();
        if (isRight) {
            isRight = prePfeObj.approximate(pfeObj);
        }
        return isRight;
    }

    private TEPFEStatusObj getPFEHistoryPM(int pfeNeId) {
        TEPFEStatusObj pfeHisObj = new TEPFEStatusObj(pfeNeId);
        pfeHisObj.queryHisPM(true, this.getWriteLogInfo());
        return pfeHisObj;
    }

    public TEPFEStatusObj getSelectedPfeObj() {
        return this.selectedPfeObj;
    }

    @Override
    public void locationEnding() {
        if (null != this.pfeVolGetter) {
            this.pfeVolGetter.setEnding(true);
        }
    }
}

