/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating.judge;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineLineDaoService;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineStationGetter;
import com.huawei.nglct.nemgr.marine.quicklocating.QuickLocatingMainMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.judge.FaultJudge;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObj;
import com.huawei.nglct.otdr.TESLMOTDRDataMgr;
import com.huawei.nglct.otdr.appletgraph.common.TEOTDRDomCommUtil;
import com.huawei.nglct.otdr.appletgraph.core.datainterface.Datainterface;
import com.huawei.nglct.otdr.external.TEMarineTestStopEvent;
import com.huawei.nglct.otdr.external.TEMarineTestStopNoticeListener;
import com.huawei.nglct.otdr.external.TEMarineTestStopNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.marine.TEMarineStationPO;
import com.huawei.nglct.po.embeddednemgrmo.marine.TESLMLinePO;
import java.io.CharArrayReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class FaultJudgeByOTDR
extends FaultJudge
implements TEMarineTestStopNoticeListener {
    private boolean isTestEnd = false;
    private TESLMLinePO testLinePO = null;
    private TEMarineStationPO startStn = null;
    private int testResult = -1;
    private String fileName = "";

    public FaultJudgeByOTDR(QuickLocatingMainMgr mainMgr) {
        super(mainMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int confirmFault() {
        if (this.mainMgr.isEnd()) {
            return 0;
        }
        int retCode = this.startOTDRTest();
        int timeCounter = 0;
        FaultJudgeByOTDR faultJudgeByOTDR = this;
        synchronized (faultJudgeByOTDR) {
            while (!this.isTestEnd() && timeCounter < 1200000) {
                try {
                    timeCounter += 10000;
                    this.wait(10000L);
                }
                catch (InterruptedException e) {
                    TELogFactory.getNormalLogger().error("waiting time out!", (Throwable)e);
                }
            }
        }
        if (!this.isTestEnd() && timeCounter >= 1200000) {
            this.isTestEnd = true;
            TELogFactory.getNormalLogger().error("get OTDR test result time out!");
            retCode = 0 == retCode ? 1090650120 : retCode;
            TEMarineTestStopNoticeMgr.getInstance().unregisterListener(this);
        } else {
            if (this.mainMgr.isEnd()) {
                return 0;
            }
            retCode = this.confirmFaultAfterTest();
        }
        return retCode;
    }

    private int startOTDRTest() {
        if (null == this.alarmNeLists || this.alarmNeLists.isAlarmNeSlotMapEmpty()) {
            TELogFactory.getNormalLogger().error("alarmNeLists is null or isAlarmNeSlotMapEmpty!");
            return 0;
        }
        int retCode = 0;
        Set<Integer> neSlotMapKeySet = this.alarmNeLists.getAlarmNeIDSet();
        TEMarineStationGetter stationGetter = new TEMarineStationGetter();
        TEMarineStationPO station = null;
        for (Integer neid : neSlotMapKeySet) {
            if (this.alarmNeLists.getNeSlotInfoSet(neid).isEmpty() || 0 != (retCode = null == (station = stationGetter.getStationByNeID(neid)) ? 1090615264 : this.getAvailLineStartTest(neid))) continue;
            this.startStn = station;
            break;
        }
        if (0 != retCode) {
            retCode = 1090615264;
            this.isTestEnd = true;
            this.testResult = retCode;
        }
        return retCode;
    }

    private int getAvailLineStartTest(int slmNEID) {
        ArrayList<TESLMLinePO> linePOLst = new ArrayList<TESLMLinePO>();
        int retCode = TEMarineLineDaoService.getInstance().getLineInfoLstFromDB(slmNEID, linePOLst);
        int n = retCode = 0 == retCode && linePOLst.isEmpty() ? 1090615264 : retCode;
        if (0 == retCode) {
            retCode = this.sendOTDRTestTillSucc(linePOLst);
        }
        return retCode;
    }

    private int sendStartTestMsg(int slmNEID, int lineID, int direction) {
        int retCode = TEMarineLineDaoService.getInstance().startLineTest(slmNEID, lineID, direction, this.mainMgr.getInfo().getUserID(), this.mainMgr.getInfo().getIpAddress());
        if (0 == retCode) {
            TEMarineTestStopNoticeMgr.getInstance().registerListener(this);
        }
        return retCode;
    }

    private int sendOTDRTestTillSucc(List<TESLMLinePO> linePOLst) {
        int retCode = 2;
        Set<Integer> neIDSet = this.alarmNeLists.getAlarmNeIDSet();
        if (null == neIDSet) {
            TELogFactory.getNormalLogger().error("neIDSet of alarmNeLists is null!");
            return retCode;
        }
        for (TESLMLinePO line : linePOLst) {
            int neid = (int)line.NeID;
            int lmiSlotID = (int)line.LMISlot;
            Set<Integer> lmiSlotIDSet = this.alarmNeLists.getNeSlotInfoSet(neid);
            if (null == lmiSlotIDSet || !lmiSlotIDSet.contains(lmiSlotID) || 0 != (retCode = this.sendStartTestMsg(neid, line.LineID, line.Direction))) continue;
            this.testLinePO = line;
            break;
        }
        return retCode;
    }

    public boolean isTestEnd() {
        return this.isTestEnd;
    }

    @Override
    public void locationEnding() {
        this.isTestEnd = true;
        TEMarineTestStopNoticeMgr.getInstance().unregisterListener(this);
    }

    @Override
    public void processNotece(TEMarineTestStopEvent event) {
        TELogFactory.getNormalLogger().debug("get the test stop event!");
        if (null == event || (long)event.getNeid() != this.testLinePO.NeID || event.getLineid() != this.testLinePO.LineID || event.getTestType() != 7) {
            return;
        }
        TEMarineTestStopNoticeMgr.getInstance().unregisterListener(this);
        this.testResult = event.getRetCode();
        TELogFactory.getNormalLogger().error("the test result code is " + this.testResult);
        if (0 == this.testResult) {
            this.fileName = event.getFileName();
            TELogFactory.getNormalLogger().debug("filename is " + this.fileName);
        }
        this.isTestEnd = true;
    }

    private int confirmFaultAfterTest() {
        TELogFactory.getNormalLogger().debug("start confirmFaultAfterTest()");
        int retCode = this.testResult;
        if (0 == retCode && !this.fileName.equals("")) {
            Object testResultObj = TESLMOTDRDataMgr.loadFileContent((int)this.testLinePO.NeID, this.fileName);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document doc = null;
            if (null == testResultObj) {
                TELogFactory.getNormalLogger().debug("testResultObj is null!");
                retCode = 1090744440;
                return retCode;
            }
            try {
                InputSource source = new InputSource(new CharArrayReader(testResultObj.toString().toCharArray()));
                DocumentBuilder db = dbf.newDocumentBuilder();
                doc = db.parse(source);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Exception ", (Throwable)e);
            }
            if (null == doc) {
                TELogFactory.getNormalLogger().debug("doc is null!");
                retCode = 1090744440;
            } else {
                retCode = this.parseBreakEvent(doc);
                TELogFactory.getNormalLogger().debug("parseBreakEvent retCode is " + retCode);
            }
        }
        return retCode;
    }

    private int parseBreakEvent(Document doc) {
        Datainterface sorData = TEOTDRDomCommUtil.encapsulateData(doc);
        int retCode = Integer.parseInt(sorData.getErrorMessage().getErrorcode());
        TELogFactory.getNormalLogger().debug("encapsulate file data retcode is " + retCode);
        if (0 == retCode) {
            short eventrowsNum = Short.valueOf(sorData.getDataRowParam(0, "eventrows").getValue());
            short curveparamNum = Short.valueOf(sorData.getDataRowParam(0, "curveparam").getValue());
            short curveaxisNum = Short.valueOf(sorData.getDataRowParam(0, "curveaxis").getValue());
            boolean hasBreakEvent = false;
            if (eventrowsNum > 0) {
                int index = curveparamNum + curveaxisNum;
                int i = index + 1;
                index += eventrowsNum;
                while (i <= index) {
                    int eventCode = Integer.parseInt(sorData.getDataRowParam(i, "eventCode").getValue(), 16);
                    if (eventCode == 0x2E9999) {
                        FaultLocationObj locateObj = this.mainMgr.getLocationObj();
                        locateObj.setTestLinePO(this.testLinePO);
                        locateObj.setStationPO(this.startStn);
                        locateObj.setDistance(Double.parseDouble(sorData.getDataRowParam(i, "eventLocationInLine").getValue()));
                        hasBreakEvent = true;
                        break;
                    }
                    ++i;
                }
            }
            if (!hasBreakEvent) {
                retCode = 1090615268;
                TELogFactory.getNormalLogger().debug("There has no break event!!");
            }
        }
        return retCode;
    }
}

