/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.TEMarineE2EUtil;
import com.huawei.nglct.nemgr.marine.e2ecommon.WriteLogInfo;
import com.huawei.nglct.nemgr.marine.quicklocating.FuncEntrance;
import com.huawei.nglct.nemgr.marine.quicklocating.datamodule.AlarmNELists;
import com.huawei.nglct.nemgr.marine.quicklocating.judge.FirstStepJudge;
import com.huawei.nglct.nemgr.marine.quicklocating.judge.QFJudgeInf;
import com.huawei.nglct.nemgr.marine.quicklocating.judge.QFJudgeMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.FaultLocationObj;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.QFLocatorInf;
import com.huawei.nglct.nemgr.marine.quicklocating.locator.QFLocatorMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.reporter.FaultReporter;
import com.huawei.nglct.nemgr.marine.quicklocating.reporter.QFReporterInf;
import com.huawei.nglct.nemgr.marine.quicklocating.util.FaultLocationLogUtil;
import org.slf4j.Logger;

public class QuickLocatingMainMgr {
    private Logger logger = TELogFactory.getNormalLogger();
    private FirstStepJudge firstStepJudge = null;
    private QFJudgeInf judge = null;
    private QFLocatorInf locator = null;
    private QFReporterInf reporter = null;
    private AlarmNELists alarmNeLists = null;
    private WriteLogInfo info = null;
    private FaultLocationObj locationObj = null;
    private boolean isEnd = false;

    public QuickLocatingMainMgr(WriteLogInfo info) {
        this.info = info;
    }

    public void locatingEntrance(AlarmNELists alarmNeLists) {
        if (this.isEnd) {
            return;
        }
        this.alarmNeLists = alarmNeLists;
        int faultType = -1;
        int retCode = 0;
        if (alarmNeLists.isEmpty()) {
            this.logger.error("There has no connection to LMI boards of SLM!");
            retCode = 1090615295;
        } else {
            this.firstStepJudge = new FirstStepJudge(alarmNeLists, this);
            faultType = this.firstStepJudge.firstStepJudge();
            this.judge = QFJudgeMgr.getInstance().getJudge(faultType, this);
            this.locationObj = QFLocatorMgr.getInstance().getLocationObj(faultType);
            this.locator = QFLocatorMgr.getInstance().getLocator(faultType, this);
        }
        if (null == this.judge || null == this.locator) {
            retCode = 0 == retCode ? 2 : retCode;
            this.logger.error("Can not get the judge or locator!");
        } else {
            this.locationObj.setFaultType(faultType);
            if (this.isEnd) {
                return;
            }
            retCode = this.judge.confirmFault();
            if (this.isEnd) {
                return;
            }
            int n = retCode = 0 == retCode ? this.locator.faultLocate() : retCode;
            if (0 == retCode) {
                retCode = this.sendFaultReport();
            }
        }
        if (this.isEnd) {
            return;
        }
        FaultLocationLogUtil.writeOperLogs(this.info, retCode);
        this.sendMessageToC_Mgr(retCode);
        this.stopByException();
    }

    private int sendFaultReport() {
        this.reporter = new FaultReporter(this.locationObj);
        return this.reporter.sendFaultReport();
    }

    public WriteLogInfo getInfo() {
        return this.info;
    }

    public void locationEnding() {
        if (null != this.judge) {
            this.judge.locationEnding();
        }
        if (null != this.locator) {
            this.locator.locationEnding();
        }
        this.isEnd = true;
    }

    private void stopByException() {
        FuncEntrance.oneLocationOver(this);
    }

    public FaultLocationObj getLocationObj() {
        return this.locationObj;
    }

    public AlarmNELists getAlarmNeLists() {
        return this.alarmNeLists;
    }

    private void sendMessageToC_Mgr(int retCode) {
        TEMarineE2EUtil.sendQFResultMsgToC_Mgr(retCode, -1);
    }

    public boolean isEnd() {
        return this.isEnd;
    }
}

