/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNEIDList;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnSingleReturn;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnNeSlotInfo;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnNeSlotInfoLst;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnSentToJavaReq;
import com.huawei.nglct.nemgr.f_interface.marinee2e.AsnSentToJavaRsp;
import com.huawei.nglct.nemgr.marine.e2ecommon.WriteLogInfo;
import com.huawei.nglct.nemgr.marine.quicklocating.FuncEntrance;
import com.huawei.nglct.nemgr.marine.quicklocating.datamodule.AlarmNELists;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class QFReceiveAlmNeLstHandler {
    private Logger log = TELogFactory.getNormalLogger();

    public int handleRequest(FStruct req, FStruct rsp, TaskMgr tm, TETaskInfo info) {
        this.log.info("QFReceiveAlmNeLstHandler begin !");
        int result = 0;
        AsnSentToJavaReq cReq = (AsnSentToJavaReq)req;
        AsnSentToJavaRsp cRsp = (AsnSentToJavaRsp)rsp;
        AlarmNELists alarmNeLists = this.getAlmNeLst(cReq);
        WriteLogInfo logInfo = this.getWriteLogInfo(cReq.userID.intValue(), info.getMsgHead().senderProcIP);
        FuncEntrance.faultLocation(alarmNeLists, logInfo);
        AsnSingleReturn asnRtn = cRsp.result;
        asnRtn.retCode = BigInteger.valueOf(result);
        asnRtn.isSuccess = 0 == result;
        return result;
    }

    private AlarmNELists getAlmNeLst(AsnSentToJavaReq req) {
        AlarmNELists almNeLst = new AlarmNELists();
        this.parseNeSlotInfos(req.boardLst, almNeLst);
        almNeLst.setvAlarmPFELst(this.parseNeLst(req.vAlarmPFELst));
        return almNeLst;
    }

    private void parseNeSlotInfos(AsnNeSlotInfoLst asnNeSlotInfoLst, AlarmNELists almNeLst) {
        if (null != almNeLst && null != asnNeSlotInfoLst && !asnNeSlotInfoLst.isEmpty()) {
            int listSize = asnNeSlotInfoLst.size();
            for (int i = 0; i < listSize; ++i) {
                AsnNeSlotInfo neSlotInfo = (AsnNeSlotInfo)asnNeSlotInfoLst.get(i);
                almNeLst.addANeSlotPair(neSlotInfo.neID.intValue(), neSlotInfo.slotID.intValue());
            }
        }
    }

    private Set<Integer> parseNeLst(AsnNEIDList asnNEIDLst) {
        HashSet<Integer> neidSet = null;
        if (null != asnNEIDLst && !asnNEIDLst.isEmpty()) {
            neidSet = new HashSet<Integer>();
            int listSize = asnNEIDLst.size();
            for (int i = 0; i < listSize; ++i) {
                neidSet.add(asnNEIDLst.get(i));
            }
        }
        return neidSet;
    }

    private WriteLogInfo getWriteLogInfo(int userID, int ipNum) {
        WriteLogInfo info = new WriteLogInfo();
        info.setUserID(userID);
        info.setIpAddress("127.0.0.1");
        return info;
    }
}

