/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.quicklocating;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.marine.e2ecommon.WriteLogInfo;
import com.huawei.nglct.nemgr.marine.quicklocating.QuickLocatingMainMgr;
import com.huawei.nglct.nemgr.marine.quicklocating.datamodule.AlarmNELists;
import java.util.ArrayList;
import java.util.List;

public final class FuncEntrance {
    private static final String LOCATE_THREAD_NAME = "FaultLocateThread";
    private static List<QuickLocatingMainMgr> mgrList = null;
    private static Object mgrListLocker = new Object();
    private static Object processLocker = new Object();
    private static boolean isEnd = false;

    private FuncEntrance() {
    }

    public static void quickLocaterSwitch(boolean isStart) {
        if (isStart) {
            FuncEntrance.startQuickLocating();
            TELogFactory.getNormalLogger().info("quick locater is start!");
        } else {
            FuncEntrance.endQuickLocating();
            TELogFactory.getNormalLogger().info("quick locater is end!");
        }
    }

    private static void startQuickLocating() {
        FuncEntrance.newMgrList();
        isEnd = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void newMgrList() {
        Object object = mgrListLocker;
        synchronized (object) {
            if (null == mgrList) {
                mgrList = new ArrayList<QuickLocatingMainMgr>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void endQuickLocating() {
        Object object = mgrListLocker;
        synchronized (object) {
            if (null != mgrList) {
                for (QuickLocatingMainMgr aMgr : mgrList) {
                    aMgr.locationEnding();
                }
                mgrList.clear();
                mgrList = null;
                isEnd = true;
            }
        }
    }

    public static void faultLocation(final AlarmNELists alarmNeLists, final WriteLogInfo info) {
        TELogFactory.getNormalLogger().debug("FuncEntrance.faultLocation start!");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FuncEntrance.newMgrList();
                    QuickLocatingMainMgr aMainMgr = new QuickLocatingMainMgr(info);
                    Object object = mgrListLocker;
                    synchronized (object) {
                        if (isEnd) {
                            return;
                        }
                        mgrList.add(aMainMgr);
                    }
                    object = processLocker;
                    synchronized (object) {
                        if (isEnd) {
                            return;
                        }
                        aMainMgr.locatingEntrance(alarmNeLists);
                    }
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("error:", (Throwable)e);
                }
            }
        }, LOCATE_THREAD_NAME).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void oneLocationOver(QuickLocatingMainMgr aMgr) {
        if (null != aMgr && null != mgrList) {
            Object object = mgrListLocker;
            synchronized (object) {
                mgrList.remove(aMgr);
            }
        }
    }
}

