/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSData;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TEPRBSUtility {
    private static List<String> listeners = Collections.synchronizedList(new ArrayList());
    private static TENormalTestNoticeHandler normalNotice = new TENormalTestNoticeHandler();

    public static String getPortName(int neid, int slotid, int portid, int path) {
        String nename = TENEListMgr.getInstance().getNE(neid).getNEName();
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (board == null) {
            return "-";
        }
        int boardtype = board.getBoardType();
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neid, slotid, boardtype, portid);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
        StringBuffer name = new StringBuffer();
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
        name.append(nename);
        if (subrackName != null && !subrackName.equals("")) {
            name.append("-").append(subrackName);
            slotid = TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid);
        }
        name.append("-" + slotid).append("-" + boardname).append("-").append(portname);
        if (path > 0) {
            String showPath = String.valueOf(path);
            int isSimplessBoard = TEOTNModelDataMgr.getInstance().getGradeFromBoard(boardtype);
            if (isSimplessBoard != -1) {
                showPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(path);
            }
            name.append("-").append(showPath);
        }
        return name.toString();
    }

    public static void registerListener(int neID, String hashvalue) {
        try {
            if (listeners.size() == 0) {
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neID);
                Operation oper = definitions.getOperation("NSEVT_CFG_PRBS_AUTOREP");
                TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)normalNotice);
            }
            listeners.add(hashvalue);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void unregisterListener(int neID, String hashvalue) {
        try {
            listeners.remove(hashvalue);
            if (listeners.size() == 0) {
                Definitions definitions = TECreateObjectFactory.parseQxDesFile((int)neID);
                Operation oper = definitions.getOperation("NSEVT_CFG_PRBS_AUTOREP");
                TENECommMgr.getInstance().unregisterListener(oper, (NoticeHandler)normalNotice);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void registerListener(int neID) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSEVT_CFG_PRBS_AUTOREP");
            TENECommMgr.getInstance().registerListener(oper, (NoticeHandler)normalNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static void unregisterListener(int neID) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSEVT_CFG_PRBS_AUTOREP");
            TENECommMgr.getInstance().unregisterListener(oper, (NoticeHandler)normalNotice);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEBitTestCache registerListener error", (Throwable)e);
        }
    }

    public static ArrayList appendNEDateTimeOperation(int neid, ArrayList operationList) {
        Operation time;
        Operation date = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_DATE");
        if (date != null) {
            operationList.add(date);
        }
        if ((time = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_TIME")) != null) {
            operationList.add(time);
        }
        return operationList;
    }

    public static long getNEDateTime(int neid, ArrayList operationList) {
        long neTime = 0L;
        try {
            String neYear = "";
            String neMonth = "";
            String neDay = "";
            String neHour = "";
            String neMinute = "";
            String neSecond = "";
            int size = operationList.size();
            for (int j = 0; j < size; ++j) {
                Operation operation = (Operation)operationList.get(j);
                if (!operation.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                if (operation.getName().equals("NSCMD_CFG_GET_DATE")) {
                    neYear = operation.getOutput(0).getPartValue("neyear");
                    neMonth = operation.getOutput(0).getPartValue("nemonth");
                    neDay = operation.getOutput(0).getPartValue("neday");
                }
                if (!operation.getName().equals("NSCMD_CFG_GET_TIME")) continue;
                neHour = operation.getOutput(0).getPartValue("nehour");
                neMinute = operation.getOutput(0).getPartValue("neminute");
                neSecond = operation.getOutput(0).getPartValue("nesecond");
            }
            if (!(neYear.equals("") || neMonth.equals("") || neDay.equals("") || neHour.equals("") || neMinute.equals("") || neSecond.equals(""))) {
                neTime = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).getNEUTCTime(Integer.parseInt(neYear), Integer.parseInt(neMonth), Integer.parseInt(neDay), Integer.parseInt(neHour), Integer.parseInt(neMinute), Integer.parseInt(neSecond)).getTimeInMillis();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("PRBS get NeTime error:\n", (Throwable)e);
        }
        if (neTime == 0L) {
            Calendar locCal = Calendar.getInstance();
            Date utcDate = new Date(locCal.getTimeInMillis() - (long)(locCal.get(15) + locCal.get(16)));
            neTime = utcDate.getTime();
        }
        return neTime;
    }

    public static long getNmsUTCTime() {
        Calendar locCal = Calendar.getInstance();
        Date utcDate = new Date(locCal.getTimeInMillis() - (long)(locCal.get(15) + locCal.get(16)));
        return utcDate.getTime();
    }

    static class TENormalTestNoticeHandler
    implements NoticeHandler {
        TENormalTestNoticeHandler() {
        }

        public void handleNotice(int cmdkey, int neID, Operation operation) {
            String slotid = "";
            String portid = "";
            String path = "";
            int testtime = 0;
            long errnum = 0L;
            long prbslosNum = 0L;
            int testStatus = 0;
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                Part p = outputArr[i].getPart("slotid");
                slotid = p.getValue();
                p = outputArr[i].getPart("portid");
                portid = p.getValue();
                p = outputArr[i].getPart("path");
                path = p.getValue();
                p = outputArr[i].getPart("periodNum");
                testtime = new Integer(p.getValue());
                p = outputArr[i].getPart("prbsLos");
                if (null != p && !p.getValue().equals("")) {
                    prbslosNum = Long.parseLong(p.getValue());
                }
                p = outputArr[i].getPart("incrementNum");
                errnum = Long.parseLong(p.getValue());
                p = outputArr[i].getPart("testStatus");
                testStatus = Integer.parseInt(p.getValue());
            }
            String hashvalue = TEPRBSUtility.getPortName(neID, Integer.parseInt(slotid), Integer.parseInt(portid), Integer.parseInt(path));
            if (testStatus == 0) {
                TEPRBSUtility.unregisterListener(neID, hashvalue);
                return;
            }
            TEPRBSCache testcache = TEPRBSCache.getInstance();
            TEPRBSData testdata = testcache.getCahce(hashvalue);
            if (testdata == null) {
                return;
            }
            if (testdata.getTeststate() != 1) {
                return;
            }
            if (errnum <= 0L) {
                errnum = 0L;
            }
            testdata.refreshdata(testtime, errnum, prbslosNum);
        }
    }
}

