/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSUtility;
import com.huawei.nglct.util.device.board.TEQueryBoardInfoBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEPRBSTableInitBean
extends TENEExplorerBean {
    private int slotid = 0;
    private static final int BOARD_TYPE_12LQMS = 1185;
    private static final int BOARD_TYPE_11TOM = 1194;
    private static final int BOARD_MODE_CONNECT = 162;
    private static final int BOARD_MODE_ALONE = 163;
    private static final int BOARD_MODE_NS1 = 164;
    private static final int BOARD_MODE_RELAY = 169;
    private static final int BOARD_MODE_OPTICALRELAY = 170;
    private static final int BOARD_TYPE_52TOM = 1573;
    private static final int BOARD_TYPE_52ND2 = 1566;
    private static final int BOARD_TYPE_54NS3 = 2209;
    private static final int BOARD_TYPE_54NQ2 = 2211;
    private static final int BDTYPE_TN96TOA = 2348;

    /*
     * Enabled aggressive block sorting
     */
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        BussinessParams bussiness = new BussinessParams();
        this.outputData = new Datainterface();
        Param para = rowpara.getParam("slotid");
        RowParams rowdata = null;
        TEPRBSData testdata = null;
        String hashvalue = null;
        TEGenCfgPortAttribute portObj = null;
        int portid = -1;
        this.slotid = Integer.parseInt(para.getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotid);
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType());
        if (null == genCfgModel) {
            TELogFactory.getNormalLogger().error("the gencfgmodel of the board is not exist");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        TEGenCfgAttribute attrObj = genCfgModel.getAttrFromId("W32PORT_ATTR_PRBSTEST");
        if (null == attrObj) {
            TELogFactory.getNormalLogger().error("the TEGenCfgAttribute of the board is not exist");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        ArrayList portList = attrObj.getPortList();
        if (null == portList || 0 == portList.size()) {
            TELogFactory.getNormalLogger().error("there is not port");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        ArrayList<Integer> slotIdList = new ArrayList<Integer>();
        slotIdList.add(this.slotid);
        TEQueryBoardInfoBean.queryBoardInfo((int)neid, slotIdList);
        int boardMode = this.getBoardMode();
        HashMap nePortPathMap = TEConfigurationDataMgr.getInstance().getBoardPortPathMap(neid, 1573, this.slotid);
        HashMap portModeMap = this.queryPortMode(board.getBoardType());
        int portMode = -1;
        int i = 0;
        int len = portList.size();
        while (true) {
            block14: {
                if (i >= len) {
                    this.outputData.setBussinessParams(bussiness);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                    return this.outputData;
                }
                portObj = (TEGenCfgPortAttribute)portList.get(i);
                portid = portObj.getPort();
                switch (board.getBoardType()) {
                    case 1566: 
                    case 2209: 
                    case 2211: 
                    case 2425: {
                        if (boardMode != 169 && boardMode != 170) break;
                        break block14;
                    }
                    case 1573: {
                        if (nePortPathMap.containsKey(portid) && ((List)nePortPathMap.get(portid)).contains(portObj.getPath())) break;
                        break block14;
                    }
                    case 1185: {
                        if (boardMode != 164 || portid < 201) break;
                        break block14;
                    }
                    case 1194: {
                        if (!(boardMode == 162 && portid == 51 && portObj.getPath() != 1 || portid > 201 || portid > 51 && portid <= 54) && (boardMode != 163 || (portid < 51 || portid > 54 || portObj.getPath() == 1) && (portid != 201 && portid != 203 || portObj.getPath() <= 4) && (portid != 202 && portid != 204 || portObj.getPath() <= 2))) break;
                        break block14;
                    }
                    case 2279: 
                    case 2280: 
                    case 2348: {
                        portMode = (Integer)portModeMap.get(portid);
                        if (portMode != 260 && portObj.getPath() > 1) break block14;
                    }
                }
                hashvalue = TEPRBSUtility.getPortName(neid, this.slotid, portid, portObj.getPath());
                testdata = TEPRBSCache.getInstance().getCahce(hashvalue);
                if (testdata == null) {
                    rowdata = this.getBlankData(portid, portObj.getPath());
                    rowdata.addParam("path", String.valueOf(portObj.getPath()));
                } else {
                    rowdata = this.getSaveData(testdata);
                }
                bussiness.addRowParams(rowdata);
            }
            ++i;
        }
    }

    private HashMap queryPortMode(int boardType) {
        if (boardType == 2280 || boardType == 2279 || boardType == 2348) {
            return QueryWDMMode.queryPortMode((int)this.neid, (int)this.slotid);
        }
        return null;
    }

    private int getBoardMode() {
        Output temp;
        ArrayList<Operation> list = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SUBBDTYPE");
        oper.getInput().getPart("slotid").setValue(String.valueOf(this.slotid));
        list.add(oper);
        int result = this.sendMessage(this.neid, list);
        if (result == 0 && (temp = oper.getOutput(0)).getFault(0).getCode().equals("0")) {
            return Integer.parseInt(temp.getPart("W32BD_ATTR_SUBBDTYPE").getValue());
        }
        return -1;
    }

    private RowParams getBlankData(int portid, int path) {
        RowParams param = new RowParams();
        String portname = TEPRBSUtility.getPortName(this.neid, this.slotid, portid, path);
        param.addParam("portid", portid + "");
        param.addParam("portname", portname);
        param.addParam("channel", "-");
        param.addParam("timeunit", "1");
        param.addParam("testtime", "1");
        param.addParam("starttime", "-");
        param.addParam("progress", "0%");
        param.addParam("totalErrNum", "0");
        param.addParam("isaccu", "0");
        param.addParam("teststate", "0");
        return param;
    }

    private RowParams getSaveData(TEPRBSData testdata) {
        this.handledata(testdata);
        RowParams param = new RowParams();
        String portname = TEPRBSUtility.getPortName(this.neid, this.slotid, testdata.getPortid(), testdata.getPath());
        param.addParam("portid", testdata.getPortid() + "");
        param.addParam("portname", portname);
        param.addParam("path", testdata.getPath() + "");
        param.addParam("timeunit", testdata.getTimeUnit() + "");
        param.addParam("testtime", testdata.getTesttime() + "");
        param.addParam("starttime", testdata.getStartTime());
        param.addParam("progress", testdata.getProgress() + "%");
        param.addParam("totalErrNum", testdata.getTotalErrNum() + "");
        param.addParam("isaccu", testdata.isAccumulation() + "");
        param.addParam("teststate", testdata.getTeststate() + "");
        return param;
    }

    private void handledata(TEPRBSData testdata) {
        if (testdata.getTeststate() == 0) {
            return;
        }
        long lastreporttime = testdata.getLastreportTime();
        if (lastreporttime == 0L && testdata.getQueryList().size() <= 0) {
            testdata.setTeststate(1);
            return;
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

