/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEPRBSGetPortList {
    private static final int BDTYPE_TN96TOA = 2348;

    public int getPortList(int neID, int slotID, List<TEGenCfgPortAttribute> portList) {
        int retCode = 0;
        if (TENEListMgr.getInstance().getNE(neID) == null) {
            return 1090596385;
        }
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neID, slotID);
        if (null == board) {
            return 1090646021;
        }
        int boardType = board.getBoardType();
        HashMap portModeMap = this.queryPortMode(neID, slotID, boardType);
        int portMode = -1;
        TEGenCfgPortAttribute portObj = null;
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
        TEGenCfgAttribute attrObj = genCfgModel.getAttrFromId("W32PORT_ATTR_PRBSTEST");
        if (null == attrObj) {
            TELogFactory.getNormalLogger().error("the W32PORT_ATTR_PRBSTEST of the board is not exist. neID->" + neID + ".slotID->" + slotID);
            return 0;
        }
        ArrayList genPortList = attrObj.getPortList();
        int len = genPortList.size();
        block3: for (int i = 0; i < len; ++i) {
            portObj = (TEGenCfgPortAttribute)genPortList.get(i);
            int portid = portObj.getPort();
            switch (boardType) {
                case 2280: 
                case 2348: 
                case 2481: {
                    portMode = (Integer)portModeMap.get(portid);
                    if (portMode == 1 ? portObj.getPath() > 2 : portMode == 65535 || portMode != 260 && portObj.getPath() > 1) continue block3;
                }
                default: {
                    portList.add(portObj);
                }
            }
        }
        return retCode;
    }

    private int getBoardMode(int neID, int slotID) {
        ArrayList<Operation> list = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_SUBBDTYPE");
        oper.getInput().getPart("slotid").setValue(String.valueOf(slotID));
        list.add(oper);
        int result = new TENEExplorerBean().sendMessage(neID, list);
        if (result == 0) {
            Output temp = oper.getOutput(0);
            if (temp.getFault(0).getCode().equals("0")) {
                return Integer.parseInt(temp.getPart("W32BD_ATTR_SUBBDTYPE").getValue());
            }
        } else {
            TELogFactory.getNormalLogger().info("get board mode fail!");
        }
        return -1;
    }

    private HashMap queryPortMode(int neID, int slotID, int boardType) {
        if (boardType == 2280 || boardType == 2279 || boardType == 2481 || boardType == 2482 || boardType == 2589 || boardType == 2348) {
            return QueryWDMMode.queryPortMode((int)neID, (int)slotID);
        }
        return null;
    }
}

