/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.prbs;

import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSNum;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Calendar;
import java.util.List;

public class TEPRBSDrawPic {
    private int PIC_HEIGHT = 220;
    private int PIC_WIDTH = 800;
    private BufferedImage spectWaveimage = new BufferedImage(this.PIC_WIDTH, this.PIC_HEIGHT, 1);
    private TEPRBSData testdata = null;
    private int x_lefttop = 90;
    private int y_lefttop = 30;
    private int y_leftbottom = this.PIC_HEIGHT - 20;
    private int x_rightbottom = this.PIC_WIDTH - 3;
    private String ystr = "errnum";
    private String xstr = "time";
    private Color standcoler = new Color(239, 239, 239);
    TimeZoneDateBean timezonebean = null;
    private static TEPRBSDrawPic instance = null;

    private TEPRBSDrawPic() {
    }

    public static synchronized TEPRBSDrawPic getInstance() {
        if (instance == null) {
            instance = new TEPRBSDrawPic();
        }
        return instance;
    }

    private void initres(int neid) {
        StringBuffer filePath = new StringBuffer("marine").append(File.separator).append("res").append(File.separator).append("prbs").append(File.separator).append("prbsres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
        this.ystr = resourceUtil.getString(this.ystr);
        this.xstr = resourceUtil.getString(this.xstr);
        this.timezonebean = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
    }

    public BufferedImage drawBitTestPic(int neid, String hashvalue) {
        this.initres(neid);
        this.testdata = TEPRBSCache.getInstance().getCahce(hashvalue);
        if (this.testdata == null) {
            this.drawInitPic();
        } else {
            this.drawDataPic();
        }
        return this.spectWaveimage;
    }

    public void drawInitPic() {
        Graphics2D waveg2d = this.getSVGGraphics();
        this.paintFrame(waveg2d);
        this.paintinitY(waveg2d);
    }

    public Graphics2D getSVGGraphics() {
        Graphics2D waveg2d = (Graphics2D)this.spectWaveimage.getGraphics();
        return waveg2d;
    }

    public void drawDataPic() {
        Graphics2D waveg2d = this.getSVGGraphics();
        this.paintFrame(waveg2d);
        this.paintBitTestData(waveg2d, this.testdata);
    }

    private long getrealdata(long querydata) {
        if (querydata >= 0xFFFFFFFFL) {
            return 0L;
        }
        return querydata;
    }

    private long[] getYaxisData(TEPRBSData testdata) {
        int isaccu = testdata.isAccumulation();
        long ymax = 100L;
        if (isaccu == 1) {
            if (ymax < testdata.getTotalErrNum()) {
                ymax = testdata.getTotalErrNum();
            }
        } else {
            List relist = testdata.getResultData();
            int len = relist.size();
            for (int i = 0; i < len; ++i) {
                TEPRBSNum testNum = (TEPRBSNum)relist.get(i);
                long num = this.getrealdata(testNum.getErrnum());
                if (num <= ymax) continue;
                ymax = num;
            }
        }
        long[] ydata = new long[6];
        if (ymax <= 120L) {
            ydata[0] = 0L;
            ydata[1] = 20L;
            ydata[2] = 40L;
            ydata[3] = 60L;
            ydata[4] = 80L;
            ydata[5] = ymax;
        } else {
            long gridy = ymax / 5L;
            ydata[0] = 0L;
            ydata[1] = gridy * 1L;
            ydata[2] = gridy * 2L;
            ydata[3] = gridy * 3L;
            ydata[4] = gridy * 4L;
            ydata[5] = ymax;
        }
        return ydata;
    }

    private long[] getErrData(TEPRBSData testdata) {
        int isaccu = testdata.isAccumulation();
        List relist = testdata.getResultData();
        int size = relist.size();
        long[] errdata = new long[size];
        if (isaccu == 1) {
            long sum = testdata.getOldErrNum();
            for (int i = 0; i < size; ++i) {
                long num = ((TEPRBSNum)relist.get(i)).getErrnum();
                long prbslosNum = ((TEPRBSNum)relist.get(i)).getPrbslosNum();
                if (num >= 0xFFFFFFFFL) {
                    errdata[i] = -1L;
                    sum += 0L;
                    continue;
                }
                if (num == 0L) {
                    errdata[i] = prbslosNum > 0L ? -1L : 0L;
                    sum += 0L;
                    continue;
                }
                errdata[i] = sum + num;
                sum += num;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                long num = ((TEPRBSNum)relist.get(i)).getErrnum();
                long prbslosNum = ((TEPRBSNum)relist.get(i)).getPrbslosNum();
                if (num >= 0xFFFFFFFFL) {
                    errdata[i] = -1L;
                    continue;
                }
                if (num == 0L) {
                    if (prbslosNum > 0L) {
                        errdata[i] = -1L;
                        continue;
                    }
                    errdata[i] = 0L;
                    continue;
                }
                errdata[i] = num;
            }
        }
        return errdata;
    }

    private String[] getTimeData(TEPRBSData testdata) {
        String[] timestr = new String[5];
        List relist = testdata.getResultData();
        int size = relist.size();
        int j = 0;
        int i = 0;
        while (i < size) {
            long time = ((TEPRBSNum)relist.get(i)).getHappenTime();
            Calendar calTime = Calendar.getInstance();
            calTime.setTimeInMillis(time);
            timestr[j] = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)testdata.getNeid()).calendarToTime(calTime);
            i += 20;
            ++j;
        }
        for (i = 0; i < timestr.length; ++i) {
            if (timestr[i] != null) continue;
            timestr[i] = "";
        }
        return timestr;
    }

    public void paintBitTestData(Graphics2D dc, TEPRBSData testdata) {
        long[] ydata = this.getYaxisData(testdata);
        long[] errdata = this.getErrData(testdata);
        String[] timedata = this.getTimeData(testdata);
        dc.setColor(Color.BLACK);
        long ymax = ydata[ydata.length - 1];
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < ydata.length; ++i) {
            FontMetrics fontmetri = dc.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata[i] + "");
            dc.drawString(ydata[i] + "", this.x_lefttop - cswidth - 3, this.y_leftbottom + 5 - y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom - this.x_lefttop) / 100;
        for (int i = 0; i < timedata.length; ++i) {
            dc.drawString(timedata[i], this.x_lefttop + x_gridw * i * 20, this.y_leftbottom + 15);
        }
        int h = this.y_leftbottom - this.y_lefttop;
        for (int i = 0; i < errdata.length; ++i) {
            int errh;
            if (errdata[i] == -1L) {
                dc.setColor(Color.YELLOW);
                errh = h;
                dc.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_lefttop, 3, errh);
                continue;
            }
            if (errdata[i] == 0L) {
                dc.setColor(Color.GREEN);
                errh = h;
                dc.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_lefttop, 3, errh);
                continue;
            }
            dc.setColor(Color.red);
            errh = (int)((double)errdata[i] / (double)ymax * (double)h);
            dc.fillRect(this.x_lefttop + x_gridw * (i + 1) - 1, this.y_leftbottom - errh, 3, errh);
        }
    }

    public void paintinitY(Graphics2D dc) {
        int[] ydata = new int[]{0, 20, 40, 60, 80, 100};
        dc.setColor(Color.BLACK);
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < ydata.length; ++i) {
            FontMetrics fontmetri = dc.getFontMetrics();
            int cswidth = fontmetri.stringWidth(ydata[i] + "");
            dc.drawString(ydata[i] + "", this.x_lefttop - cswidth - 3, this.y_leftbottom + 5 - y_gridh * i);
        }
    }

    public void paintFrame(Graphics2D dc) {
        dc.setColor(this.standcoler);
        dc.fillRect(0, 0, 820, 250);
        dc.setColor(Color.BLACK);
        dc.drawLine(this.x_lefttop, this.y_lefttop - 2, this.x_lefttop, this.y_leftbottom);
        dc.drawLine(this.x_lefttop, this.y_leftbottom, this.x_rightbottom, this.y_leftbottom);
        int y_gridh = (this.y_leftbottom - this.y_lefttop) / 5;
        for (int i = 0; i < 5; ++i) {
            dc.drawLine(this.x_lefttop - 2, this.y_lefttop + y_gridh * i, this.x_lefttop + 2, this.y_lefttop + y_gridh * i);
        }
        int x_gridw = (this.x_rightbottom - this.x_lefttop) / 100;
        for (int j = 1; j <= 100; ++j) {
            dc.setColor(Color.BLACK);
            dc.drawLine(this.x_lefttop + x_gridw * j, this.y_leftbottom + 2, this.x_lefttop + x_gridw * j, this.y_leftbottom - 2);
            if (j % 10 != 0) continue;
            dc.setColor(Color.blue);
            dc.drawLine(this.x_lefttop + x_gridw * j, this.y_leftbottom + 2, this.x_lefttop + x_gridw * j, this.y_leftbottom - 5);
        }
        dc.drawString("(" + this.ystr + ")", this.x_lefttop + 5, this.y_lefttop - 10);
        dc.drawString("(" + this.xstr + ")", this.x_rightbottom - 32, this.y_leftbottom + 15);
    }
}

