/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSNum;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

public class TEPRBSData {
    private int neid;
    private int slotid;
    private int portid;
    private int path = 1;
    private int timeUnit;
    private long startTime;
    private int testTime;
    private int isAccumulation;
    private int progress = 0;
    private long oldErrNum = 0L;
    private long totalErrNum = 0L;
    private LinkedList reportResult = new LinkedList();
    private LinkedList queryResult = new LinkedList();
    private int teststatus = 0;
    private long lastreportTime = 0L;
    private int currentNumber = 0;
    private long neToNmsTime = 0L;
    private TimeZoneDateBean timeTool;

    public long getNeToNmsTime() {
        return this.neToNmsTime;
    }

    public void setNeToNmsTime(long neToNmsTime) {
        this.neToNmsTime = neToNmsTime;
    }

    public TEPRBSData(int neid) {
        this.neid = neid;
        this.timeTool = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
    }

    public void init() {
        this.setOldErrNum(0L);
        this.totalErrNum = 0L;
        this.queryResult.clear();
    }

    public LinkedList getQueryList() {
        return this.queryResult;
    }

    public List getResultData() {
        if (this.teststatus == 0) {
            if (this.reportResult.size() != 0) {
                return this.reportResult;
            }
            return this.queryResult;
        }
        return this.reportResult;
    }

    private long getrealdata(long querydata) {
        if (querydata >= 0xFFFFFFFFL) {
            return 0L;
        }
        return querydata;
    }

    public void addQueryResult(long errnum, int firstpoint, long prbslosNum) {
        if (this.queryResult.size() >= 100) {
            TEPRBSNum tNum = (TEPRBSNum)this.queryResult.removeFirst();
            this.setOldErrNum(this.getOldErrNum() + this.getrealdata(tNum.getErrnum()));
            ++this.currentNumber;
        } else {
            this.currentNumber = this.queryResult.size();
        }
        TEPRBSNum testnum = new TEPRBSNum();
        testnum.setErrnum(errnum);
        testnum.setPrbslosNum(prbslosNum);
        switch (this.timeUnit) {
            case 1: {
                testnum.setHappenTime(this.startTime + 1000L * (long)this.currentNumber);
                break;
            }
            case 2: {
                testnum.setHappenTime(this.startTime + 600000L * (long)this.currentNumber);
                break;
            }
            case 3: {
                testnum.setHappenTime(this.startTime + 3600000L * (long)this.currentNumber);
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEPRBSData.addQueryResult() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        this.progress = (int)((double)(this.currentNumber + 1) / (double)this.testTime * 100.0);
        if (this.progress > 100) {
            this.progress = 100;
        }
        this.queryResult.add(testnum);
        this.totalErrNum += this.getrealdata(errnum);
    }

    public void addReportResult(TEPRBSNum testnum) {
        if (this.reportResult.size() >= 100) {
            TEPRBSNum tNum = (TEPRBSNum)this.reportResult.removeFirst();
            this.oldErrNum += this.getrealdata(tNum.getErrnum());
            ++this.currentNumber;
        } else {
            this.currentNumber = this.reportResult.size();
        }
        this.reportResult.add(testnum);
        this.totalErrNum += this.getrealdata(testnum.getErrnum());
    }

    synchronized void clearReportResult() {
        this.reportResult.clear();
    }

    public static void main(String[] saf) {
        LinkedList<String> reportResult = new LinkedList<String>();
        reportResult.add("saf");
        reportResult.add("safsafd");
        System.out.println((String)reportResult.getLast());
        reportResult.getFirst();
    }

    public void setNeid(int neid) {
        this.neid = neid;
    }

    public int getNeid() {
        return this.neid;
    }

    public void setSlotid(int slotid) {
        this.slotid = slotid;
    }

    public int getSlotid() {
        return this.slotid;
    }

    public void setPortid(int portid) {
        this.portid = portid;
    }

    public int getPortid() {
        return this.portid;
    }

    public void setPath(int path) {
        this.path = path;
    }

    public int getPath() {
        return this.path;
    }

    public void setTimeUnit(int timeUnit) {
        this.timeUnit = timeUnit;
    }

    public int getTimeUnit() {
        return this.timeUnit;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getStartTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.startTime);
        return this.timeTool.calendarToTime(cal);
    }

    public long getStartTimeToLong() {
        return this.startTime;
    }

    public long getTotalTesttimeInMillisecond() {
        long timeTotal = 0L;
        switch (this.timeUnit) {
            case 1: {
                timeTotal = (long)this.testTime * 1000L;
                break;
            }
            case 2: {
                timeTotal = (long)this.testTime * 600000L;
                break;
            }
            case 3: {
                timeTotal = (long)this.testTime * 3600000L;
            }
        }
        return timeTotal;
    }

    public void setAccumulation(int isAccumulation) {
        this.isAccumulation = isAccumulation;
    }

    public int isAccumulation() {
        return this.isAccumulation;
    }

    public void setTesttime(int testtime) {
        this.testTime = testtime;
    }

    public int getTesttime() {
        return this.testTime;
    }

    public void refreshdata(int elapsetime, long errnum, long prbslosNum) {
        long time = 0L;
        switch (this.timeUnit) {
            case 1: {
                this.progress = (int)((double)elapsetime / (double)this.testTime * 100.0);
                time = (long)(elapsetime - 1) * 1000L;
                break;
            }
            case 2: {
                this.progress = (int)((double)elapsetime / (double)(this.testTime * 10) * 100.0);
                time = (long)(elapsetime - 1) * 60000L;
                break;
            }
            case 3: {
                this.progress = (int)((double)elapsetime / (double)(this.testTime * 60) * 100.0);
                time = (long)(elapsetime - 1) * 60000L;
                break;
            }
            default: {
                TELogFactory.getNormalLogger().info("TEPRBSData.refreshdata() timeUnit:" + this.timeUnit + " not in case!");
            }
        }
        TEPRBSNum testNum = new TEPRBSNum();
        long happentime = this.startTime + time;
        testNum.setHappenTime(happentime);
        testNum.setErrnum(errnum);
        testNum.setPrbslosNum(prbslosNum);
        this.addReportResult(testNum);
        this.setLastreportTime(happentime);
        if (this.progress >= 100) {
            this.progress = 100;
            this.teststatus = 0;
        } else {
            this.teststatus = 1;
        }
    }

    public void setTotalErrNum(long totalErrNum) {
        this.totalErrNum = totalErrNum;
    }

    public long getTotalErrNum() {
        return this.totalErrNum;
    }

    public synchronized void setProgress(int progress) {
        this.progress = progress;
    }

    public synchronized int getProgress() {
        if (this.progress > 100) {
            this.progress = 100;
        }
        return this.progress;
    }

    public void setTeststate(int teststate) {
        this.teststatus = teststate;
    }

    public int getTeststate() {
        return this.teststatus;
    }

    public void setOldErrNum(long oldErrNum) {
        this.oldErrNum = oldErrNum;
    }

    public long getOldErrNum() {
        return this.oldErrNum;
    }

    public void setLastreportTime(long lastreportTime) {
        this.lastreportTime = lastreportTime;
    }

    public long getLastreportTime() {
        return this.lastreportTime;
    }
}

