/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.marine.prbs.TEPRBSUtility;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEPRBSClearBean
extends TENEExplorerBean {
    private String strneid = "";
    private String slotid = "";
    private String portid = "";
    private String path = "";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            Operation op = (Operation)this.operationList.get(0);
            Input input = op.getInput();
            try {
                this.strneid = inputData.getBussinessParams().getRowParams(0).getParam("neid").getValue();
                this.slotid = input.getPartValue("slotid");
                this.portid = input.getPartValue("portid");
                this.path = input.getPartValue("path");
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEPRBSClearBean.performBussinessProcess() fail!", (Throwable)e);
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(37898);
        return codeList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int iNeId = 0;
        int iSlotId = 0;
        int iPortId = 0;
        try {
            iNeId = Integer.parseInt(this.strneid);
            iSlotId = Integer.parseInt(this.slotid);
            iPortId = Integer.parseInt(this.portid);
            String hashvalue = TEPRBSUtility.getPortName(iNeId, iSlotId, iPortId, Integer.parseInt(this.path));
            TEPRBSData prbsData = TEPRBSCache.getInstance().getCahce(hashvalue);
            if (prbsData != null && prbsData.getTeststate() == 1) {
                prbsData.clearReportResult();
                prbsData.setTotalErrNum(0L);
                prbsData.setLastreportTime(0L);
            } else {
                TEPRBSCache.getInstance().delCahce(hashvalue);
            }
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEPRBSClearBean.handleMessage() fail!", (Throwable)e);
        }
    }
}

