/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.marine.common.TENEExplorerCommonForLogBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEModifyPortProtectionGroup
extends TENEExplorerCommonForLogBean {
    private static final int TIME_OUT = 20;
    private static final String WPROTECTIONUNIT = "2";
    private static final String PPROTECTIONUNIT = "1";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.user = user;
            this.createOperationList();
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)20).retCode;
            this.outputData = new Datainterface();
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Exception in the performBussinessProcess method", (Throwable)e);
        }
        return this.outputData;
    }

    public void createOperationList() {
        this.operationList = new ArrayList();
        Operation operation = null;
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            int j;
            int arrLen;
            String[] eventStrArr;
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
            Input input = operation.getInput();
            Part part = input.getPart("neId");
            part.setValue(rParams[i].getParam("neId").getValue());
            part = input.getPart("groupId");
            part.setValue(rParams[i].getParam("groupId").getValue());
            part = input.getPart("protectionUnit");
            part.setValue(PPROTECTIONUNIT);
            part = input.getPart("delayTime");
            part.setValue(rParams[i].getParam("pdelayTime").getValue());
            this.operationList.add(operation);
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
            input = operation.getInput();
            part = input.getPart("neId");
            part.setValue(rParams[i].getParam("neId").getValue());
            part = input.getPart("groupId");
            part.setValue(rParams[i].getParam("groupId").getValue());
            part = input.getPart("protectionUnit");
            part.setValue(WPROTECTIONUNIT);
            part = input.getPart("delayTime");
            part.setValue(rParams[i].getParam("wdelayTime").getValue());
            this.operationList.add(operation);
            if (rParams[i].getParam("revertiveMode") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_RESTORE_MODE");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("revertiveMode");
                part.setValue(rParams[i].getParam("revertiveMode").getValue());
                part = input.getPart("wtrTime");
                part.setValue(rParams[i].getParam("wtrTime").getValue());
                this.operationList.add(operation);
            }
            if (rParams[i].getParam("SDEnable") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SDFLAG");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("SDEnable");
                part.setValue(rParams[i].getParam("SDEnable").getValue());
                this.operationList.add(operation);
            }
            if (rParams[i].getParam("sdAlarmList") != null) {
                eventStrArr = rParams[i].getParam("sdAlarmList").getValue().split(",");
                arrLen = eventStrArr.length;
                for (j = 0; j < arrLen; ++j) {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SDEVENT");
                    input = operation.getInput();
                    part = input.getPart("neId");
                    part.setValue(rParams[i].getParam("neId").getValue());
                    part = input.getPart("groupId");
                    part.setValue(rParams[i].getParam("groupId").getValue());
                    part = input.getPart("sdAlarmId");
                    part.setValue(eventStrArr[j]);
                    part = input.getPart("isSDEvent");
                    part.setValue(PPROTECTIONUNIT);
                    this.operationList.add(operation);
                }
            }
            if (rParams[i].getParam("unsdAlarmList") != null) {
                eventStrArr = rParams[i].getParam("unsdAlarmList").getValue().split(",");
                arrLen = eventStrArr.length;
                for (j = 0; j < arrLen; ++j) {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SDEVENT");
                    input = operation.getInput();
                    part = input.getPart("neId");
                    part.setValue(rParams[i].getParam("neId").getValue());
                    part = input.getPart("groupId");
                    part.setValue(rParams[i].getParam("groupId").getValue());
                    part = input.getPart("sdAlarmId");
                    part.setValue(eventStrArr[j]);
                    part = input.getPart("isSDEvent");
                    part.setValue("0");
                    this.operationList.add(operation);
                }
            }
            if (rParams[i].getParam("sfAlarmList") != null) {
                eventStrArr = rParams[i].getParam("sfAlarmList").getValue().split(",");
                arrLen = eventStrArr.length;
                for (j = 0; j < arrLen; ++j) {
                    operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SFEVENT");
                    input = operation.getInput();
                    part = input.getPart("neId");
                    part.setValue(rParams[i].getParam("neId").getValue());
                    part = input.getPart("groupId");
                    part.setValue(rParams[i].getParam("groupId").getValue());
                    part = input.getPart("sfAlarmId");
                    part.setValue(eventStrArr[j]);
                    part = input.getPart("isSFEvent");
                    part.setValue(PPROTECTIONUNIT);
                    this.operationList.add(operation);
                }
            }
            if (rParams[i].getParam("unsfAlarmList") == null) continue;
            eventStrArr = rParams[i].getParam("unsfAlarmList").getValue().split(",");
            arrLen = eventStrArr.length;
            for (j = 0; j < arrLen; ++j) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SFEVENT");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("sfAlarmId");
                part.setValue(eventStrArr[j]);
                part = input.getPart("isSFEvent");
                part.setValue("0");
                this.operationList.add(operation);
            }
        }
    }

    @Override
    protected String descToString(Datainterface inputData) {
        return this.portProtectionToString(inputData);
    }

    private String portProtectionToString(Datainterface inputData) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("portprotection").append(File.separator).append("portprotectionres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        String strOperateObject = "";
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        strOperateObject = null == neObj ? String.valueOf(this.neid) : neObj.getNEName();
        StringBuffer strBuf = new StringBuffer("");
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        strBuf.append(this.res.getString("protection_group_name")).append(strOperateObject).append("-").append(rowParams.getParam("groupId").getValue()).append(this.res.getString("protection_type"));
        int protectionType = Integer.parseInt(rowParams.getParam("protectionType").getValue());
        String protectionTypeStr = "";
        String controlUnit = "";
        switch (protectionType) {
            case 1: {
                protectionTypeStr = protectionTypeStr + this.res.getString("board_protection");
                break;
            }
            case 3: {
                protectionTypeStr = protectionTypeStr + this.res.getString("client_protection");
                if ("".equals(rowParams.getParam("cwPath").getValue())) break;
                controlUnit = controlUnit + this.res.getString("control_unit_working_path") + rowParams.getParam("cwPath").getValue();
                break;
            }
            case 4: {
                protectionTypeStr = protectionTypeStr + this.res.getString("line_protection");
                break;
            }
        }
        strBuf.append(protectionTypeStr).append(this.res.getString("working_unit")).append(rowParams.getParam("workingUnit").getValue()).append(this.res.getString("working_unit_delaytime")).append((float)Integer.parseInt(rowParams.getParam("wdelayTime").getValue()) / 10.0f).append(this.res.getString("time_unit")).append(this.res.getString("protection_unit")).append(rowParams.getParam("protectionUnit").getValue()).append(this.res.getString("protection_unit_delaytime")).append((float)Integer.parseInt(rowParams.getParam("pdelayTime").getValue()) / 10.0f).append(this.res.getString("time_unit")).append(controlUnit);
        if (rowParams.getParam("revertiveMode") != null) {
            strBuf.append(this.res.getString("revertive_mode"));
            int reveMode = Integer.parseInt(rowParams.getParam("revertiveMode").getValue());
            if (reveMode == 1) {
                strBuf.append(this.res.getString("revertive")).append(this.res.getString("wtr_time")).append(rowParams.getParam("wtrTime").getValue()).append(this.res.getString("time_unit"));
            } else {
                strBuf.append(this.res.getString("non_revertive"));
            }
        }
        strBuf.append(this.res.getString("sd_trigger_flag"));
        int sdEnable = Integer.parseInt(rowParams.getParam("sdEnable").getValue());
        if (sdEnable == 1) {
            strBuf.append(this.res.getString("enabled"));
        } else {
            strBuf.append(this.res.getString("disabled"));
        }
        return strBuf.toString();
    }
}

