/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.performance.pfmconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nemgr.marine.common.TENEExplorerCommonForLogBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEPfmRegResetBean
extends TENEExplorerCommonForLogBean
implements TENEMgrInterface {
    private int TIME_OUT = 10;
    private int NSCMD_PER_CLEAR_CURDATA = 26129;
    private int NSCMD_PER_CLEAR_HISDATA = 26131;
    private int NSCMD_PER_CLEAR_CSES = 26133;
    private int NSCMD_PER_CLEAR_UAT = 26135;
    private TEResourceUtil res = null;
    private int neid;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        this.user = user;
        ArrayList operationList = new ArrayList();
        TEPfmMonObjID pfmmonobj = new TEPfmMonObjID();
        String regtypes = "";
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int len = rParams[0].getParam().length;
        for (int j = 0; j < len; ++j) {
            Param[] params = rParams[0].getParam();
            Param param = params[j];
            String value = param.getValue();
            if (TEPfmUtility.validateParam((Param)param, (String)"neID")) {
                pfmmonobj.m_ulNEID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"slotID")) {
                pfmmonobj.m_usSlotID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"fbType")) {
                pfmmonobj.m_usFBType = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"portID")) {
                pfmmonobj.m_usPortID = Integer.parseInt(value);
                continue;
            }
            if (TEPfmUtility.validateParam((Param)param, (String)"pathID")) {
                pfmmonobj.m_usPathID = Integer.parseInt(value);
                continue;
            }
            if (!TEPfmUtility.validateParam((Param)param, (String)"regtypes")) continue;
            regtypes = value;
        }
        pfmmonobj.decPathID();
        try {
            operationList = this.getOperationList(regtypes, pfmmonobj);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEPfmRegResetBean.performBussinessProcess() fail!", (Throwable)e);
        }
        Datainterface output = this.handleMessage(neid, operationList, pfmmonobj);
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, output);
        }
        return output;
    }

    private Datainterface handleMessage(int neid, ArrayList operationList, TEPfmMonObjID pfmmonobj) {
        Datainterface outputData = new Datainterface();
        if (null == operationList) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return outputData;
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, (List)operationList, this.TIME_OUT);
        if (result.retCode == 0) {
            boolean succ = false;
            boolean fault = false;
            boolean row_succ = false;
            boolean addFault = false;
            outputData.setBussinessParams(new BussinessParams());
            int size = operationList.size();
            for (int i = 0; i < size; ++i) {
                Operation operation = (Operation)operationList.get(i);
                TEDataConverter.handleSpecialStr((Operation)operation);
                if (operation.getOutputCount() == 0) {
                    succ = true;
                }
                Output[] outputArr = operation.getOutput();
                RowParams rowparams = new RowParams();
                for (int j = 0; j < outputArr.length; ++j) {
                    Output output = outputArr[j];
                    row_succ = TEPfmUtility.handleRowError((RowParams)rowparams, (Output)output, (TEPfmMonObjID)pfmmonobj);
                    if (row_succ) {
                        succ = true;
                        if (rowparams.getRowErrorsCount() > 0) {
                            fault = true;
                        }
                    } else {
                        fault = true;
                        if (!addFault) {
                            outputData.getBussinessParams().addRowParams(rowparams);
                        }
                        addFault = true;
                    }
                    row_succ = false;
                }
            }
            outputData.setErrorMessage(new ErrorMessage());
            if (succ && !fault) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (!succ && fault) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            } else {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
        }
        return outputData;
    }

    private ArrayList getOperationList(String regTypes, TEPfmMonObjID pfmmonobj) throws Exception {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        ArrayList regList = TEPfmUtility.getTokensFromStr((String)regTypes);
        int size = regList.size();
        block8: for (int i = 0; i < size; ++i) {
            String tmp = (String)regList.get(i);
            Operation oper = null;
            switch (Integer.parseInt(tmp)) {
                case 1: {
                    oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_CLEAR_CURDATA);
                    this.fillInputParts(oper, 1, pfmmonobj);
                    operationList.add(oper);
                    continue block8;
                }
                case 2: {
                    oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_CLEAR_CURDATA);
                    this.fillInputParts(oper, 2, pfmmonobj);
                    operationList.add(oper);
                    continue block8;
                }
                case 3: {
                    oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_CLEAR_HISDATA);
                    this.fillInputParts(oper, 1, pfmmonobj);
                    operationList.add(oper);
                    continue block8;
                }
                case 4: {
                    oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_CLEAR_HISDATA);
                    this.fillInputParts(oper, 2, pfmmonobj);
                    operationList.add(oper);
                    continue block8;
                }
                case 6: {
                    oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_CLEAR_CSES);
                    this.fillInputParts(oper, pfmmonobj);
                    operationList.add(oper);
                    continue block8;
                }
                case 5: {
                    oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_CLEAR_UAT);
                    this.fillInputParts(oper, pfmmonobj);
                    operationList.add(oper);
                    continue block8;
                }
            }
        }
        return operationList;
    }

    private void fillInputParts(Operation oper, TEPfmMonObjID pfmmonobj) {
        Input input = oper.getInput();
        Part[] partArr = input.getPart();
        int len3 = partArr.length;
        for (int k = 0; k < len3; ++k) {
            if (partArr[k].getName().equals("slotID")) {
                partArr[k].setValue(String.valueOf(pfmmonobj.m_usSlotID));
                continue;
            }
            if (partArr[k].getName().equals("portID")) {
                partArr[k].setValue(String.valueOf(pfmmonobj.m_usPortID));
                continue;
            }
            if (partArr[k].getName().equals("pathID")) {
                partArr[k].setValue(String.valueOf(pfmmonobj.m_usPathID));
                continue;
            }
            if (!partArr[k].getName().equals("peid")) continue;
            partArr[k].setValue("0");
        }
    }

    private void fillInputParts(Operation oper, int period, TEPfmMonObjID pfmmonobj) {
        Input input = oper.getInput();
        Part[] partArr = input.getPart();
        int len3 = partArr.length;
        for (int k = 0; k < len3; ++k) {
            if (partArr[k].getName().equals("slotID")) {
                partArr[k].setValue(String.valueOf(pfmmonobj.m_usSlotID));
                continue;
            }
            if (partArr[k].getName().equals("portID")) {
                partArr[k].setValue(String.valueOf(pfmmonobj.m_usPortID));
                continue;
            }
            if (partArr[k].getName().equals("pathID")) {
                partArr[k].setValue(String.valueOf(pfmmonobj.m_usPathID));
                continue;
            }
            if (partArr[k].getName().equals("peid")) {
                partArr[k].setValue("0");
                continue;
            }
            if (!partArr[k].getName().equals("period")) continue;
            partArr[k].setValue(String.valueOf(period));
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    @Override
    protected String descToString(Datainterface inputData) {
        return this.permanceToString(this.neid, inputData);
    }

    private String permanceToString(int neid, Datainterface inputData) {
        StringBuffer filePath1 = new StringBuffer();
        filePath1.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("performance").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath1);
        TEResourceUtil rmonRes = null;
        StringBuffer filePath = new StringBuffer();
        filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("performance").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        rmonRes = TEResourceUtil.getInstance((String)TEGetFilePath.getFilePath((int)neid, (String)filePath.toString()));
        TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();
        StringBuffer strBuf = new StringBuffer();
        String boardString = this.res.getString("board");
        strBuf.append(boardString);
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int slotID = Integer.parseInt(rParams[0].getParam("slotID").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
        strBuf.append(slotID).append("-").append(tEConfigurationDataMgr.getBoardTypeName(neid, boardType));
        strBuf.append(" ");
        Param param = rParams[0].getParam("regtypes");
        if (param != null) {
            strBuf.append(rmonRes.getString("ReSetRegistor"));
            String[] regtypes = rParams[0].getParam("regtypes").getValue().split("-");
            int len = regtypes.length;
            for (int i = 0; i < len; ++i) {
                strBuf.append(rmonRes.getString("PFM_REGTYPE" + regtypes[i]));
                if (i == len - 1) continue;
                strBuf.append(rmonRes.getString("Dot_Flag"));
            }
        }
        return strBuf.toString();
    }
}

