/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.performance.pfmconfig;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nemgr.marine.common.TENEExplorerCommonForLogBean;
import com.huawei.nglct.nemgr.necommon.performance.pfmconfig.TEPfmBsTimePara;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;

public class TEPfmMonTimeBean
extends TENEExplorerCommonForLogBean {
    private int NSCMD_PER_SET_STARTTIME = 26113;
    private int NSCMD_PER_SET_ENDTIME = 26115;
    private static Logger log = TELogFactory.getNormalLogger();
    private ArrayList errcodeList = null;
    private ArrayList paraList = null;
    private static final String NE_NOT_LOGIN = "37926";
    private TimeZoneDateBean TimeProccessor = null;
    private int FUN_APPLY_PFMMONTIME = 0x201010;
    private int FUN_QUERY_PFMMONTIME = 0x201012;
    private String _15MPeriodName = "pfm15MState";
    private String _15MBeginTime = "pfm15MBeginTime";
    private String _15MEndTime = "pfm15MEndTime";
    private String _24HPeriodName = "pfm24HState";
    private String _24HBeginTime = "pfm24HBeginTime";
    private String _24HEndTime = "pfm24HEndTime";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.TimeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid);
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.user = user;
            this.outputData = new Datainterface();
            if (this.subfunc.getCode() == 0x201010) {
                this.operationList = this.getApplyOperationList();
            } else if (this.subfunc.getCode() == 0x201012) {
                this.operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            }
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            log.error("Get/Modify Ne Performance Monitor Time Fail!\n", (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
        if (!this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            BussinessParams bussinessParams = this.outputData.getBussinessParams();
            if (bussinessParams == null) {
                return this.outputData;
            }
            if (bussinessParams.getRowParamsCount() == 0) {
                return this.outputData;
            }
            RowParams rowparams = bussinessParams.getRowParams(bussinessParams.getRowParamsCount() - 1);
            RowErrors rowErrors = rowparams.getRowErrors(0);
            if (rowErrors.getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) {
                this.outputData = new Datainterface();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
            }
        }
        return this.outputData;
    }

    private ArrayList getApplyOperationList() {
        this.paraList = new ArrayList();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            int i;
            RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
            for (i = 0; i < rParams.length; ++i) {
                TEPfmBsTimePara para = new TEPfmBsTimePara();
                for (int j = 0; j < rParams[i].getParam().length; ++j) {
                    Param param = rParams[i].getParam()[j];
                    if (TEPfmUtility.validateParam((Param)param, (String)"period")) {
                        para.m_usPeriod = Integer.parseInt(param.getValue());
                        continue;
                    }
                    if (TEPfmUtility.validateParam((Param)param, (String)"pfmBeginTime")) {
                        para.m_tmStart = this.TimeProccessor.strToUTC(param.getValue());
                        continue;
                    }
                    if (!TEPfmUtility.validateParam((Param)param, (String)"pfmEndTime")) continue;
                    para.m_tmEnd = this.TimeProccessor.strToUTC(param.getValue());
                }
                para.m_usType = para.m_tmStart == null && para.m_tmEnd == null ? 0 : (para.m_tmEnd == null ? 1 : 2);
                this.paraList.add(para);
            }
            int size = this.paraList.size();
            block9: for (i = 0; i < size; ++i) {
                TEPfmBsTimePara para = (TEPfmBsTimePara)this.paraList.get(i);
                Operation oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_SET_STARTTIME);
                this.fillInputParts(oper, para.m_usPeriod, TEDateUtils.nullDate());
                operationList.add(oper);
                oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_SET_ENDTIME);
                this.fillInputParts(oper, para.m_usPeriod, TEDateUtils.nullDate());
                operationList.add(oper);
                switch (para.m_usType) {
                    case 0: {
                        continue block9;
                    }
                    case 1: {
                        oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_SET_STARTTIME);
                        this.fillInputParts(oper, para.m_usPeriod, para.m_tmStart);
                        operationList.add(oper);
                        continue block9;
                    }
                    case 2: {
                        oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_SET_STARTTIME);
                        this.fillInputParts(oper, para.m_usPeriod, para.m_tmStart);
                        operationList.add(oper);
                        oper = TEPfmUtility.getOperation((int)this.neid, (int)this.NSCMD_PER_SET_ENDTIME);
                        this.fillInputParts(oper, para.m_usPeriod, para.m_tmEnd);
                        operationList.add(oper);
                        continue block9;
                    }
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error(e.toString());
        }
        return operationList;
    }

    private void fillInputParts(Operation oper, int period, String dateStr) {
        String paraName = "";
        paraName = oper.getCmdid() == this.NSCMD_PER_SET_ENDTIME ? "pfmEndTime" : "pfmBeginTime";
        Input input = oper.getInput();
        Part[] partArr = input.getPart();
        int len = partArr.length;
        for (int k = 0; k < len; ++k) {
            if (partArr[k].getName().equalsIgnoreCase("period")) {
                partArr[k].setValue(String.valueOf(period));
                continue;
            }
            if (!partArr[k].getName().equalsIgnoreCase(paraName)) continue;
            partArr[k].setValue(dateStr);
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        if (subfunc.getCode() == this.FUN_QUERY_PFMMONTIME) {
            BussinessParams bParams = this.outputData.getBussinessParams();
            RowParams[] rParams = bParams.getRowParams();
            RowParams newRowParam = new RowParams();
            Param neidParam = new Param();
            neidParam.setName("neid");
            neidParam.setValue(String.valueOf(neid));
            newRowParam.addParam(neidParam);
            for (int i = 0; i < rParams.length; ++i) {
                Param param;
                int j;
                String pfmPeriod = "";
                for (j = 0; j < rParams[i].getParam().length; ++j) {
                    param = rParams[i].getParam()[j];
                    if (!param.getName().equalsIgnoreCase("period")) continue;
                    pfmPeriod = param.getValue();
                    if (pfmPeriod.equalsIgnoreCase(String.valueOf(1))) {
                        param.setName(this._15MPeriodName);
                        break;
                    }
                    if (pfmPeriod.equalsIgnoreCase(String.valueOf(2))) {
                        param.setName(this._24HPeriodName);
                        break;
                    }
                    log.info("error: the pfmPeriod is 0!");
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
                    return;
                }
                for (j = 0; j < rParams[i].getParam().length; ++j) {
                    param = rParams[i].getParam()[j];
                    if (param.getName().equalsIgnoreCase("pfmBeginTime")) {
                        if (pfmPeriod.equals(String.valueOf(1))) {
                            param.setName(this._15MBeginTime);
                        } else {
                            param.setName(this._24HBeginTime);
                        }
                        if (null == param.getValue() || "".equals(param.getValue())) {
                            param.setValue("");
                        } else {
                            param.setValue(this.TimeProccessor.calendarToTime(TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).byteStrToCalendar(param.getValue())));
                        }
                    }
                    if (param.getName().equalsIgnoreCase("pfmEndTime")) {
                        if (pfmPeriod.equals(String.valueOf(1))) {
                            param.setName(this._15MEndTime);
                        } else {
                            param.setName(this._24HEndTime);
                        }
                        if (null == param.getValue() || "".equals(param.getValue())) {
                            param.setValue("");
                        } else {
                            param.setValue(this.TimeProccessor.calendarToTime(TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)neid).byteStrToCalendar(param.getValue())));
                        }
                    }
                    newRowParam.addParam(param);
                }
            }
            int size = newRowParam.getParamCount();
            for (int z = 0; z < size; ++z) {
                Param tempParam = newRowParam.getParam(z);
                String name = tempParam.getName();
                if (bParams.getRowParams(0).getParam(name) != null && bParams.getRowParams(0).getParam(name).getValue() != null) {
                    bParams.getRowParams(0).getParam(name).setValue(tempParam.getValue());
                    continue;
                }
                bParams.getRowParams(0).addParam(newRowParam.getParam(z));
            }
            Param neNameParam = new Param();
            neNameParam.setName("neName");
            neNameParam.setValue(TENEListMgr.getInstance().getNE(neid).getNEName());
            bParams.getRowParams(0).addParam(neNameParam);
            if (bParams.getRowParams(0).getRowErrorsCount() == 0) {
                bParams.getRowParams(0).setRowErrors(bParams.getRowParams(1).getRowErrors());
            }
            int errCount1 = bParams.getRowParams(0).getRowErrorsCount();
            for (int t = 0; t < errCount1; ++t) {
                int errCount2 = bParams.getRowParams(0).getRowErrorsCount();
                for (int r = 1; r < errCount2; ++r) {
                    if (!bParams.getRowParams(0).getRowErrors(t).getErrorMessage().getErrorcode().equals(bParams.getRowParams(0).getRowErrors(r).getErrorMessage().getErrorcode())) continue;
                    bParams.getRowParams(0).getRowErrors(r).getErrorMessage().setErrorcode("0");
                }
            }
            bParams.removeRowParams(1);
        }
        if (subfunc.getCode() == this.FUN_APPLY_PFMMONTIME && !this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            RowParams[] rowparams = this.outputData.getBussinessParams().getRowParams();
            int len = this.outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len && rowparams[i].getRowErrorsCount() != 0; ++i) {
                int errlen = rowparams[i].getRowErrorsCount();
                for (int j = 0; j < errlen; ++j) {
                    String timeStr;
                    RowErrors rowerr = rowparams[i].getRowErrors(j);
                    if (rowerr.getParam("pfmBeginTime") != null) {
                        timeStr = rowerr.getParam("pfmBeginTime").getValue();
                        rowerr.getParam("pfmBeginTime").setValue(this.TimeProccessor.strToTime(timeStr));
                    }
                    if (rowerr.getParam("pfmEndTime") == null) continue;
                    timeStr = rowerr.getParam("pfmEndTime").getValue();
                    rowerr.getParam("pfmEndTime").setValue(this.TimeProccessor.strToTime(timeStr));
                }
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        this.errcodeList = new ArrayList();
        this.errcodeList.add(38422);
        return this.errcodeList;
    }

    @Override
    protected String descToString(Datainterface inputData) {
        StringBuffer filePath = new StringBuffer();
        filePath.append("marine").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("performance").append(File.separator).append("stringsource_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        return this.performanceToString(inputData, this.res);
    }

    private String performanceToString(Datainterface inputData, TEResourceUtil res) {
        StringBuffer strBuf = new StringBuffer();
        if (this.subfunc.getCode() == this.FUN_APPLY_PFMMONTIME) {
            TEPfmBsTimePara tEPfmBsTimePara = null;
            int size = this.paraList.size();
            for (int i = 0; i < size; ++i) {
                tEPfmBsTimePara = (TEPfmBsTimePara)this.paraList.get(i);
                if (1 == tEPfmBsTimePara.m_usPeriod) {
                    strBuf.append(res.getString("apply_15m_monitor_time")).append(" (");
                } else if (2 == tEPfmBsTimePara.m_usPeriod) {
                    strBuf.append(res.getString("apply_24h_monitor_time")).append(" (");
                }
                if (tEPfmBsTimePara.m_tmStart == null && tEPfmBsTimePara.m_tmEnd == null) {
                    strBuf.append(res.getString("close")).append(")");
                } else if (tEPfmBsTimePara.m_tmEnd == null) {
                    strBuf.append(res.getString("start_time")).append(" ").append(TEDateUtils.byteStrToDateStr((String)tEPfmBsTimePara.m_tmStart)).append(", ").append(res.getString("end_time")).append(" ").append(res.getString("no_modify")).append(")");
                } else {
                    strBuf.append(res.getString("start_time")).append(" ").append(", ").append(res.getString("end_time")).append(" ").append(TEDateUtils.byteStrToDateStr((String)tEPfmBsTimePara.m_tmEnd)).append(")");
                }
                strBuf.append(",");
            }
            strBuf.delete(strBuf.length() - 1, strBuf.length());
        } else if (this.subfunc.getCode() == this.FUN_QUERY_PFMMONTIME) {
            strBuf.append(res.getString("query_24h_monitor_time")).append(",").append(res.getString("query_15m_monitor_time"));
        }
        return strBuf.toString();
    }
}

