/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.performance;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPerformanceDataMgr;
import com.huawei.nglct.nelist.model.performance.TEPerformModel;
import com.huawei.nglct.nelist.model.performance.TEPfmBsEvent;
import com.huawei.nglct.nelist.model.performance.TEPfmEventsDataLoader;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class TEPfmUtility {
    public static final String DELIMITER = "-";
    private static final String QX_DES_PATH = "conf" + File.separator + "qxdescrib.xml";

    public static TEPerformModel getPfmModel(int neid, int slotid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        TEBoard board = ne.getBoard(slotid);
        if (null == board) {
            return null;
        }
        try {
            TEPerformModel model = TEPerformanceDataMgr.getInstance().getPerformModel(board.getBoardType());
            model.setNEID(neid);
            return model;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ArrayList getTokensFromStr(String str) {
        if (null == str || str.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            arrayList.add(tokenizer.nextToken());
        }
        return arrayList;
    }

    public static HashMap getTokenListFromStr(String str) {
        if (null == str || str.length() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            ArrayList tmp = TEPfmUtility.getTokensFromStr(token);
            if (null == tmp || tmp.size() != 2) continue;
            String key = (String)tmp.get(0);
            String value = (String)tmp.get(1);
            map.put(key, value);
        }
        return map;
    }

    public static String getStringFromSequenceOfInt(ArrayList src) {
        if (src != null) {
            StringBuffer result = new StringBuffer();
            int size = src.size();
            for (int i = 0; i < size; ++i) {
                result.append((Integer)src.get(i));
                if (i == size - 1) continue;
                result.append(DELIMITER);
            }
            return result.toString();
        }
        return "";
    }

    public static TEPfmBsEvent getPfmBsEvent(int neid, int slotid, int peid) {
        return TEPfmEventsDataLoader.getInstance().getPfmBsEvent(neid, peid);
    }

    public static int pfmEid2Qx5Eid(int neid, int slotid, int nmEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return nmEid;
        }
        int neEid = model.getNEEvent(nmEid);
        if (neEid > 4096) {
            return neEid;
        }
        return neEid & 0xFF;
    }

    public static int qx5Eid2PfmEid(int neid, int slotid, int neEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return neEid;
        }
        int nmEid = model.getNMEventID(neEid);
        int size = model.getEventList().size();
        for (int i = 0; i < size; ++i) {
            Integer tmp = (Integer)model.getEventList().get(i);
            if (tmp != nmEid) continue;
            return nmEid;
        }
        return neEid;
    }

    public static int pfmValue2Qx5Value(int neid, int slotid, double pfmValue, int peid) {
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (event.m_dUnit == 0.1) {
            return (int)(pfmValue * 10.0);
        }
        return (int)pfmValue;
    }

    public static double qx5Value2PfmValue(int neid, int slotid, int qx5Value, int peid) {
        double pfmValue = 0.0;
        if (qx5Value == Integer.MAX_VALUE) {
            return -1.0;
        }
        if (peid == 0) {
            return -1.0;
        }
        if (slotid == 0) {
            return -1.0;
        }
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (null == event) {
            return -1.0;
        }
        pfmValue = event.isCounter() ? (double)qx5Value : (double)qx5Value * event.m_dUnit;
        return pfmValue;
    }

    public static double qxValuePfmValue(int neid, int slotid, double qx5Value, int peid) {
        if (qx5Value == 2.147483647E9) {
            return -1.0;
        }
        if (peid == 0) {
            return -1.0;
        }
        if (slotid == 0) {
            return -1.0;
        }
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (event.m_dUnit == 0.1) {
            return qx5Value * event.m_dUnit;
        }
        return qx5Value;
    }

    public static Operation getOperation(int neid, String qxDes) throws Exception {
        Definitions definitions = TECreateObjectFactory.parseQxDesFile((String)"Marine_domainbundle", (String)TEGetFilePath.getFilePath((int)neid, (String)QX_DES_PATH));
        return definitions.getOperation(qxDes);
    }

    public static Operation getOperation(int neid, int cmdCode) throws Exception {
        Definitions definitions = TECreateObjectFactory.parseQxDesFile((String)"Marine_domainbundle", (String)TEGetFilePath.getFilePath((int)neid, (String)QX_DES_PATH));
        return definitions.getOperation(cmdCode);
    }

    public static boolean validatePart(Part part, String name) {
        return part.getName().equalsIgnoreCase(name) && part.getValue() != null;
    }

    public static boolean validateParam(Param param, String name) {
        return param.getName().equalsIgnoreCase(name) && param.getValue().length() > 0;
    }

    public static boolean handleRowError(RowParams rowparams, Output output, TEPfmMonObjID pfmmonobj) {
        String errorCode = "";
        String errorinfo = "";
        boolean row_succ = false;
        int faultlen = output.getFaultCount();
        for (int i = 0; i < faultlen; ++i) {
            errorCode = output.getFault(i).getCode();
            if (null == errorCode) {
                errorCode = "";
            }
            if (null == (errorinfo = output.getFault(i).getValue())) {
                errorinfo = "";
            }
            if (errorCode.equals("0") || errorCode.equals("38410") || errorCode.equals("38416")) {
                row_succ = true;
                continue;
            }
            RowErrors rowError = new RowErrors();
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setErrorcode(errorCode);
            if (!errorCode.equals("") && errorinfo.equals("")) {
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
            } else {
                errorMessage.setErrorinfo(errorinfo);
            }
            rowError.setErrorMessage(errorMessage);
            Param rowObj = new Param();
            rowObj.setName("monObj");
            rowObj.setValue(pfmmonobj.toString());
            rowError.addParam(rowObj);
            rowparams.addRowErrors(rowError);
        }
        return row_succ;
    }

    public static boolean handleRowError(int neid, RowParams rowparams, Output output, Input input) {
        return TEPfmUtility.handleRowError(rowparams, output, TEPfmUtility.getPfmMonObjFromInput(neid, input));
    }

    private static TEPfmMonObjID getPfmMonObjFromInput(int neid, Input input) {
        Part[] partArr = input.getPart();
        TEPfmMonObjID pfmmonobj = new TEPfmMonObjID();
        pfmmonobj.m_ulNEID = neid;
        int len2 = partArr.length;
        for (int k = 0; k < len2; ++k) {
            if (TEPfmUtility.validatePart(partArr[k], "slotID")) {
                pfmmonobj.m_usSlotID = Integer.parseInt(partArr[k].getValue());
                continue;
            }
            if (TEPfmUtility.validatePart(partArr[k], "portID")) {
                pfmmonobj.m_usPortID = Integer.parseInt(partArr[k].getValue());
                continue;
            }
            if (!TEPfmUtility.validatePart(partArr[k], "pathID")) continue;
            pfmmonobj.m_usPathID = Integer.parseInt(partArr[k].getValue());
        }
        pfmmonobj.decPathID();
        return pfmmonobj;
    }
}

