/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.pemu;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryPemuBean
extends TEGenCfgQueryBean {
    private static final String NOTMONITOR = "32767";
    private static final int NSCMD_CFG_GET_RELAY_USE = 29570;
    private static final int NSCMD_CFG_GET_PMU_SHELF = 29578;
    private static final int NSCMD_CFG_GET_PMU_VOLT_LEVEL = 29574;
    private static final int NOTSUPPORT = 38737;
    private String slotid = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        this.slotid = slotidParam.getValue();
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        Operation tmpOper = null;
        int cmdID = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            tmpOper = (Operation)operationList.get(i);
            cmdID = tmpOper.getCmdid();
            if (cmdID == 29570) {
                this.handleInputCSK(tmpOper);
                return;
            }
            if (cmdID == 29578) {
                this.handleCodeState(tmpOper);
                return;
            }
            if (cmdID != 29574) continue;
            this.handleInVoltLevel(tmpOper);
            return;
        }
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(this.slotid));
        String boardname = board.getBoardName();
        RowParams rowparams = null;
        Param param = null;
        String upLimit = "";
        String downLimit = "";
        short intUpLimit = 0;
        short intDownLimit = 0;
        int boardType = 0;
        int len2 = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len2; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowparams.getRowErrorsCount() == 0) {
                param = new Param("slotid", this.slotid);
                rowparams.addParam(param);
                param = new Param("boardname", boardname);
                rowparams.addParam(param);
            }
            if (null != rowparams.getParam("ENVCTRL_COM_TEMPERUPLIMIT")) {
                if (rowparams.getParam("ENVCTRL_COM_TEMPERUPLIMIT").getValue().equals(NOTMONITOR)) {
                    param = new Param("ENVCTRL_COM_TEMPEMONITOR", "0");
                    rowparams.addParam(param);
                    rowparams.removeParam(rowparams.getParam("ENVCTRL_COM_TEMPERUPLIMIT"));
                } else {
                    param = rowparams.getParam("ENVCTRL_COM_TEMPERUPLIMIT");
                    upLimit = param.getValue();
                    if (!upLimit.equals("/")) {
                        intUpLimit = Integer.valueOf(upLimit).shortValue();
                        upLimit = String.valueOf(intUpLimit);
                    }
                    param.setValue(upLimit);
                    param = new Param("ENVCTRL_COM_TEMPEMONITOR", "1");
                    rowparams.addParam(param);
                }
                if (rowparams.getParam("ENVCTRL_COM_TEMPERDOWNLIMIT").getValue().equals(NOTMONITOR)) {
                    rowparams.removeParam(rowparams.getParam("ENVCTRL_COM_TEMPERDOWNLIMIT"));
                } else {
                    param = rowparams.getParam("ENVCTRL_COM_TEMPERDOWNLIMIT");
                    downLimit = param.getValue();
                    if (!downLimit.equals("/")) {
                        intDownLimit = Integer.valueOf(downLimit).shortValue();
                        downLimit = String.valueOf(intDownLimit);
                    }
                    param.setValue(downLimit);
                }
                boardType = board.getBoardType();
                param = new Param("boardType", String.valueOf(boardType));
                rowparams.addParam(param);
            }
            if (null == rowparams.getParam("ENVCTRL_COM_ENV_TEMP")) continue;
            if (rowparams.getParam("ENVCTRL_COM_ENV_TEMP").getValue().equals(NOTMONITOR)) {
                rowparams.removeParam(rowparams.getParam("ENVCTRL_COM_ENV_TEMP"));
                continue;
            }
            param = rowparams.getParam("ENVCTRL_COM_ENV_TEMP");
            downLimit = param.getValue();
            if (!downLimit.equals("/")) {
                intDownLimit = Integer.valueOf(downLimit).shortValue();
                downLimit = String.valueOf(intDownLimit);
            }
            param.setValue(downLimit);
        }
    }

    void handleInputCSK(Operation oper) {
        int i;
        String use_mode = "";
        int[] int_use_mode = null;
        int code = 0;
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, Integer.parseInt(this.slotid));
        String boardname = board.getBoardName();
        RowParams rowparams = null;
        RowErrors rowerrors = null;
        Param param = null;
        boolean isSuccess = true;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i2 = 0; i2 < len; ++i2) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i2);
            int size = rowparams.getRowErrorsCount();
            for (int j = 0; j < size; ++j) {
                rowerrors = rowparams.getRowErrors(j);
                code = Integer.parseInt(rowerrors.getErrorMessage().getErrorcode());
                if (0 == code) continue;
                isSuccess = false;
                param = rowerrors.getParam("use_and_mode");
                rowerrors.removeParam(param);
                param = rowerrors.getParam("attrId");
                rowerrors.removeParam(param);
            }
        }
        if (!isSuccess) {
            return;
        }
        Output[] outputs = oper.getOutput();
        int outputLen = outputs.length;
        for (i = 0; i < outputLen; ++i) {
            use_mode = outputs[i].getPartValue("use_and_mode");
            if (null == use_mode) continue;
            char[] ch = use_mode.toCharArray();
            int_use_mode = new int[32];
            for (int int_use_mode[j] : ch) {
            }
        }
        this.outputData.getBussinessParams().clearRowParams();
        int len2 = int_use_mode.length;
        for (i = 0; i < len2; i += 2) {
            rowparams = new RowParams();
            param = new Param("nename", TENEListMgr.getInstance().getNE(this.neid).getNEName());
            rowparams.addParam(param);
            param = new Param("slotid", this.slotid);
            rowparams.addParam(param);
            param = new Param("boardname", boardname);
            rowparams.addParam(param);
            param = new Param("switch", "CSK-" + (i / 2 + 1));
            rowparams.addParam(param);
            param = new Param("ENVCTRL_COM_INPUTCSK_USE", String.valueOf(int_use_mode[i]));
            rowparams.addParam(param);
            param = new Param("ENVCTRL_COM_INPUTCSK_ALARMMODE", String.valueOf(int_use_mode[i + 1]));
            rowparams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    void handleCodeState(Operation oper) {
        String[] codeState = new String[4];
        int code = 0;
        RowParams rowparams = null;
        Param param = null;
        boolean isSuccess = true;
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            RowErrors[] rowerrors = rowparams.getRowErrors();
            if (null != rowerrors && rowerrors.length > 1 && 0 != (code = Integer.parseInt(rowerrors[0].getErrorMessage().getErrorcode()))) {
                isSuccess = false;
                param = rowerrors[0].getParam("attrId");
                rowerrors[0].removeParam(param);
            }
            if (null == rowerrors || rowerrors.length < 1) continue;
            int size = rowerrors.length;
            for (int j = 1; j < size; ++j) {
                rowparams.removeRowErrors(rowerrors[j]);
            }
        }
        if (!isSuccess) {
            return;
        }
        Output[] outputs = oper.getOutput();
        int outputLen = outputs.length;
        for (int i = 0; i < outputLen; ++i) {
            code = Integer.parseInt(outputs[i].getFault(0).getCode());
            if (0 != code) {
                return;
            }
            codeState[0] = outputs[i].getPartValue("ENVCTRL_PMU_CODE_STATE1");
            codeState[1] = outputs[i].getPartValue("ENVCTRL_PMU_CODE_STATE2");
            codeState[2] = outputs[i].getPartValue("ENVCTRL_PMU_CODE_STATE3");
            codeState[3] = outputs[i].getPartValue("ENVCTRL_PMU_CODE_STATE4");
        }
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, Integer.parseInt(this.slotid));
        String boardname = board.getBoardName();
        this.outputData.getBussinessParams().clearRowParams();
        int len2 = codeState.length;
        for (int i = 0; i < len2; ++i) {
            rowparams = new RowParams();
            param = new Param("nename", TENEListMgr.getInstance().getNE(this.neid).getNEName());
            rowparams.addParam(param);
            param = new Param("slotid", this.slotid);
            rowparams.addParam(param);
            param = new Param("boardname", boardname);
            rowparams.addParam(param);
            param = new Param("switch", "SWITCH-" + (i + 1));
            rowparams.addParam(param);
            param = new Param("ENVCTRL_PMU_CODE_NAME", String.valueOf(i));
            rowparams.addParam(param);
            param = new Param("ENVCTRL_PMU_CODE_STATE", String.valueOf(codeState[i]));
            rowparams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    void handleInVoltLevel(Operation oper) {
        int code = 0;
        RowParams rowparams = null;
        Param param = null;
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, Integer.parseInt(this.slotid));
        String boardname = board.getBoardName();
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = this.outputData.getBussinessParams().getRowParams(i);
            param = new Param("slotid", this.slotid);
            rowparams.addParam(param);
            param = new Param("boardname", boardname);
            rowparams.addParam(param);
            RowErrors[] rowerrors = rowparams.getRowErrors();
            int size = rowerrors.length;
            for (int j = 0; j < size; ++j) {
                code = Integer.parseInt(rowerrors[j].getErrorMessage().getErrorcode());
                if (0 == code) continue;
                param = rowerrors[j].getParam("ENVCTRL_PMU_INPUTVOLTLEVEL");
                param.setValue("/");
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38737);
        return errorCodeList;
    }

    public boolean isNeedOperationlog() {
        return true;
    }
}

