/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.opticalpower;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Definitions;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;

public class OpticalPowerQueryBean
extends TEGenCfgQueryBean {
    private static final int INPOWER_EVENT = 203;
    private static final int OUTPOWER_EVENT = 200;
    private static final int SUM_INPOWER_EVENT = 212;
    private static final int SUM_INPOWER_EVENT_R2 = 14975;
    private static final int OUTPOWER_EVENT_B2LMU1 = 14951;
    private static final int OUTPOWER_EVENT_B2LMU23 = 14948;
    private static final int SUM_OUTPOWER_EVENT = 215;
    private static final int FILTER_MAX = Integer.MAX_VALUE;
    private static final int FILTER_MIN = Integer.MIN_VALUE;
    private static final int FIND_NULL_ERROR_CODE_38410 = 38410;
    private static final int FIND_NULL_ERROR_CODE_38662 = 38662;

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        ArrayList tempOperationList = this.getOperationList(neid, operationList);
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)tempOperationList, (ArrayList)filterErrorCodeList);
        RowParams rowParams = null;
        if (this.outputData.getBussinessParams().getRowParamsCount() > 0 && 10 > (rowParams = this.outputData.getBussinessParams().getRowParams(0)).getParamCount()) {
            this.outputData.getBussinessParams().removeRowParams(0);
        }
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (rowParams.getParamCount() == 0 || rowParams.getParam("slotid").getValue().equals("0") || rowParams.getParam("port") == null || rowParams.getParam("port").getValue().equals("0")) {
                if (rowParams.getRowErrorsCount() != 0) continue;
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            if (this.isIntValue(rowParams, "W32PORT_ATTR_MININPOW")) {
                String strMinInpow = rowParams.getParam("W32PORT_ATTR_MININPOW").getValue();
                int intMinInpow = new BigInteger(strMinInpow).intValue();
                if (Integer.MAX_VALUE == intMinInpow || Integer.MIN_VALUE == intMinInpow) {
                    rowParams.getParam("W32PORT_ATTR_MININPOW").setValue("/");
                } else {
                    float minInpow = (float)intMinInpow / 10.0f;
                    rowParams.getParam("W32PORT_ATTR_MININPOW").setValue("" + minInpow);
                }
            }
            if (!this.isIntValue(rowParams, "W32PORT_ATTR_MAXINPOW")) continue;
            String strMaxInpow = rowParams.getParam("W32PORT_ATTR_MAXINPOW").getValue();
            int intMaxInpow = new BigInteger(strMaxInpow).intValue();
            if (Integer.MAX_VALUE == intMaxInpow || Integer.MIN_VALUE == intMaxInpow) {
                rowParams.getParam("W32PORT_ATTR_MAXINPOW").setValue("/");
                continue;
            }
            float maxInpow = (float)intMaxInpow / 10.0f;
            rowParams.getParam("W32PORT_ATTR_MAXINPOW").setValue("" + maxInpow);
        }
    }

    private boolean isIntValue(RowParams rowParams, String attrId) {
        return null != rowParams.getParam(attrId) && !rowParams.getParam(attrId).getValue().equals("/");
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38410);
        errorCodeList.add(38662);
        return errorCodeList;
    }

    private ArrayList getOperationList(int neID, ArrayList operationList) {
        ArrayList<Object> rtnOperList = new ArrayList<Object>();
        Operation operation = null;
        Output output = null;
        Part part = null;
        if (null != operationList) {
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                operation = (Operation)operationList.get(i);
                if (operation.getName().equalsIgnoreCase("NSCMD_PER_GET_CURDATA_1")) {
                    Input input = operation.getInput();
                    int slotID = Integer.parseInt(input.getPart("slotid").getValue());
                    if (operation.getOutputCount() == 0) continue;
                    output = operation.getOutput(0);
                    Part[] partArr = output.getPart();
                    int len2 = partArr.length;
                    for (int k = 0; k < len2; ++k) {
                        if (!partArr[k].getName().equalsIgnoreCase("record")) continue;
                        if (partArr[k].getValue() == null) {
                            return operationList;
                        }
                        byte[] bValue = partArr[k].getValue().getBytes();
                        int nParaSize = bValue.length;
                        output.removePart(partArr[k]);
                        output.getPart("periodstime").setValue("");
                        operation.removeOutput(output);
                        int nCount = 18;
                        int nPos = 0;
                        while (nPos + nCount <= nParaSize) {
                            Output tmpOutput = (Output)output.clone();
                            byte[] bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                            int eventType = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                            if (eventType == 203 || eventType == 200 || eventType == 212 || eventType == 215 || eventType == 14975 || eventType == 14951 || eventType == 14948) {
                                bTmp = new byte[2];
                                System.arraycopy(bValue, nPos + 4, bTmp, 0, 2);
                                int port = IOStreamConvertor.readPositiveShort((byte[])bTmp, (int)0);
                                bTmp = new byte[4];
                                System.arraycopy(bValue, nPos + 6, bTmp, 0, 4);
                                int path = IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0);
                                boolean flag = false;
                                int count = operation.getOutputCount();
                                for (int j = 0; j < count; ++j) {
                                    Output out = operation.getOutput(j);
                                    String slot = out.getPartValue("slotid");
                                    String portid = out.getPartValue("port");
                                    String pathid = out.getPartValue("path");
                                    if (slot == null || portid == null || pathid == null || Integer.parseInt(slot) != slotID || Integer.parseInt(portid) != port || Integer.parseInt(pathid) != path) continue;
                                    tmpOutput = out;
                                    flag = true;
                                    break;
                                }
                                bTmp = new byte[8];
                                System.arraycopy(bValue, nPos + 10, bTmp, 0, 8);
                                int powerValue = IOStreamConvertor.readPositiveLong((byte[])bTmp, (int)0);
                                if (eventType == 203 || eventType == 212 || eventType == 14975) {
                                    float inputPower = (float)powerValue / 10.0f;
                                    if (tmpOutput.getPart("W32PORT_ATTR_INPUTPOWER") == null) {
                                        part = new Part();
                                        part.setType("int");
                                        part.setLength(2);
                                        part.setName("W32PORT_ATTR_INPUTPOWER");
                                        part.setValue(inputPower + "");
                                        tmpOutput.addPart(part);
                                    } else {
                                        tmpOutput.getPart("W32PORT_ATTR_INPUTPOWER").setValue(inputPower + "");
                                    }
                                } else if (eventType == 200 || eventType == 215 || eventType == 14951 || eventType == 14948) {
                                    float outputPower = (float)powerValue / 10.0f;
                                    if (tmpOutput.getPart("W32PORT_ATTR_OUTPUTPOWER") == null) {
                                        part = new Part();
                                        part.setType("int");
                                        part.setLength(2);
                                        part.setName("W32PORT_ATTR_OUTPUTPOWER");
                                        part.setValue(outputPower + "");
                                        tmpOutput.addPart(part);
                                    } else {
                                        tmpOutput.getPart("W32PORT_ATTR_OUTPUTPOWER").setValue(outputPower + "");
                                    }
                                }
                                if (!flag) {
                                    part = new Part();
                                    part.setType("byte");
                                    part.setLength(1);
                                    part.setName("port");
                                    part.setValue(port + "");
                                    tmpOutput.addPart(part);
                                    part = new Part();
                                    part.setType("int");
                                    part.setLength(2);
                                    part.setName("path");
                                    part.setValue(path + "");
                                    tmpOutput.addPart(part);
                                    operation.addOutput((Output)tmpOutput.clone());
                                }
                            }
                            nPos += nCount;
                        }
                        break;
                    }
                    rtnOperList.add(operation.clone());
                    continue;
                }
                rtnOperList.add(operation.clone());
            }
        }
        return rtnOperList;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return attrId.equals("W32PORT_ATTR_MININPOW") || attrId.equals("W32PORT_ATTR_MAXINPOW");
    }

    public void getQueryAttrOperationList(Definitions definitions, TEGenCfgFunAttr funAttr, ArrayList operationList, String attrId, Datainterface inputData) {
        if (null == funAttr) {
            return;
        }
        String operationName = funAttr.getPtcode();
        ArrayList<String> operationNameList = new ArrayList<String>();
        operationNameList.add(operationName);
        String additioncmd = funAttr.getAdditionCmd();
        if (null != additioncmd && !"".equals(additioncmd.trim())) {
            operationNameList.add(additioncmd);
        }
        Datainterface convertData = inputData;
        if (this.isNeedExpandOperObj(attrId) && null == (convertData = this.performExpandOperObj(attrId, funAttr, inputData))) {
            return;
        }
        ArrayList subOperationList = TEGenCfgDataConvertor.convertToOperation((TEGenCfgFunAttr)funAttr, (Datainterface)convertData, (int)this.neid, operationNameList);
        if (null == subOperationList) {
            return;
        }
        RowParams inputRow = inputData.getBussinessParams().getRowParams(0);
        int operlen = subOperationList.size();
        for (int i = 0; i < operlen; ++i) {
            String inputvalue;
            Operation subOper = (Operation)subOperationList.get(i);
            if (inputRow.getParam("reptype") == null || subOper.getInput().getPart("reptype") == null) break;
            String curvalue = subOper.getInput().getPartValue("reptype");
            if (curvalue.equals(inputvalue = inputRow.getParam("reptype").getValue())) continue;
            subOper.getInput().setPartValue("reptype", inputvalue);
        }
        if (!subOperationList.isEmpty()) {
            this.queryAttrListBuff.append(",").append(this.res.getString(attrId));
            operationList.addAll(subOperationList);
        }
    }

    public ArrayList getQueryOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        ArrayList operList = super.getQueryOperationList(funCmd, inputData);
        int size = operList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = (Operation)operList.get(i);
            if (oper.getName().indexOf("NSCMD_CFG_GET_ALM_TH") < 0) continue;
            int slotid = Integer.parseInt(oper.getInput().getPart("slotid").getValue());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            if (boardType == 1228 || boardType == 1630) {
                oper.getInput().setPartValue("reptype", "148");
            }
            if (boardType != 1628) continue;
            oper.getInput().setPartValue("reptype", "4344");
        }
        return operList;
    }
}

