/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.marine.ophbyte.otn;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgSetBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.util.ArrayList;

public class TEOTNSetBean
extends TEGenCfgSetBean {
    private static final String[][] ODUGRADE = new String[][]{{"ODU1"}, {"ODU2"}, {"ODU3"}, {"ODU5g"}, {"ODU0"}, {"ODU4"}, {"ODUFLEX"}};
    private static final String[][] OTUGRADE = new String[][]{{"OTU1"}, {"OTU2"}, {"OTU3"}, {"OTU5g"}, {"OTU0"}, {"OTU4"}};
    private static final String[][] TCMLEVEL = new String[][]{{"TCM1"}, {"TCM2"}, {"TCM3"}, {"TCM4"}, {"TCM5"}, {"TCM6"}};
    private static final int PMLEVEL = 1;
    private static final int SMLEVEL = 8;
    private static final int OTSLEVEL = 9;
    private static final int GRADE_NULL = 255;

    public TEOTNSetBean() {
        this.TIME_OUT = 120;
    }

    public ArrayList getSetOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        this.handleOtnModelPath(inputData);
        ArrayList operationList = super.getSetOperationList(funCmd, inputData);
        return operationList;
    }

    private void handleOtnModelPath(Datainterface inputData) {
        int slotId = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotId);
        TEOTNModelDataMgr otnModelInstance = TEOTNModelDataMgr.getInstance();
        int grade = otnModelInstance.getGradeFromBoard(boardType);
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            int layer;
            int nePath;
            RowParams rowparams = inputData.getBussinessParams().getRowParams(i);
            int nmPath = 1;
            if (rowparams.getParam("path") != null && rowparams.getParam("path").getValue() != null) {
                nmPath = Integer.parseInt(rowparams.getParam("path").getValue());
            }
            if (rowparams.getParam("grade") != null && rowparams.getParam("grade").getValue() != null && rowparams.getParam("grade").getValue() != "") {
                grade = Integer.parseInt(rowparams.getParam("grade").getValue());
                if (grade > 1200) {
                    grade -= 1200;
                }
                rowparams.getParam("grade").setValue(String.valueOf(grade));
            }
            if ((nePath = otnModelInstance.getNePath(layer = this.getOtnLayer(), grade, nmPath, boardType)) == -1) continue;
            rowparams.getParam("path").setValue(String.valueOf(nePath));
        }
    }

    private int getOtnLayer() {
        int layer = -1;
        switch (this.subFunc.getCode()) {
            case 2105848: {
                layer = 1;
                break;
            }
            case 2105854: {
                layer = 1;
                break;
            }
            case 2105852: {
                layer = 8;
                break;
            }
            case 2106555: {
                layer = 1;
                break;
            }
            case 2105850: {
                layer = 1;
                break;
            }
        }
        return layer;
    }

    public String getOperObjStr(TENE neObj, Datainterface inputData) {
        StringBuffer operObj = new StringBuffer();
        if (null == neObj) {
            operObj.append(String.valueOf(this.neid));
        } else {
            operObj.append(neObj.getNEName());
        }
        int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        int portID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("port").getValue());
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("path");
        int path = 255;
        if (null != param) {
            path = Integer.parseInt(param.getValue());
        }
        operObj.append("-");
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
        if (!"".equals(subrackName)) {
            operObj.append(subrackName).append("-");
        }
        operObj.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)).append("-").append(TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
        operObj.append("-").append(TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, portID));
        param = inputData.getBussinessParams().getRowParams(0).getParam("grade");
        int grade = 255;
        if (null != param && (grade = Integer.parseInt(param.getValue())) > 1200) {
            grade -= 1200;
        }
        int level = -1;
        if (null != inputData.getBussinessParams().getRowParams(0).getParam("level")) {
            level = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("level").getValue());
        }
        int nmPath = -1;
        nmPath = path > 1200 ? path : TEOTNModelDataMgr.getInstance().getNmPath(level, grade, path, boardtype);
        if (nmPath > 1200) {
            operObj.append("-").append(TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(nmPath));
        } else {
            if (255 != grade) {
                if (level == 1) {
                    operObj.append("-").append(ODUGRADE[grade - 1][0]);
                } else if (level == 8) {
                    operObj.append("-").append(OTUGRADE[grade - 1][0]);
                }
            }
            if (255 != path) {
                operObj.append("-").append(path);
            }
        }
        if (level != -1 && level != 1 && level != 8 && level != 9) {
            operObj.append("-").append(TCMLEVEL[level - 2][0]);
        }
        return operObj.toString();
    }

    public String specialHandle(String attrId, String attrValue, Datainterface inputData, String actvalue, TEResourceUtil res) {
        int value = Integer.parseInt(actvalue);
        if (value > 6 && value < 128 && value != 16 && value != 17 && value != 32 || value > 143 && value < 253) {
            return actvalue + "-" + res.getString(attrId + "_" + "7");
        }
        if (value > 127 && value < 144) {
            return actvalue + "-" + res.getString(attrId + "_" + "128");
        }
        return actvalue + "-" + attrValue;
    }

    public boolean isNeedHandle(String attrId, String attrValue) {
        return attrId.equals("SR_OTN_OTN_PT");
    }
}

